/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.obj;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.obj.controller;
import jcm.mod.obj.optimisation;
import jcm.mod.obj.sresdata;
import jcm.mod.obj.sresext;
import jcm.mod.obj.stabilisation;
import jcm.mod.regemit.emitbase;

public class globco2emit
extends module {
    public param fosconv = new param(new Object[]{"foshistscenconv", "percent&per&year", colfont.dkbrown, Float.valueOf(2.0f), Float.valueOf(0.0f), Float.valueOf(100.0f), complexity.expert});
    public param lucconv = new param(new Object[]{"luchistscenconv", "percent&per&year", colfont.dkgreen, Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(100.0f), complexity.expert});
    public param potlucfrac = new param(new Object[]{"potlucfrac", "", colfont.green, 0.5, 0, 2, complexity.expert});
    public param potlucconvergence = new param(new Object[]{"potlucfracConverg", "", colfont.green, 0.5, 0, 2, complexity.expert});
    public param fixedfrac = new param(new Object[]{"fix luc fossil ratio", false, complexity.experimental});
    public param pulse = new param(new Object[]{"one year pulse", 0, 0, 1000, "MtC", complexity.experimental});
    public curve fossil;
    public curve lucquota;
    public curve totemit;
    public curve potlucbase = new curve(new Object[]{"globpotlucbase", colfont.ltgreen, fsyluc, gey, complexity.expert});
    public curve potlucquota = new curve(new Object[]{"globpotlucquota", colfont.dkgreen, complexity.expert});
    public curve fossilbase = new curve("fossilemitbase", colfont.dkred, fsyfos, gey);
    public curve lucfbase = new curve("lucemitbase", colfont.dkorange, 2000, gey);
    public curveset globco2curves;
    carboncycle carb;
    curveset emitfosbase;
    curveset emitlucbase;
    private float alpha;
    public float plf;
    int sci;
    public boolean nopolicy;
    public boolean houghton;

    public void initsetup() {
        this.follows(this.gm(emitbase.class).history);
        this.follows(this.gm(emitbase.class).future);
        this.follows(sresext.class);
        this.setaffectedby(this.gm(controller.class).objective);
        this.carb = this.gm(carboncycle.class);
        this.fossil = this.carb.fossil;
        this.lucquota = this.carb.lucf;
        this.totemit = this.carb.totemit;
        this.globco2curves = new curveset("globco2curves", "mega&ton&carbon&per&year", this.fossilbase, this.lucfbase, this.fossil, this.lucquota, this.totemit, this.potlucbase, this.potlucquota);
        this.potlucquota.set(gsy, 0.0f);
        this.emitfosbase = this.gm(emitbase.class).emitfosbase;
        this.emitlucbase = this.gm(emitbase.class).emitlucbase;
        this.affectsfutureonly = true;
    }

    public void setinteractions() {
        param cob = this.gm(controller.class).objective;
        this.follows(stabilisation.class, cob.chosen.equals("stabilisation"));
        this.follows(optimisation.class, cob.chosen.equals("optimisation"));
    }

    public void precalc() {
        this.nopolicy = this.gm(controller.class).objective.chosen.equals("nopolicy");
        this.plf = -((float)(this.potlucfrac.getval() / 100.0));
        this.sci = this.gm(controller.class).scenario.getchosenindex();
        this.houghton = this.gm(CalcLucEmit.class).lucsource.chosen.equals("Houghton");
        fsyluc = this.houghton ? 2001 : 2003;
    }

    public void calcstep() {
        if (year > 1755 && this.gm(CalcLucEmit.class).lucsource.chosen.equals("Inverse") && year < fsyluc) {
            this.gm(carboncycle.class).inverseluc();
        } else if (year < fsyluc) {
            this.lucquota.set(this.gm(emitbase.class).emitlucbase.calctot());
        }
        if (year < fsyluc) {
            this.totemit.set(this.fossil.get() + this.lucquota.get());
        }
        if (year > gsy) {
            this.potlucquota.set(this.potlucquota.get(year - 1) + this.lucquota.get(year - 1) * this.plf);
        }
        if (year >= fsyfos && year <= 2100) {
            this.fossilbase.set((float)((double)(1000.0f * sresdata.interp(sresdata.fosemit, this.sci, year)) + (1.0 - this.fosconv.getval() / 100.0) * (double)((year == fsyfos ? this.emitfosbase.calctot(year - 1) : this.fossilbase.get(year - 1)) - 1000.0f * sresdata.interp(sresdata.fosemit, this.sci, year - 1))));
            this.emitfosbase.topdownscale(this.fossilbase.get(), true);
        }
        if (year >= 2000 && year < fsyluc) {
            float a = 0.0f;
            for (int i = -5; i < 0; ++i) {
                a += this.lucquota.get(year + i);
            }
            this.lucfbase.set(a / 5.0f);
        }
        if (year >= fsyluc && year <= 2100) {
            this.lucfbase.set((float)((double)(1000.0f * sresdata.interp(sresdata.lucemit, this.sci, year)) + (1.0 - this.lucconv.getval() / 100.0) * (double)(this.lucfbase.get(year - 1) - 1000.0f * sresdata.interp(sresdata.lucemit, this.sci, year - 1))));
        }
        if (year >= fsyluc && year < fsyfos) {
            this.lucquota.set(this.lucfbase.get());
            this.totemit.set(this.fossil.get() + this.lucquota.get());
        }
        if (year > 2100) {
            this.fossilbase.set(this.emitfosbase.calctot());
            float fac = this.lucfbase.get(year - 1) < this.potlucbase.get(year - 1) ? 1.0f : (float)this.potlucconvergence.getval() / 100.0f;
            this.lucfbase.set(fac * this.potlucbase.get(year - 1) + (1.0f - fac) * this.lucfbase.get(year - 1));
        }
        if (year >= fsyluc) {
            this.potlucbase.set(year == fsyluc ? this.potlucquota.get() : this.potlucbase.get(year - 1) + this.lucfbase.get() * this.plf);
        }
        if (year >= fsyfos) {
            this.alpha = (this.lucfbase.get() - this.potlucbase.get()) / this.fossilbase.get();
            if (this.nopolicy) {
                this.fossil.set(this.fossilbase.get());
                this.lucquota.set(this.lucfbase.get());
                this.totemit.set(this.fossilbase.get() + this.lucfbase.get());
            } else {
                this.lucquota.set(this.fixedfrac.istrue() ? this.totemit.get() * this.lucquota.get(fsyfos - 1) / this.totemit.get(fsyfos - 1) : (this.totemit.get() * this.alpha + this.potlucquota.get()) / (1.0f + this.alpha));
                this.fossil.set(this.totemit.get() - this.lucquota.get());
                if (this.fossil.get() < 0.0f) {
                    this.fossil.set(0.0f);
                    this.lucquota.set(this.totemit.get());
                }
                if (this.lucquota.get() < this.potlucquota.get()) {
                    this.lucquota.set(this.potlucquota.get());
                    this.totemit.set(this.lucquota.get() + this.fossil.get());
                }
            }
        }
        if (year == 2010) {
            this.totemit.set(this.totemit.get() + (float)this.pulse.getval());
        }
    }
}

