/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.makederiv;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.plot.baseplot;

public class XYplot
extends baseplot {
    param sy;
    param ey;
    curveset qqx;
    curveset qqy;
    curvar qqv;

    public XYplot(curveset qq) {
        this(new Object[]{qq});
    }

    public XYplot(Object[] args) {
        for (Object o : args) {
            if (o instanceof curvar) {
                this.qqv = (curvar)o;
                this.qq = this.qqv;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(o.toString())));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.qqy = this.qqv.linkqq.get(0);
        this.qqx = this.qqv.linkqq.get(1);
        double minsy = Math.max(this.qqy.sy, this.qqx.sy);
        double maxey = Math.min(this.qqy.ey, this.qqx.ey);
        this.sy = new param(new Object[]{"from", 2002, minsy, maxey, "year"}){

            public void precalc() {
                XYplot.this.ey.min = this.val - 1.0;
            }
        };
        this.ey = new param("until", 2002, minsy, maxey, "year");
        register.addlink(this, this.sy);
        register.addlink(this, this.ey);
        this.setup();
        this.xsv.setMinimumSize(new Dimension(0, 40));
        this.plot.add((Component)new paramValueChooser(this.sy, new Object[0]), "North");
        this.plot.add((Component)new paramValueChooser(this.ey, new Object[0]), "North");
    }

    public void doplot() {
        super.repaint();
    }

    void makeplot() {
        this.plot = new scatter();
    }

    void makescales() {
        this.yscale = this.qqy.getyscale();
        this.xscale = this.qqx.getyscale();
        this.xscale.type = param.Type.Xscale;
    }

    public void fillMenu(jcmMenu popup) {
        popup.add(makederiv.makeDerivMenu(curve.Type.extra, this.qq));
        popup.addSeparator();
        super.fillMenu(popup);
    }

    void plot(Graphics2D g2, curveset qqx, curveset qqy, float xyf, float ysf) {
        GeneralPath line = new GeneralPath();
        for (Object o : qqy.map.keySet()) {
            if (!qqx.map.containsKey(o)) continue;
            g2.setColor(qqy.map.get((Object)o).color);
            if ((int)this.sy.getval() < (int)this.ey.getval()) {
                line.reset();
                line.moveTo(qqx.get(o, (int)this.sy.val) * xyf, qqy.get(o, (int)this.sy.val));
                for (int year = (int)this.sy.val + 1; year <= (int)this.ey.val; ++year) {
                    line.lineTo(qqx.get(o, year) * xyf, qqy.get(o, year));
                }
                try {
                    g2.draw(line);
                }
                catch (Error e) {
                    report.deb(e, "line drawing error");
                }
                continue;
            }
            float rad = -12.0f / ysf;
            g2.draw(new Ellipse2D.Float(qqx.get(o, (int)this.sy.val) * xyf - rad, qqy.get(o, (int)this.sy.val) - rad, rad, rad));
        }
    }

    class scatter
    extends JPanel {
        scatter() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            lookandfeel.setAntiAlias(g);
            Graphics2D g2 = (Graphics2D)g.create();
            AffineTransform oldat = g2.getTransform();
            float xsf = (float)this.getWidth() / XYplot.this.xscale.range();
            float ysf = (float)(-this.getHeight()) / XYplot.this.yscale.range();
            float xyf = xsf / ysf;
            g2.scale(ysf, ysf);
            g2.translate(-XYplot.this.xscale.min() * xyf, -XYplot.this.yscale.max());
            g2.setStroke(new BasicStroke(Math.abs(XYplot.this.yscale.range()) / 250.0f));
            for (curveset qqy : XYplot.this.qqv.linkqq) {
                if (qqy == XYplot.this.qqx) continue;
                XYplot.this.plot(g2, XYplot.this.qqx, qqy, xyf, ysf);
            }
            g2.setTransform(oldat);
            g2.dispose();
            XYplot.this.ready = true;
        }
    }
}

