/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jcm.core.itf.plotlink;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;

public class paramValueChooser
extends Box
implements plotlink,
ActionListener {
    param p;
    jcmslider jcms;
    JLabel lab1 = new JLabel();
    JLabel lab2 = new JLabel();
    JTextField tf = new JTextField("      ");
    Box horizbox = new Box(0);
    int sliderlength = 200;

    public void setParamName(String name) {
        this.p = (param)register.findiob(name);
        param.Type cfr_ignored_0 = this.p.type;
        if (this.p.type != param.Type.value) {
            this.p = null;
        }
        try {
            this.setup();
            this.doplot();
        }
        catch (Exception e) {
            report.deb(e, "can't find param for " + name);
        }
    }

    public paramValueChooser() {
        super(1);
    }

    public paramValueChooser(param p, Object ... args) {
        super(1);
        this.p = p;
        this.setup();
    }

    void setup() {
        this.lab1.setText(this.p.getLabel());
        if (this.p.units.units != "") {
            this.lab2.setText(" (" + labman.getShort(this.p.units.units) + ")");
        }
        this.lab1.setForeground(this.p.color);
        this.lab1.setFont(colfont.normalfont);
        this.lab2.setFont(colfont.normalfont);
        this.tf.setFont(colfont.normalfont);
        FontMetrics fm = this.tf.getFontMetrics(this.tf.getFont());
        int h = fm.getHeight() + 4;
        int w = h * 3;
        this.tf.setPreferredSize(new Dimension(w, h));
        this.tf.setMaximumSize(new Dimension(w, h));
        this.tf.setMinimumSize(new Dimension(w, h));
        Component gap = Box.createRigidArea(new Dimension(10, 0));
        this.horizbox.add(this.tf);
        this.horizbox.add(gap);
        this.horizbox.add(this.lab1);
        this.horizbox.add(this.lab2);
        this.horizbox.add(Box.createHorizontalGlue());
        this.add(this.horizbox);
        this.jcms = new jcmslider();
        this.add(this.jcms);
        this.tf.addActionListener(this);
        for (Component c : this.getComponents()) {
            c.setBackground(Color.white);
        }
        this.setToolTipText(this.p.getinfo());
        register.addlink(this, this.p);
    }

    public void doplot() {
        if (this.p == null) {
            return;
        }
        String s = this.p.units.round(this.p.val, this.p.dp);
        this.tf.setText(s);
        this.setToolTipText(this.p.getinfo());
        this.jcms.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        this.p.set(this.p.units.unround(Double.valueOf(this.tf.getText())));
    }

    public void addNotify() {
        super.addNotify();
        if (this.p != null) {
            this.doplot();
        }
    }

    class jcmslider
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        int x;
        int xd;
        int w;
        int h;

        public jcmslider() {
            this.setPreferredSize(new Dimension(paramValueChooser.this.sliderlength, 12));
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        void setx() {
            this.x = (int)((double)this.w * (paramValueChooser.this.p.val - paramValueChooser.this.p.min) / (paramValueChooser.this.p.max - paramValueChooser.this.p.min));
            this.xd = (int)((double)this.w * (paramValueChooser.this.p.defval - paramValueChooser.this.p.min) / (paramValueChooser.this.p.max - paramValueChooser.this.p.min));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.w = paramValueChooser.this.sliderlength;
            this.h = this.getHeight();
            this.setx();
            this.draw(g, false);
        }

        void draw(Graphics g, boolean pending) {
            if (g != null) {
                Color m = paramValueChooser.this.p.color;
                Color d = new Color(m.getRed() / 2, m.getGreen() / 2, m.getBlue() / 2);
                Color l = new Color(255 - (255 - m.getRed()) / 2, 255 - (255 - m.getGreen()) / 2, 255 - (255 - m.getBlue()) / 2);
                g.setColor(m);
                g.drawRoundRect(2, this.h - 8, this.w - 4, 4, 3, 3);
                g.setColor(l);
                g.fillRoundRect(2, this.h - 7, this.x - 3, 3, 3, 3);
                g.setColor(Color.black);
                g.fillRoundRect(this.x - 5, 1, 10, this.h - 2, 2, 2);
                g.drawRect(this.xd - 2, 2, 4, this.h - 4);
                g.setColor(pending ? Color.white : l);
                g.fillRoundRect(this.x - 3, this.h / 2 - 3, 7, 7, 1, 1);
                g.setColor(pending ? Color.gray : d);
                g.fillRoundRect(this.x - 3 - 1, this.h / 2 - 3 - 1, 7, 7, 1, 1);
                g.setColor(pending ? Color.white : m);
                g.fillRoundRect(this.x - 3, this.h / 2 - 3, 6, 6, 1, 1);
            }
        }

        void move(int ex) {
            this.x = ex;
            this.draw(this.getGraphics(), true);
            paramValueChooser.this.p.set(paramValueChooser.this.p.min + (paramValueChooser.this.p.max - paramValueChooser.this.p.min) * (double)this.x / (double)this.w);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.contains(e.getPoint())) {
                this.move(e.getX());
            }
            e.consume();
        }

        public void mouseClicked(MouseEvent e) {
            if (this.contains(e.getPoint())) {
                this.move(e.getX());
            }
            e.consume();
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

