/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.ob.packageob;
import jcm.core.ob.root;
import jcm.core.ob.world;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.FilterToolBar;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.showpan;

public class jcmTree
extends JPanel
implements TreeExpansionListener,
plotlink {
    JTree tree;
    jcmTreeModel tm;
    final jcmTree treemaker = this;
    boolean insetup = false;
    boolean firstsetup = true;
    Map<param, TreePath> visparams = new HashMap<param, TreePath>();
    infob io = null;
    infob oldio = null;
    Rectangle tprect;
    Rectangle oldtprect;
    jcmMenu pop = new jcmMenu(new Object[0]);
    public static interacob restruclink = new interacob("tree struc link");
    param level = complexity.defaultcomplexity;
    Set<filter.filtertype> filters = new HashSet<filter.filtertype>(Arrays.asList(filter.filtertype.NeededParams, filter.filtertype.Curves, filter.filtertype.Maps));
    plotlink restruc = new plotlink(){

        public void doplot() {
            try {
                if (jcmTree.this.filters.contains((Object)filter.filtertype.NeededParams)) {
                    jcmTree.restruclink.needed = false;
                }
                if (loop.changeTreeStruc) {
                    Object[] paths = jcmTree.this.getOpenPaths();
                    for (param p : jcmTree.this.visparams.keySet()) {
                        register.removelink(jcmTree.this.replot, p);
                    }
                    jcmTree.this.insetup = true;
                    for (TreePath treePath : paths) {
                        if (!jcmTree.this.tree.isVisible(treePath)) continue;
                        jcmTree.this.tree.collapsePath(treePath);
                    }
                    jcmTree.this.insetup = false;
                    jcmTree.this.makeNewModel(new Object[0]);
                    jcmTree.this.tree.setModel(jcmTree.this.tm);
                    jcmTree.this.tree.treeDidChange();
                    jcmTree.this.expandPaths(paths);
                    for (int row = 0; row < jcmTree.this.tree.getRowCount(); ++row) {
                        TreePath tp = jcmTree.this.tree.getPathForRow(row);
                        Object oe = tp.getLastPathComponent();
                        if (!(oe instanceof curveset) || ((curveset)oe).getObs() == null) continue;
                        for (infob o : ((curveset)oe).getObs()) {
                            if (!(o instanceof curveset) || !((curveset)o).justadded) continue;
                            jcmTree.this.tree.expandPath(tp);
                            ((curveset)o).justadded = false;
                        }
                    }
                }
            }
            catch (Exception e) {
                report.deb("EXCEPTION: Tree plotting problem");
            }
        }

        public boolean isShowing() {
            return jcmTree.this.tree.isShowing();
        }
    };
    plotlink replot = this;
    MouseMotionAdapter mma = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent e) {
            if (e.getComponent() != jcmTree.this.tree) {
                e.translatePoint(e.getComponent().getX(), e.getComponent().getY());
            }
            if (jcmTree.this.insidepopup(e)) {
                return;
            }
            if (e.isConsumed()) {
                return;
            }
            TreePath tp = jcmTree.this.tree.getPathForLocation(e.getX(), e.getY());
            if (tp == null) {
                tp = jcmTree.this.tree.getPathForLocation(e.getX() - 100, e.getY());
            }
            if (tp != null) {
                jcmTree.this.tprect = jcmTree.this.tree.getPathBounds(tp);
                Object o = tp.getLastPathComponent();
                jcmTree.this.io = o != null && o instanceof infob ? (infob)o : null;
            } else {
                jcmTree.this.io = null;
            }
            if (jcmTree.this.oldio != jcmTree.this.io) {
                Graphics2D g = (Graphics2D)jcmTree.this.tree.getGraphics();
                if (jcmTree.this.oldtprect != null) {
                    g.setColor(jcmTree.this.tree.getBackground());
                    g.draw(jcmTree.this.oldtprect);
                }
                if (jcmTree.this.io != null && jcmTree.this.tprect != null) {
                    g.setColor(jcmTree.this.io.color);
                    g.draw(jcmTree.this.tprect);
                }
                jcmTree.this.pop.removeAll();
                jcmTree.this.pop.list.clear();
                jcmTree.this.pop.getPopupMenu().setVisible(false);
                if (jcmTree.this.io != null) {
                    jcmTree.this.io.fillMenu(jcmTree.this.pop, jcmTree.this.filters);
                } else if (e.getX() > 100) {
                    // empty if block
                }
                if (jcmTree.this.pop.list.size() > 0) {
                    jcmTree.this.pop.show(jcmTree.this.tree, Math.min(jcmTree.this.tprect.x + jcmTree.this.tprect.width - 8, jcmTree.this.getWidth() - 24), e.getY() - 16);
                }
                jcmTree.this.oldio = jcmTree.this.io;
                jcmTree.this.oldtprect = jcmTree.this.tprect;
            }
        }
    };
    MouseAdapter ma = new MouseAdapter(){

        public void mouseExited(MouseEvent e) {
            if (e.getComponent() != jcmTree.this.tree) {
                e.translatePoint(e.getComponent().getX(), e.getComponent().getY());
            }
            if (jcmTree.this.insidepopup(e)) {
                return;
            }
            if (e.isConsumed()) {
                return;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!jcmTree.this.pop.getPopupMenu().contains(e.getPoint())) {
                filter.filtertype donef = null;
                TreePath tp = jcmTree.this.tree.getPathForLocation(e.getX(), e.getY());
                if (tp != null && tp != jcmTree.this.tree.getPathForRow(0)) {
                    if (jcmTree.this.io != null && jcmTree.this.tm.isLeaf(jcmTree.this.io)) {
                        if (!(jcmTree.this.io instanceof param) && jcmTree.this.io.actions != null && jcmTree.this.io.actions.size() > 0) {
                            donef = jcmTree.this.io.doFirstEnabledAction(jcmTree.this.filters);
                        }
                    } else if (jcmTree.this.tree.isExpanded(tp)) {
                        jcmTree.this.tree.collapsePath(tp);
                    } else {
                        jcmTree.this.tree.expandPath(tp);
                    }
                }
                if (jcmTree.this.io != null && donef != filter.filtertype.Doc) {
                    docview.helponclick(jcmTree.this.io.getName());
                }
            }
        }
    };

    public jcmTree(Object[] args) {
        this.setup(args);
    }

    public jcmTree(Object arg) {
        this.setup(new Object[]{arg});
    }

    public jcmTree() {
        this.setup(new Object[0]);
    }

    public void setup(Object[] args) {
        this.makeNewModel(args);
        this.makeNewTree();
        this.addClickEffect();
        this.addRestrucLinks();
        this.setupPanel();
        this.expandPaths(args);
    }

    public void makeNewModel(Object ... args) {
        if (args.length > 0 && args[0] != null) {
            infob initroot = null;
            if (args[0] instanceof infob) {
                initroot = (infob)args[0];
            } else {
                String s = args[0].toString().substring(1, args[0].toString().length() - 1);
                initroot = world.worldsob.find(s);
                if (initroot == null) {
                    initroot = root.rootob.find(s);
                }
                if (initroot == null) {
                    initroot = root.rootob;
                }
            }
            this.tm = new jcmTreeModel(initroot);
            report.deb("init root of tree: " + initroot + " (" + initroot.getClass() + ") " + initroot.getFullName() + " enabledobs " + initroot.getEnabledObs(this.filters));
        } else if (this.tm != null && this.tm.root != null && (this.tm.root instanceof packageob && !(this.tm.root instanceof world) || this.tm.root instanceof module)) {
            this.tm = new jcmTreeModel(this.tm.root);
        } else {
            this.tm = new jcmTreeModel(root.rootob);
            while (this.tm.getChildCount(this.tm.root) == 1 && !this.tm.root.hasEnabledActions(this.filters)) {
                this.tm.root = (infob)this.tm.getChild(this.tm.root, 0);
            }
        }
    }

    public void makeNewTree() {
        this.tree = new JTree(this.tm);
        this.tree.setShowsRootHandles(true);
        jcmTreeCellRenderer tcr = new jcmTreeCellRenderer();
        this.tree.setCellRenderer(tcr);
        this.tree.setCellEditor(tcr);
        this.tree.setRowHeight(0);
        tcr.addCellEditorListener(new CellEditorListener(){

            public void editingStopped(ChangeEvent e) {
                report.deb("edit stopped");
            }

            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.tree.setScrollsOnExpand(true);
        this.tree.setEditable(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setLargeModel(true);
        this.tree.addTreeExpansionListener(this);
        this.tree.addMouseListener(showpan.moulist);
        this.tree.addMouseMotionListener(showpan.moulist);
    }

    void addClickEffect() {
        this.tree.addMouseMotionListener(this.mma);
        this.tree.addMouseListener(this.ma);
    }

    void addRestrucLinks() {
        register.addlink(this.restruc, this.level);
        register.addlink(this.restruc, labman.language);
        register.addlink(this.restruc, restruclink);
    }

    void setupPanel() {
        this.setPreferredSize(new Dimension(300, 500));
        this.setName(this.tm.root.getName());
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane();
        FilterToolBar ftb = filter.getToolBar(this.filters, this.restruc, this.level);
        ftb.setAutoscrolls(true);
        jcmMenu tmenu = new jcmMenu("Tree", ftb);
        tmenu.add(docview.helpmode);
        tmenu.add(imagesaver.copyaction(this.tree));
        tmenu.add(imagesaver.saveimagemenu(this.tree, "JCMtree"));
        tmenu.add(showpan.pan("About&treeMaker", docview.class, "treeMaker"));
        ftb.setMinimumSize(new Dimension(0, 20));
        this.add((Component)ftb, "North");
        jsp.setViewportView(this.tree);
        this.add((Component)jsp, "Center");
        this.setOpaque(false);
    }

    public void paintComponent(Graphics g) {
        lookandfeel.setAntiAlias(g);
        super.paintComponent(g);
        if (this.filters.contains((Object)filter.filtertype.NeededParams)) {
            jcmTree.restruclink.changed = true;
        }
    }

    public Graphics getGraphics() {
        Graphics g = super.getGraphics();
        if (g != null) {
            lookandfeel.setAntiAlias(g);
        }
        return g;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        for (param p : this.visparams.keySet()) {
            if (this.tree.isVisible(this.visparams.get(p)) && this.tree.isExpanded(this.visparams.get(p))) continue;
            register.removelink(this.replot, p);
        }
        if (!this.insetup) {
            this.savesetup();
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.addlinkpath(event.getPath());
        Enumeration<TreePath> e = this.tree.getExpandedDescendants(event.getPath());
        while (e != null && e.hasMoreElements()) {
            this.addlinkpath(e.nextElement());
        }
        if (!this.insetup) {
            loop.golater("Tree Expanded");
        }
        if (!this.insetup) {
            this.savesetup();
        }
    }

    public void doplot() {
        try {
            this.tree.treeDidChange();
        }
        catch (Exception e) {
            report.deb(e, "Tree doplot => exception ");
        }
    }

    void savesetup() {
        List al = register.getargs(this);
        al.clear();
        for (TreePath o : this.getOpenPaths()) {
            al.add(o);
        }
    }

    TreePath[] getOpenPaths() {
        ArrayList<TreePath> openPaths = new ArrayList<TreePath>();
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            if (!this.tree.isExpanded(row)) continue;
            openPaths.add(this.tree.getPathForRow(row));
        }
        return openPaths.toArray(new TreePath[0]);
    }

    void expandPaths(Object[] args) {
        for (Object o : args) {
            if (o instanceof infob) {
                o = "[" + o + "]";
            }
            if (!o.toString().contains("disposed")) continue;
            o = null;
        }
        this.insetup = true;
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            String ep = this.endpath(this.tree.getPathForRow(row));
            if (ep.equals("Worlds]")) {
                this.tree.expandRow(row);
                continue;
            }
            for (Object o : args) {
                if (o == null) continue;
                try {
                    if (!ep.equals(this.endpath(o))) continue;
                    this.tree.expandRow(row);
                }
                catch (Exception e) {
                    report.deb(e, "Exception Expanding Tree Path:  " + o.toString());
                }
            }
        }
        this.insetup = false;
    }

    String endpath(Object o) {
        String s = o.toString();
        int i = s.lastIndexOf(", ");
        return i > 0 ? s.substring(i + 2) : (s.length() > 0 ? s.substring(1) : "");
    }

    void addlinkpath(TreePath tp) {
        Object oe = tp.getLastPathComponent();
        if (oe instanceof infob) {
            for (infob o : ((infob)oe).getEnabledObs(this.filters)) {
                if (!(o instanceof param)) continue;
                param p = (param)o;
                register.addlink(this.replot, p);
                this.visparams.put(p, tp);
            }
        }
    }

    public infob getRoot() {
        return this.tm.root;
    }

    boolean insidepopup(MouseEvent e) {
        try {
            return this.pop.isPopupMenuVisible() && e.getX() + e.getComponent().getLocationOnScreen().x >= this.pop.getPopupMenu().getLocationOnScreen().x && e.getY() + e.getComponent().getLocationOnScreen().y >= this.pop.getPopupMenu().getLocationOnScreen().y;
        }
        catch (Exception ex) {
            report.deb(ex, "tree inside popup => exception ");
            return false;
        }
    }

    public void setAlignmentX(float alignmentX) {
    }

    static {
        register.setAlwaysOutput(restruclink);
    }

    class jcmTreeCellRenderer
    implements TreeCellRenderer,
    TreeCellEditor {
        jcmTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return this.getc(value, false);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            return this.getc(value, true);
        }

        Component getc(Object value, boolean editor) {
            JComponent c = null;
            if (value instanceof infob) {
                c = ((infob)value).getComponent("tree");
            } else if (value instanceof Action) {
                c = new JButton((Action)value);
            } else if (c == null) {
                c = new JLabel(value.toString());
            }
            c.addMouseMotionListener(jcmTree.this.mma);
            c.addMouseListener(jcmTree.this.ma);
            c.setBorder(new EmptyBorder(1, 1, 1, 1));
            return c;
        }

        public void removeCellEditorListener(CellEditorListener c) {
        }

        public void addCellEditorListener(CellEditorListener c) {
        }

        public void cancelCellEditing() {
        }

        public boolean stopCellEditing() {
            return true;
        }

        public Object getCellEditorValue() {
            return null;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }
    }

    class jcmTreeModel
    implements TreeModel {
        public infob root;

        public jcmTreeModel(infob root2) {
            this.root = root2;
        }

        public Object getChild(Object parent, int index) {
            return ((infob)parent).getEnabledObs(jcmTree.this.filters).get(index);
        }

        public int getChildCount(Object parent) {
            if (this.isLeaf(parent)) {
                return 0;
            }
            return ((infob)parent).getEnabledObs(jcmTree.this.filters).size();
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((infob)parent).getEnabledObs(jcmTree.this.filters).indexOf(child);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node2) {
            return !(node2 instanceof infob) || ((infob)node2).getEnabledObs(jcmTree.this.filters) == null;
        }

        public void addTreeModelListener(TreeModelListener l) {
        }

        public void removeTreeModelListener(TreeModelListener l) {
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }
}

