/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.tls;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.root;
import jcm.core.report;
import jcm.core.tls.txt;

public class ref {
    public static float[] copy(float[] a) {
        float[] f = new float[a.length];
        System.arraycopy(a, 0, f, 0, a.length);
        return f;
    }

    public static Object add(Object a, double d) {
        return ref.add(a, new Double(d));
    }

    public static Object add(Object a, Object o) {
        int al = Array.getLength(a);
        Object b = Array.newInstance(a.getClass().getComponentType(), al + 1);
        System.arraycopy(a, 0, b, 0, al);
        if (o instanceof Double) {
            Array.setDouble(b, al, (Double)o);
        } else {
            Array.set(b, al, o);
        }
        return b;
    }

    public static Class findclass(String name) {
        for (String s : root.packages) {
            try {
                return Class.forName(s + name);
            }
            catch (ClassNotFoundException e) {
                infob o = root.rootob.find(s + name);
                if (o == null) continue;
                try {
                    return Class.forName(o.name);
                }
                catch (ClassNotFoundException e2) {
                }
            }
        }
        return null;
    }

    public static Set getallobs(Object o) {
        LinkedHashSet<Object> s = new LinkedHashSet<Object>();
        try {
            for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
                Field[] f;
                for (Field ff : f = c.getFields()) {
                    if (ff.getDeclaringClass() != c) continue;
                    s.add(ff.get(o));
                }
            }
        }
        catch (IllegalAccessException e) {
            report.deb(e);
        }
        return s;
    }

    public static Field getfield(Object o, Object owner) {
        Field[] ff;
        Class<?> c = owner.getClass();
        try {
            ff = c.getDeclaredFields();
        }
        catch (SecurityException e) {
            ff = c.getFields();
        }
        for (Field f : ff) {
            try {
                if (f.get(owner) != o) continue;
                return f;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static void getAnnotations(Object owner) {
        try {
            Field[] ff;
            Class<?> c = owner.getClass();
            if (owner instanceof infob) {
                ((infob)owner).notes = c.getDeclaredAnnotations();
            }
            try {
                ff = c.getDeclaredFields();
            }
            catch (SecurityException e) {
                ff = c.getFields();
            }
            if (ff != null) {
                for (Field f : ff) {
                    Annotation[] aa = f.getDeclaredAnnotations();
                    if (aa.length <= 0) continue;
                    try {
                        Object o = f.get(owner);
                        if (o == null || !(o instanceof infob)) continue;
                        ((infob)o).notes = aa;
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            report.deb(e);
            e.printStackTrace();
        }
    }

    public static Field getfield(Object o, String name) {
        try {
            return o.getClass().getField(name);
        }
        catch (Exception e) {
            report.deb(e);
            return null;
        }
    }

    public static boolean isstatic(Object o, Object owner) {
        if (o == owner) {
            return false;
        }
        Field f = ref.getfield(o, owner);
        if (f == null) {
            return false;
        }
        return Modifier.isStatic(f.getModifiers());
    }

    public static Object get(Object o, String name) {
        try {
            return o.getClass().getField(name).get(o);
        }
        catch (Exception e) {
            report.deb(e);
            return null;
        }
    }

    public static boolean isarray(Field f) {
        return f.getType().isArray();
    }

    public static String fieldval(interacob i, Field f) {
        try {
            return f.get(i).toString();
        }
        catch (IllegalAccessException e) {
            report.deb(e);
            return "";
        }
    }

    public static String arrayval(interacob i, Field f, int ci) {
        try {
            return Array.get(f.get(i), ci).toString();
        }
        catch (IllegalAccessException e) {
            report.deb(e);
            return "";
        }
    }

    public static String fieldinfo(interacob i, Field f) {
        return i.name + "." + f.getName() + " " + ref.fieldval(i, f);
    }

    public static String arrayinfo(interacob i, Field f, int ci) {
        return i.name + "." + f.getName() + "[" + ci + "] " + ref.arrayval(i, f, ci);
    }

    public static void setarray(interacob i, Field f, int ci, String g) {
        try {
            if (Array.get(f.get(i), ci) instanceof Double) {
                Array.setDouble(f.get(i), ci, txt.dv(g));
                return;
            }
            if (Array.get(f.get(i), ci) instanceof Float) {
                Array.setFloat(f.get(i), ci, txt.fv(g));
                return;
            }
            if (Array.get(f.get(i), ci) instanceof Integer) {
                Array.setInt(f.get(i), ci, txt.iv(g));
                return;
            }
            if (Array.get(f.get(i), ci) instanceof Boolean) {
                Array.setBoolean(f.get(i), ci, txt.bv(g));
                return;
            }
            Array.set(f.get(i), ci, g);
        }
        catch (IllegalAccessException e) {
            report.deb(e);
        }
    }

    public static void setfield(interacob i, Field f, String g) {
        try {
            if (f.get(i) instanceof Double) {
                f.setDouble(i, txt.dv(g));
                return;
            }
            if (f.get(i) instanceof Float) {
                f.setFloat(i, txt.fv(g));
                return;
            }
            if (f.get(i) instanceof Integer) {
                f.setInt(i, txt.iv(g));
                return;
            }
            if (f.get(i) instanceof Boolean) {
                f.setBoolean(i, txt.bv(g));
                return;
            }
            f.set(i, g);
        }
        catch (IllegalAccessException e) {
            report.deb(e);
        }
    }

    public static boolean anymatch(Object[] a, Object[] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (a[i] != b[j]) continue;
                return true;
            }
        }
        return false;
    }
}

