/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.reg;

import java.awt.Color;
import jcm.core.complexity;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import jcm.gui.doc.label;
import jcm.gui.doc.labman;
import jcm.gui.nav.filter;
import jcm.gui.nav.showpan;
import jcm.gui.plot.mapplot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class regman {
    public static region allreg = new region("ALL");
    public static region world;
    public static region nations;
    static String[] expert;
    static String[] experimental;

    public static param<region> makeregionparam(String name) {
        return regman.makeregionparam(name, "JCM25");
    }

    public static param<region> makeregionparam(String name, String init) {
        region mainlist = allreg.findreg("MAINLIST");
        region[] rr = mainlist.reg.toArray(new region[0]);
        param<region> p = new param<region>(name, rr, allreg.findreg(init));
        p.addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, p));
        for (String s : expert) {
            p.setcomplexity(mainlist.findreg(s), complexity.expert);
        }
        for (String s : experimental) {
            p.setcomplexity(mainlist.findreg(s), complexity.experimental);
        }
        return p;
    }

    public static void loaddata() {
        region r;
        String[][] tab;
        for (String[] row : tab = fileio.loadtab("data/countrynames.csv", "\t")) {
            if (row.length <= 1) continue;
            r = allreg.findormakereg(row[1], null);
            for (String s : row) {
                if (s.equals(row[1]) || s.trim().length() <= 0) continue;
                if (s.startsWith("#")) {
                    r.color = new Color(Integer.decode(s));
                    continue;
                }
                r.altnames.add(s);
                r.simpaltnames.add(region.simplify(s));
            }
            boolean orc = labman.recordchanged;
            labman.recordchanged = false;
            String name = labman.convertkey(row[0]);
            if (!labman.gotLabelForKey(name)) {
                labman.addLabel(name, new label(name, "reg"));
            }
            label lab = labman.getLabel(name);
            lab.set(label.langcode.en, label.smd.s, row[1]);
            lab.set(label.langcode.en, label.smd.m, row[0]);
            labman.recordchanged = orc;
        }
        String poly = fileio.loadstring("data/regions.txt").trim();
        String[] line = txt.split(poly, "\n", true);
        for (int i = 0; i < line.length - 1; ++i) {
            String[] item = txt.split(line[i], " ", true);
            try {
                if (region.nsew(item[0]) != 0) continue;
                r = allreg.findormakereg(item[0], null);
                if (item[1].equals("+")) {
                    r.addsub(item);
                    continue;
                }
                if (item[1].equals("-")) {
                    r.subtract(item);
                    continue;
                }
                if (item[1].equals("&")) {
                    r.addset(item);
                    continue;
                }
                if (item[1].equals("L")) {
                    r.defbox(item);
                    r.sea = false;
                    continue;
                }
                if (item[1].equals("O")) {
                    r.defbox(item);
                    r.sea = true;
                    continue;
                }
                r.addedge(item);
                continue;
            }
            catch (Exception e) {
                report.deb(e, line[i] + " regload " + e);
            }
        }
        region oceans = allreg.findreg("OCEANS");
        for (region r2 : regman.allreg.reg) {
            if (!oceans.contains(r2)) continue;
            r2.sea = true;
        }
    }

    static {
        regman.loaddata();
        report.log("loaded region data ok");
        nations = allreg.findreg("NATIONS");
        world = allreg.findreg("world");
        report.log("made main region list ok");
        expert = new String[]{"JCM50", "IMAGE", "EDGAR", "JCM12IMAGE", "KYOTO", "RICE", "CWS15", "GEME18", "HOUGHTON", "NICSLR"};
        experimental = new String[]{"TGCIA", "GRID", "GRIDLO"};
    }
}

