/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.core.tls.fileio;

public class loadtable {
    public static void loaddata(curveset qq, String filename, String separator, boolean transposed, float scalar, int sy, int ey, int usefromy) {
        loadtable.loaddata(qq, filename, separator, transposed, true, scalar, sy, ey, usefromy, 1);
    }

    public static void loaddata(curveset qq, String filename, String separator, boolean transposed, boolean convreg, float scalar, int sy, int ey, int usefromy, int step) {
        String[][] tab = fileio.loadtab(filename, separator);
        int nreg = transposed ? tab[2].length - 1 : tab.length - 3;
        HashSet<curve> gotfirst = new HashSet<curve>();
        for (int i = 0; i < nreg; ++i) {
            String regname = transposed ? tab[2][1 + i] : tab[3 + i][0];
            curve q = qq.getOrAddCurve(convreg ? regman.allreg.findormakereg(regname, filename) : regname);
            boolean first = !gotfirst.contains(q);
            gotfirst.add(q);
            if (!first && !convreg) {
                report.deb("warning: duplicate key name " + regname + ":- values will be summed!");
            }
            for (int y = usefromy; y <= ey; y += step) {
                try {
                    float f;
                    try {
                        f = Float.parseFloat(transposed ? tab[3 + (y - sy) / step][1 + i] : tab[3 + i][1 + (y - sy) / step]);
                        if (f == -999.0f) {
                            report.deb("warning: -999 in data input file no longer interpreted as dud! - use text eg NaN");
                        }
                    }
                    catch (RuntimeException e) {
                        f = Float.NaN;
                    }
                    if (Float.isNaN(f)) continue;
                    f = scalar * f;
                    float a = first || !q.gotdata(y) ? 0.0f : q.get(y);
                    q.set(y, f + a);
                    continue;
                }
                catch (RuntimeException e) {
                    report.deb(e, filename + " " + q.name + " " + y);
                }
            }
        }
    }

    public static void oldsplit(curveset qq) {
        for (region rs : regman.allreg.findreg((String)"OLDSPLIT").reg) {
            Set<region> sub = rs.subreg(qq);
            HashMap<region, Float> frac = new HashMap<region, Float>(sub.size());
            int y = 2000;
            while (qq.getOrAddCurve(rs).get(y) <= 0.0f) {
                --y;
            }
            float sum = 0.0f;
            for (region r : sub) {
                sum += qq.getOrAddCurve(r).get(y + 1);
            }
            for (region r : sub) {
                frac.put(r, Float.valueOf(qq.getOrAddCurve(r).get(y + 1) / sum));
            }
            while (true) {
                float f;
                float f2 = qq.getOrAddCurve(rs).get(y);
                if (!(f > 0.0f)) break;
                for (region r : sub) {
                    qq.getOrAddCurve(r).set(y, f2 * ((Float)frac.get(r)).floatValue());
                }
                --y;
            }
            qq.map.remove(rs);
        }
    }

    public static interface combiner {
        public float[] combine(float[] var1);
    }
}

