/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;

public class interpolator {
    List<region> sourcereg;
    Map<region, region> natmap = new HashMap<region, region>();
    Map<region, Float> natfrac = new HashMap<region, Float>();
    Map<region, Float> corrfac = new HashMap<region, Float>();
    Map<region, Set<region>> sourcesubreg = new HashMap<region, Set<region>>();
    Map<region, Set<region>> destsubreg = new HashMap<region, Set<region>>();
    Object source;
    static Set<region> errormap = new HashSet<region>();
    int sy;
    int step;
    int scen;
    float scalar = 1.0f;
    boolean transposed;

    public interpolator(Object ... args) {
        int i = 0;
        for (Object o : args) {
            if (o instanceof curveset) {
                this.sourcereg = new ArrayList<region>();
                for (Object oo : ((curveset)o).map.keySet()) {
                    this.sourcereg.add((region)oo);
                }
                this.source = (curveset)o;
            }
            if (o instanceof String) {
                this.sourcereg = regman.allreg.findormakereg((String)((String)o), (String)"interpolator").reg;
            }
            if (o instanceof double[] || o instanceof float[][] || o instanceof float[][][]) {
                this.source = o;
            }
            if (o instanceof Float) {
                this.scalar = ((Float)o).floatValue();
            }
            if (o instanceof Integer) {
                if (i == 0) {
                    this.sy = (Integer)o;
                }
                if (i == 1) {
                    this.step = (Integer)o;
                }
                if (i == 2) {
                    this.scen = (Integer)o;
                }
                ++i;
            }
            if (!(o instanceof Boolean)) continue;
            this.transposed = (Boolean)o;
        }
    }

    public void fill(curveset dest, region destset, int sy, int ey, curveset weights) {
        this.fill(dest, destset, sy, ey, weights, weights != null ? weights.ey : ey);
    }

    public void fill(curveset dest, region destset, int sy, int ey, curveset weights, int wey) {
        this.fill(dest, destset, sy, ey, weights, wey, 100.0f);
    }

    public void fill(curveset dest, region destset, int sy, int ey, curveset weights, float convfac) {
        this.fill(dest, destset, sy, ey, weights, weights != null ? weights.ey : ey, convfac);
    }

    public void fill(curveset dest, region destset, int sy, int ey, curveset weights, int wey, float convfac) {
        int y;
        errormap.clear();
        boolean converge = convfac < 100.0f;
        float cf = 1.0f - convfac / 100.0f;
        float sum = 0.0f;
        HashMap<region, Float> prevyeardata = new HashMap<region, Float>(destset.reg.size());
        for (region r : this.sourcereg) {
            this.sourcesubreg.put(r, r.subreg(regman.nations));
        }
        for (region r : destset.reg) {
            this.destsubreg.put(r, r.subreg(regman.nations));
        }
        for (region r : this.sourcereg) {
            for (region sr : this.sourcesubreg.get(r)) {
                this.natmap.put(sr, r);
            }
        }
        int n = y = converge ? sy - 1 : sy;
        while (y <= ey) {
            if (this.natfrac.size() == 0 || y <= wey) {
                for (region r : this.sourcereg) {
                    float sumfrac = 0.0f;
                    for (region sr : this.sourcesubreg.get(r)) {
                        if (weights == null) {
                            this.natfrac.put(sr, Float.valueOf(1.0f));
                        } else if (!weights.map.containsKey(sr)) {
                            if (!errormap.contains(sr)) {
                                errormap.add(sr);
                            }
                        } else {
                            int yy = sy > weights.sy ? (y < wey ? y : wey) : (y < weights.sy ? weights.sy : y);
                            float f = weights.get(sr, yy);
                            if (!Float.isNaN(f)) {
                                this.natfrac.put(sr, Float.valueOf(f));
                            }
                        }
                        if (!this.natfrac.containsKey(sr)) {
                            this.natfrac.put(sr, Float.valueOf(0.0f));
                        }
                        sumfrac += this.natfrac.get(sr).floatValue();
                    }
                    for (region sr : this.sourcesubreg.get(r)) {
                        this.natfrac.put(sr, Float.valueOf(this.natfrac.get(sr).floatValue() / sumfrac));
                    }
                }
            }
            for (region r : destset.reg) {
                sum = 0.0f;
                for (region sr : this.destsubreg.get(r)) {
                    region nat = this.natmap.get(sr);
                    if (nat == null) {
                        errormap.add(sr);
                        continue;
                    }
                    sum += this.getdata(nat, y) * this.natfrac.get(sr).floatValue();
                }
                if (converge) {
                    if (y >= sy) {
                        dest.set(r, y, sum + cf * (dest.get(r, y - 1) - ((Float)prevyeardata.get(r)).floatValue()));
                    }
                    prevyeardata.put(r, Float.valueOf(sum));
                    continue;
                }
                dest.set(r, y, sum);
            }
            ++y;
        }
        if (errormap.size() > 0) {
            String s = "Interpolator errors dest=" + dest.name + " weights=" + weights.name + " regions: ";
            for (region r : errormap) {
                s = s + r.name + " ";
            }
            report.deb(s);
        }
    }

    public float getdata(region r, int y) {
        if (this.source instanceof curveset) {
            return this.scalar * ((curveset)this.source).get(r, y);
        }
        int s = (y - this.sy) / this.step;
        float yf = (float)((y - this.sy) % this.step) / (float)this.step;
        int ri = this.sourcereg.indexOf(r);
        if (this.source instanceof double[]) {
            return this.scalar * (float)((double[])this.source)[ri];
        }
        if (this.source instanceof float[][]) {
            float[][] f = (float[][])this.source;
            if (this.transposed) {
                return this.scalar * ((1.0f - yf) * f[s][ri] + (yf > 0.0f ? yf * f[s + 1][ri] : 0.0f));
            }
            return this.scalar * ((1.0f - yf) * f[ri][s] + (yf > 0.0f ? yf * f[ri][s + 1] : 0.0f));
        }
        if (this.source instanceof float[][][]) {
            float[][][] f = (float[][][])this.source;
            return this.scalar * ((1.0f - yf) * f[ri][this.scen][s] + (yf > 0.0f ? yf * f[ri][this.scen][s + 1] : 0.0f));
        }
        return Float.NaN;
    }

    public static void fillregdata(curveset source, curveset dest, region regset2, float fac) {
        for (region r : regset2.reg) {
            Set<region> subregs = r.subreg(source);
            for (int y = source.sy; y <= source.ey; ++y) {
                dest.set(r, y, 0.0f);
                for (region sr : subregs) {
                    dest.set(r, y, dest.get(r, y) + (Float.isNaN(source.get(sr, y)) ? 0.0f : source.get(sr, y) * fac));
                }
            }
        }
    }

    public static void linearinterp(curveset qq, int sy, int ey) {
        for (curve q : qq.map.values()) {
            for (int y = sy + 1; y <= ey - 1; ++y) {
                q.set(y, (q.get(sy) * (float)(ey - y) + q.get(ey) * (float)(y - sy)) / (float)(ey - sy));
            }
        }
    }

    public static float interphfc(float[][][] data, int reg, int sc, int year) {
        int bk = (year - 2000) / 10;
        int by = year % 10;
        int dl = data[0][0].length;
        if (dl == 12) {
            ++bk;
            ++reg;
        }
        if (bk >= dl - 1) {
            bk = dl - 1;
            by = 0;
        }
        try {
            return (1.0f - (float)by / 10.0f) * data[reg][sc][bk] + (by > 0 ? (float)by / 10.0f * data[reg][sc][bk + 1] : 0.0f);
        }
        catch (Exception e) {
            report.log(e, " sres interp error " + data + " reg=" + reg + " sc=" + sc + " bk=" + bk + " by=" + by);
            return 0.0f;
        }
    }
}

