/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.cur;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.ob.module;
import jcm.core.ob.world;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class makederiv {
    static Map<curveset, Map<module, List<curveset>>> potLink = new HashMap<curveset, Map<module, List<curveset>>>();

    public static jcmMenu makevariantmenu(final curveset base) {
        jcmMenu submenu = new jcmMenu(new Object[]{"CreateVariant"});
        submenu.add(new jcmAction("percent&change&per&yr"){

            public void act() {
                makederiv.addnewderiv(curve.Type.ratefrac, base);
            }
        });
        submenu.add(new jcmAction("percent&of&total"){

            public void act() {
                makederiv.addnewderiv(curve.Type.frac, base);
            }
        });
        submenu.add(new jcmAction("derivative"){

            public void act() {
                makederiv.addnewderiv(curve.Type.rate, base);
            }
        });
        submenu.add(new jcmAction("integral"){

            public void act() {
                makederiv.addnewderiv(curve.Type.integral, base);
            }
        });
        submenu.add(new jcmAction("smooth"){

            public void act() {
                makederiv.addnewderiv(curve.Type.smooth, base);
            }
        });
        submenu.add(makederiv.makeDerivMenu(curve.Type.ratio, base));
        submenu.add(makederiv.makeDerivMenu(curve.Type.difference, base));
        submenu.addSeparator();
        if (world.worlds.size() > 1) {
            submenu.add(makederiv.compareworldmenu(base));
        }
        submenu.addSeparator();
        submenu.add(new jcmAction("Refresh Options"){

            public void act() {
                makederiv.refreshopts(base);
            }
        });
        return submenu;
    }

    public static void addnewderiv(curve.Type type2, curveset ... qq) {
        makederiv.addderiv(qq[0], new curvar(type2, qq));
    }

    public static void addnewderiv(curve.Type type2, List<curveset> qq) {
        makederiv.addderiv(qq.get(0), new curvar(type2, qq));
    }

    public static void addderiv(curveset base, curveset qd) {
        if (qd == null) {
            return;
        }
        base.addOb(qd);
        qd.temporary = true;
        qd.justadded = true;
        jcmTree.restruclink.changed = true;
        qd.owner = base;
        curve.Type cfr_ignored_0 = qd.type;
        if (qd.type == curve.Type.smooth) {
            qd.setaffectedby(curve.smoothtype, curve.smoothinterval);
        }
        loop.golater("qtset add-deriv");
    }

    public static jcmMenu makeDerivMenu(curve.Type type2, curveset base) {
        Map<module, List<curveset>> pl;
        if (potLink.get(base) == null) {
            makederiv.findPotLink(base);
        }
        if ((pl = potLink.get(base)).size() > 0) {
            jcmMenu dm = new jcmMenu(new Object[]{(Object)((Object)type2) + ":"});
            for (List<curveset> qqs : pl.values()) {
                for (curveset qqd : qqs) {
                    if (!qqd.name.equals(base.name) || !makederiv.checkUnitsMatch(base, qqd, type2)) continue;
                    dm.add(makederiv.addVariantAction(qqd.getworld().name, base, qqd, type2));
                }
            }
            dm.addSeparator();
            for (module m : pl.keySet()) {
                jcmMenu submenu = new jcmMenu(new Object[]{labman.getTitle(m.getworld() == base.getmodule().getworld() ? m.getName() : m.getFullName())});
                for (curveset qqd : pl.get(m)) {
                    if (!qqd.checkcomplexity() || !makederiv.checkUnitsMatch(base, qqd, type2)) continue;
                    submenu.add(makederiv.addVariantAction(qqd.getTitle(), base, qqd, type2));
                }
                if (submenu.list.size() > 1) {
                    dm.add(submenu);
                }
                if (submenu.list.size() != 1) continue;
                dm.add(submenu.list.get(0));
            }
            return dm;
        }
        return null;
    }

    static void findPotLink(curveset base) {
        try {
            if (potLink.get(base) == null) {
                potLink.put(base, new LinkedHashMap());
            }
            potLink.get(base).clear();
            module mod = base.getmodule();
            makederiv.checkmod(base, mod);
            for (infob io : mod.owner.getObs()) {
                if (io == mod || !(io instanceof module)) continue;
                makederiv.checkmod(base, (module)io);
            }
            for (module m : mod.getworld().mods) {
                if (m == mod || m.owner == mod.owner) continue;
                makederiv.checkmod(base, m);
            }
            for (world w : world.worlds) {
                if (w == mod.getworld()) continue;
                for (module m : w.mods) {
                    makederiv.checkmod(base, m);
                }
            }
        }
        catch (Exception e) {
            report.deb("makederiv findPotLink " + base + " => " + e);
        }
    }

    static void checkmod(curveset base, module m) {
        LinkedList<curveset> fit = new LinkedList<curveset>();
        for (curveset qqd : m.curvesets) {
            if (qqd.equals(base)) continue;
            makederiv.checkoverlap(fit, base, qqd);
        }
        if (fit.size() > 0) {
            potLink.get(base).put(m, fit);
        }
    }

    static void checkoverlap(List<curveset> fit, curveset base, curveset qqd) {
        if (qqd.obs != null) {
            for (Object o : qqd.obs) {
                if (!(o instanceof curveset)) continue;
                makederiv.checkoverlap(fit, base, (curveset)o);
            }
        }
        if (qqd.name.equals(base.name)) {
            fit.add(qqd);
            return;
        }
        for (Object o : qqd.map.keySet()) {
            if (!base.map.containsKey(o)) continue;
            fit.add(qqd);
            return;
        }
    }

    static void refreshopts(curveset base) {
        if (base.changed) {
            plotlink p = new plotlink(){

                public boolean isShowing() {
                    return true;
                }

                public void doplot() {
                }
            };
            register.addlink(p, base);
            loop.gonow();
            register.removelink(p, base);
        }
        makederiv.findPotLink(base);
    }

    static boolean checkUnitsMatch(curveset base, curveset qqd, curve.Type type2) {
        if (type2 == curve.Type.ratio) {
            return true;
        }
        if (type2 == curve.Type.extra) {
            return makederiv.checkUnitsMatch(((curvar)base).linkqq.get(0), qqd, curve.Type.sum);
        }
        return base.units.substring(base.units.indexOf("&") + 1).equals(qqd.units.substring(qqd.units.indexOf("&") + 1));
    }

    static Action addVariantAction(String name, final curveset base, final curveset qqd, final curve.Type type2) {
        return new jcmAction(name){

            public void act() {
                if (type2 == curve.Type.ratio) {
                    makederiv.addnewderiv(curve.Type.ratio, base, qqd);
                }
                if (type2 == curve.Type.difference) {
                    makederiv.addnewderiv(curve.Type.difference, base, qqd);
                }
                if (type2 == curve.Type.extra) {
                    ((curvar)base).addLink(qqd);
                }
            }
        };
    }

    public static curveset compareworld(curveset base, String name) {
        for (Object key : base.map.keySet()) {
            if (!key.toString().equals(base.name)) continue;
            return makederiv.compareworld(base, base.map.get(key));
        }
        return null;
    }

    public static curveset compareworld(curveset base, curve q) {
        report.deb("compare worlds " + q.name);
        curveset cwq = new curveset("Compare&" + q.name, base.units, base.sy, base.ey, base.xstep);
        cwq.register();
        for (world w : world.worlds) {
            for (module m : w.mods) {
                for (curveset mqq : m.curvesets) {
                    if (!mqq.name.equals(base.name)) continue;
                    for (Object key : base.map.keySet()) {
                        if (base.map.get(key) != q) continue;
                        try {
                            cwq.addcurve(w.name, new curve(mqq.map.get(key).geta(), w.name, w.color, base.sy, base.ey, base.xstep));
                        }
                        catch (NullPointerException e) {
                            report.deb("cannot find curve " + key + " for " + w.name);
                        }
                    }
                    cwq.setaffectedby(m);
                }
            }
        }
        return cwq;
    }

    public static jcmMenu compareworldmenu(final curveset base) {
        jcmMenu cwm = new jcmMenu(new Object[]{" Compare Worlds... "});
        for (final curve q : base.map.values()) {
            cwm.add(new jcmAction("Compare&" + q.name){

                public void act() {
                    makederiv.addderiv(base, makederiv.compareworld(base, q));
                }
            });
        }
        return cwm;
    }
}

