/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.cur;

import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.makederiv;
import jcm.core.itf.menuFiller;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.gui.plot.mapplot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class curveset
extends interacob
implements menuFiller {
    public Map<Object, curve> map = new LinkedHashMap<Object, curve>();
    public curve.Type type = curve.Type.normal;
    public int sy = module.gsy;
    public int ey = module.gey;
    public int xstep = 1;
    public String units = "nounits";
    public boolean justadded = false;
    boolean gotmap = false;
    public Set<param> assocparams;
    curve totalcurve = null;
    curve selectedcurve = null;

    public curveset(Object ... args) {
        if (this instanceof curvar) {
            return;
        }
        this.color = null;
        int sc = 0;
        int ic = 0;
        for (Object o : args) {
            if (o instanceof interacob) {
                this.owner = (interacob)o;
                this.setaffectedby((interacob)o);
                this.name = this.owner.name;
            }
            if (o instanceof Color) {
                this.color = (Color)o;
            }
            if (o instanceof complexity) {
                this.mycomplexity = (complexity)((Object)o);
            }
            if (o instanceof curve.Type) {
                this.type = (curve.Type)((Object)o);
            }
            if (o instanceof curve[]) {
                for (curve q : (curve[])o) {
                    this.addcurve(q);
                }
            }
            if (o instanceof curve) {
                this.addcurve((curve)o);
            }
            if (o instanceof String) {
                switch (sc) {
                    case 0: {
                        this.name = (String)o;
                        break;
                    }
                    case 1: {
                        this.units = (String)o;
                    }
                }
                ++sc;
            }
            if (!(o instanceof Number)) continue;
            int i = ((Number)o).intValue();
            switch (ic) {
                case 0: {
                    this.sy = i;
                    break;
                }
                case 1: {
                    this.ey = i;
                    break;
                }
                case 2: {
                    this.xstep = i;
                }
            }
            ++ic;
        }
        if (this.mycomplexity == null) {
            if (this.map.size() > 0) {
                this.mincomplexity(this.map.values());
            } else {
                this.mycomplexity = complexity.normal;
            }
        }
        double d = this.mycomplexity == complexity.simplest ? 2.15 : (this.mycomplexity == complexity.normal ? 2.1 : (this.priority = this.mycomplexity == complexity.expert ? 2.05 : 2.0));
        if (this.color == null) {
            this.color = curveset.rcol(this.owner.color);
        }
        this.addActions();
        this.register();
    }

    void addActions() {
        this.addAction(filter.filtertype.Curves, showpan.pan("Plot", lineplot.class, this));
        this.addExtraPlotAction();
        this.addAction(filter.filtertype.Curves, showpan.pan("Table", datable.class, this));
        this.checkforMapAction();
        this.addAction(filter.filtertype.Doc);
    }

    void addExtraPlotAction() {
    }

    void checkforMapAction() {
        if (!this.gotmap) {
            for (Object o : this.map.keySet()) {
                if (!(o instanceof region)) continue;
                this.gotmap = true;
                this.addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, this));
                return;
            }
        }
    }

    @Override
    public void fillMenu(jcmMenu pop) {
        this.fillMenu(pop, filter.all());
    }

    @Override
    public void fillMenu(jcmMenu pop, Set<filter.filtertype> fs) {
        this.checkforMapAction();
        super.fillMenu(pop, fs);
        pop.addSeparator();
        if (fs.contains((Object)filter.filtertype.Curves)) {
            pop.add(makederiv.makevariantmenu(this));
        }
    }

    public void associate(param ... pp) {
        if (this.assocparams == null) {
            this.assocparams = new HashSet<param>(3);
        }
        for (param p : pp) {
            this.assocparams.add(p);
        }
    }

    @Override
    public void changeendyear(int oldey, int newey) {
        if (this.ey == oldey) {
            this.ey = newey;
            for (curve q : this.map.values()) {
                q.changeendyear(oldey, newey);
            }
            this.changed = true;
        }
    }

    void addcurve(Object o, curve q) {
        this.map.put(o, q);
        if (o == regman.world && q.type == curve.Type.normal) {
            q.type = curve.Type.total;
        }
        if (this.totalcurve == null && q.type == curve.Type.total) {
            this.totalcurve = q;
        }
        if (this.mycomplexity == null) {
            this.mincomplexity(this.map.values());
        }
        if (q.owner == q) {
            q.owner = this;
        }
    }

    public void addcurve(curve ... qq) {
        for (curve q : qq) {
            this.addcurve(q.name, q);
        }
    }

    public curve addNewCurve(Object key) {
        curve q = this.makecurve(key);
        if (this.mycomplexity != null && key instanceof region) {
            q.mycomplexity = this.mycomplexity;
        }
        this.addcurve(key, q);
        return q;
    }

    public curve makecurve(Object key) {
        if (key instanceof infob) {
            infob io = (infob)key;
            return new curve(io.getName(), io.getColor(), this.sy, this.ey, this.xstep, this);
        }
        return new curve(key.toString(), this.sy, this.ey, this.xstep, this);
    }

    public curve getcurve(Object key) {
        return this.map.get(key);
    }

    public void select(Object r) {
        this.selectedcurve = this.getOrAddCurve(r);
    }

    public curve getOrAddCurve(Object key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return this.addNewCurve(key);
    }

    @Override
    public infob find(String name) {
        infob o = super.find(name);
        if (o != null) {
            return o;
        }
        for (Object oo : this.map.keySet()) {
            if (!oo.toString().equals(name)) continue;
            return this.map.get(oo);
        }
        return null;
    }

    public boolean gotdata(Object r, int year) {
        return !Float.isNaN(this.get(r, year));
    }

    public float get(Object r, int year) {
        try {
            return this.getcurve(r).get(year);
        }
        catch (NullPointerException e) {
            return Float.NaN;
        }
    }

    public float get(Object r) {
        try {
            return this.getcurve(r).get();
        }
        catch (NullPointerException e) {
            return Float.NaN;
        }
    }

    public float get(int year) {
        return this.selectedcurve.get(year);
    }

    public float get() {
        return this.selectedcurve.get();
    }

    public void set(Object r, int year, float f) {
        this.getOrAddCurve(r).set(year, f);
    }

    public void set(Object r, float f) {
        this.getOrAddCurve(r).set(f);
    }

    public void set(int year, float f) {
        this.selectedcurve.set(year, f);
    }

    public void set(float f) {
        this.selectedcurve.set(f);
    }

    public void add(Object r, int year, float f) {
        this.getOrAddCurve(r);
        float base = this.get(r, year);
        this.set(r, year, Float.isNaN(f) ? (Float.isNaN(base) ? Float.NaN : base) : (Float.isNaN(base) ? f : f + base));
    }

    public void multiply(Object r, int year, float f) {
        if (this.getcurve(r) != null) {
            this.set(year, this.get(r, year) * f);
        }
    }

    public String getunits() {
        return this.units;
    }

    public param getxscale() {
        return new param(new Object[]{param.Type.Xscale, "Xscale", "year", 0, Math.max(this.sy, 1840), Math.min(this.ey, 2160), 50});
    }

    public param getyscale() {
        return this.getyscale(false);
    }

    public param getyscale(boolean stacked) {
        float min = this.getmin();
        float max = this.getmax(stacked);
        param p = new param(new Object[]{param.Type.Yscale, "Yscale", this.units, 0, Float.valueOf(min), Float.valueOf(max), 1});
        p.units.checkunitfac(max - min);
        p.units.checkunitcancel();
        return p;
    }

    public float getmax() {
        float max = Float.MIN_VALUE;
        for (curve q : this.map.values()) {
            if (!q.checkcomplexity()) continue;
            max = Math.max(max, q.getmax());
        }
        return max;
    }

    public float getmin() {
        float min = Float.MAX_VALUE;
        for (curve q : this.map.values()) {
            if (!q.checkcomplexity()) continue;
            min = Math.min(min, q.getmin());
        }
        return min;
    }

    public float getmax(boolean stacked) {
        if (!stacked) {
            return this.getmax();
        }
        float max = Float.MIN_VALUE;
        for (int year = this.sy; year < this.ey; year += this.xstep) {
            float tot = 0.0f;
            for (curve q : this.mapwithouttotal().values()) {
                if (!q.gotdata(year)) continue;
                tot += q.get(year);
            }
            if (!(tot > max)) continue;
            max = tot;
        }
        return max;
    }

    public float calctot() {
        return this.calctot(module.year);
    }

    public float calctot(int year) {
        if (this.totalcurve == null) {
            this.totalcurve = this.getOrAddCurve(regman.world);
        }
        float t = 0.0f;
        for (curve q : this.mapwithouttotal().values()) {
            float f = q.get(year);
            if (Float.isNaN(f)) continue;
            t += f;
        }
        this.totalcurve.set(year, t);
        return this.totalcurve.get(year);
    }

    public void topdownscale(float global) {
        this.topdownscale(global, false);
    }

    public void topdownscale(float global, boolean excludebunker) {
        float b;
        float regtot = this.calctot();
        if (excludebunker && !Float.isNaN(b = this.get("bunker"))) {
            regtot -= b;
            global -= b;
        }
        float r = global / regtot;
        if (regtot > 0.0f) {
            for (curve q : this.map.values()) {
                float f;
                if (excludebunker && q.name.equals("bunker") || Float.isNaN(f = q.get())) continue;
                q.set(f * r);
            }
        }
    }

    public Map<Object, curve> mapwithouttotal() {
        LinkedHashMap<Object, curve> m = new LinkedHashMap<Object, curve>();
        for (Map.Entry<Object, curve> me : this.map.entrySet()) {
            if (me.getValue().type == curve.Type.total) continue;
            m.put(me.getKey(), me.getValue());
        }
        return m;
    }

    public void postcalc() {
        if (this.type == curve.Type.integral) {
            for (curve q : this.map.values()) {
                q.calcintegral();
            }
        }
    }

    @Override
    public String getExtraDoc() {
        return this.docUnits() + this.docCurves() + "----" + this.docNotes() + this.docInteracs() + autodoc.javacode(this);
    }

    public String docUnits() {
        String s = "==Units==";
        s = s + "units: " + labman.getTitle(this.units) + "<br>";
        s = s + "timescale (years) " + this.sy + "-" + this.ey + " (step " + this.xstep + ")<br>";
        return s;
    }

    public String docCurves() {
        String s = "==Curves==";
        if (this.map.size() == 0) {
            s = s + "\u00a3\u00a7nocurvesyet";
        } else {
            s = s + "<ul>";
            for (curve q : this.map.values()) {
                if (!q.checkcomplexity()) continue;
                s = s + "<li>" + q.docSummary();
            }
            s = s + "</ul>";
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum prob {
        min,
        low2sd,
        low1sd,
        median,
        mean,
        hi1sd,
        hi2sd,
        max;

    }
}

