/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.decoration;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.painter.gradient.ClassicGradientPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ClassicDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Classic";
    protected static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("ClassicDecorationPainter");
    protected ClassicGradientPainter painter = new ClassicGradientPainter();

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        SubstanceColorScheme scheme = skin.getBackgroundColorScheme(decorationAreaType);
        if (width * height < 100000) {
            HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, scheme.getDisplayName());
            BufferedImage result = smallImageCache.get(key);
            if (result == null) {
                result = SubstanceCoreUtilities.getBlankImage(width, height);
                this.internalPaint((Graphics2D)result.getGraphics(), width, height, scheme);
                smallImageCache.put(key, result);
            }
            graphics.drawImage((Image)result, 0, 0, null);
            return;
        }
        this.internalPaint(graphics, width, height, scheme);
    }

    protected void internalPaint(Graphics2D graphics, int width, int height, SubstanceColorScheme scheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(-3, -3);
        this.painter.paintContourBackground(g2d, width + 6, height + 6, new Rectangle(width + 6, height + 6), false, scheme, scheme, 0.0f, false, false);
        g2d.dispose();
    }
}

