/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceSpinnerButton;
import org.jvnet.substance.utils.SubstanceTextUtilities;
import org.jvnet.substance.utils.border.SubstanceBorder;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

public class SubstanceSpinnerUI
extends BasicSpinnerUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected FadeStateListener substanceFadeStateListener;
    protected SubstanceSpinnerButton nextButton;
    protected SubstanceSpinnerButton prevButton;

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__jvnet__substance__SubstanceSpinnerUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceSpinnerUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceSpinnerUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceSpinnerUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceSpinnerUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    public void installListeners() {
        this.__org__jvnet__substance__SubstanceSpinnerUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceSpinnerUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceSpinnerUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceSpinnerUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceSpinnerUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceSpinnerUI();
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = new SubstanceSpinnerButton(this.spinner, 1);
        this.nextButton.setFont(this.spinner.getFont());
        this.nextButton.setName("Spinner.nextButton");
        TransitionAwareIcon icon = new TransitionAwareIcon(this.nextButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSpinnerArrowIconWidth(fontSize), SubstanceSizeUtils.getSpinnerArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize), 1, scheme);
            }
        });
        this.nextButton.setIcon(icon);
        float spinnerButtonSize = SubstanceSizeUtils.getSpinnerButtonWidth(SubstanceSizeUtils.getComponentFontSize(this.spinner));
        this.nextButton.setPreferredSize(new Dimension((int)spinnerButtonSize, (int)spinnerButtonSize));
        this.nextButton.setMinimumSize(new Dimension(5, 5));
        this.nextButton.putClientProperty("substancelaf.buttonopenSide", EnumSet.allOf(SubstanceConstants.Side.class));
        this.installNextButtonListeners(this.nextButton);
        return this.nextButton;
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = new SubstanceSpinnerButton(this.spinner, 5);
        this.prevButton.setFont(this.spinner.getFont());
        this.prevButton.setName("Spinner.previousButton");
        TransitionAwareIcon icon = new TransitionAwareIcon(this.prevButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSpinnerArrowIconWidth(fontSize), SubstanceSizeUtils.getSpinnerArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize), 5, scheme);
            }
        });
        this.prevButton.setIcon(icon);
        float spinnerButtonSize = SubstanceSizeUtils.getSpinnerButtonWidth(SubstanceSizeUtils.getComponentFontSize(this.prevButton));
        this.prevButton.setPreferredSize(new Dimension((int)spinnerButtonSize, (int)spinnerButtonSize));
        this.prevButton.setMinimumSize(new Dimension(5, 5));
        this.prevButton.putClientProperty("substancelaf.buttonopenSide", EnumSet.allOf(SubstanceConstants.Side.class));
        this.installPreviousButtonListeners(this.prevButton);
        return this.prevButton;
    }

    protected void __org__jvnet__substance__SubstanceSpinnerUI__installDefaults() {
        Border b;
        JFormattedTextField tf;
        super.installDefaults();
        JComponent editor = this.spinner.getEditor();
        if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.spinner);
            Insets ins = SubstanceSizeUtils.getSpinnerTextBorderInsets(fontSize);
            tf.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            tf.setFont(this.spinner.getFont());
        }
        if ((b = this.spinner.getBorder()) == null || b instanceof UIResource) {
            this.spinner.setBorder(new SubstanceBorder(SubstanceSizeUtils.getSpinnerBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.spinner))));
        }
    }

    protected void __org__jvnet__substance__SubstanceSpinnerUI__installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JFormattedTextField tf;
                JComponent editor;
                if ("editor".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JFormattedTextField tf;
                            if (SubstanceSpinnerUI.this.substanceFadeStateListener != null) {
                                SubstanceSpinnerUI.this.substanceFadeStateListener.unregisterListeners();
                                SubstanceSpinnerUI.this.substanceFadeStateListener = null;
                            }
                            if (SubstanceSpinnerUI.this.spinner == null) {
                                return;
                            }
                            JComponent editor = SubstanceSpinnerUI.this.spinner.getEditor();
                            if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
                                Insets ins = SubstanceSizeUtils.getSpinnerTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
                                tf.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
                                SubstanceSpinnerUI.this.substanceFadeStateListener = new FadeStateListener(tf, null, new FadeTrackerAdapter(){

                                    @Override
                                    public void fadeEnded(FadeKind fadeKind) {
                                        if (SubstanceSpinnerUI.this.spinner != null) {
                                            SubstanceSpinnerUI.this.spinner.repaint();
                                        }
                                    }

                                    @Override
                                    public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
                                        if (SubstanceSpinnerUI.this.spinner != null) {
                                            SubstanceSpinnerUI.this.spinner.repaint();
                                        }
                                    }
                                });
                                SubstanceSpinnerUI.this.substanceFadeStateListener.registerListeners();
                            }
                        }
                    });
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceSpinnerUI.this.spinner != null) {
                                SubstanceSpinnerUI.this.spinner.updateUI();
                            }
                        }
                    });
                }
                if ("background".equals(evt.getPropertyName()) && (editor = SubstanceSpinnerUI.this.spinner.getEditor()) != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null && tf.getBackground() instanceof UIResource) {
                    tf.setBackground(SubstanceSpinnerUI.this.spinner.getBackground());
                }
            }
        };
        this.spinner.addPropertyChangeListener(this.substancePropertyChangeListener);
        JComponent editor = this.spinner.getEditor();
        if (editor != null && editor instanceof JSpinner.DefaultEditor) {
            JFormattedTextField tf = ((JSpinner.DefaultEditor)editor).getTextField();
            this.substanceFadeStateListener = new FadeStateListener(tf, null, new FadeTrackerAdapter(){

                @Override
                public void fadeEnded(FadeKind fadeKind) {
                    if (SubstanceSpinnerUI.this.spinner != null) {
                        SubstanceSpinnerUI.this.spinner.repaint();
                    }
                }

                @Override
                public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
                    if (SubstanceSpinnerUI.this.spinner != null) {
                        SubstanceSpinnerUI.this.spinner.repaint();
                    }
                }
            });
            this.substanceFadeStateListener.registerListeners();
        }
    }

    protected void __org__jvnet__substance__SubstanceSpinnerUI__uninstallListeners() {
        if (this.substanceFadeStateListener != null) {
            this.substanceFadeStateListener.unregisterListeners();
            this.substanceFadeStateListener = null;
        }
        this.spinner.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (SubstanceSpinnerUI.hasFocus(this.spinner) || FadeTracker.getInstance().isTracked(this.spinner, FadeKind.FOCUS)) {
            this.paintFocus(g, this.spinner.getEditor().getBounds());
        }
        if (this.spinner.isEnabled()) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(Color.red);
            SubstanceColorScheme borderColorScheme = SubstanceColorSchemeUtilities.getBorderColorScheme(c, ComponentState.DEFAULT);
            if (this.spinner.getComponentOrientation().isLeftToRight()) {
                g2d.translate(this.spinner.getEditor().getX() + this.spinner.getEditor().getWidth(), -5);
                SubstanceImageCreator.paintSimpleBorder(g2d, 2 * this.nextButton.getWidth(), this.spinner.getHeight() + 10, borderColorScheme, borderColorScheme, 0.0f);
            } else {
                g2d.translate(-5, -5);
                SubstanceImageCreator.paintSimpleBorder(g2d, 5 + this.spinner.getEditor().getX(), this.spinner.getHeight() + 10, borderColorScheme, borderColorScheme, 0.0f);
            }
            g2d.dispose();
        }
    }

    private static boolean hasFocus(Component comp) {
        if (comp.hasFocus()) {
            return true;
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                if (!SubstanceSpinnerUI.hasFocus(child)) continue;
                return true;
            }
        }
        return false;
    }

    protected void paintFocus(Graphics g, Rectangle bounds) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension nextD = this.nextButton.getPreferredSize();
        Dimension previousD = this.prevButton.getPreferredSize();
        Dimension editorD = this.spinner.getEditor().getPreferredSize();
        Dimension size = new Dimension(editorD.width, editorD.height);
        size.width += Math.max(nextD.width, previousD.width);
        Insets insets = this.spinner.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public void __org__jvnet__substance__SubstanceSpinnerUI__update(Graphics g, JComponent c) {
        SubstanceTextUtilities.paintTextCompBackground(g, c);
        this.paint(g, c);
    }

    @Override
    protected LayoutManager createLayout() {
        return new SpinnerLayoutManager();
    }

    protected class SpinnerLayoutManager
    implements LayoutManager {
        protected SpinnerLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = SubstanceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension previousD = SubstanceSpinnerUI.this.prevButton.getPreferredSize();
            Dimension editorD = SubstanceSpinnerUI.this.spinner.getEditor().getPreferredSize();
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            Insets buttonInsets = SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
            size.width += buttonInsets.left + buttonInsets.right;
            return size;
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            Dimension nextD = SubstanceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension previousD = SubstanceSpinnerUI.this.prevButton.getPreferredSize();
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth - buttonInsets.right - buttonInsets.left;
                buttonsX = width - buttonsWidth - buttonInsets.right;
            } else {
                buttonsX = buttonInsets.left;
                editorX = buttonsX + buttonsWidth + buttonInsets.left;
                editorWidth = width - buttonInsets.left - buttonsWidth - insets.right - buttonInsets.left;
            }
            int nextY = buttonInsets.top;
            int nextHeight = height / 2 + height % 2 - nextY;
            int previousY = buttonInsets.top + nextHeight;
            int previousHeight = height - previousY - buttonInsets.bottom;
            SubstanceSpinnerUI.this.spinner.getEditor().setBounds(editorX, insets.top, editorWidth, editorHeight);
            SubstanceSpinnerUI.this.nextButton.setBounds(buttonsX, nextY, buttonsWidth, nextHeight);
            SubstanceSpinnerUI.this.prevButton.setBounds(buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }
}

