/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jcm.core.loop;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.units;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.soc.responsibility;
import jcm.mod.soc.socreg;
import jcm.script.calcscript;

public class contribtemp_1
extends calcscript {
    berncarbon bc = this.get(berncarbon.class);
    carboncycle cc = this.get(carboncycle.class);
    CalcLucEmit cl = this.get(CalcLucEmit.class);
    responsibility rs = this.get(responsibility.class);
    qt tot = new qt("surftemp", "degcbase");
    static String[] regionsChosen = new String[]{"United States", "Japan", "China", "India", "Canada", "Oceania", "North Europe", "South EU +France", "East Europe +Ukraine", "Russia", "Central Asia Stans", "Turkey", "Arabia", "Iran Pakn Afgn", "Other East Asia", "South East Asia", "Indonesia", "Central America", "Bolivia to Guiana", "Argta Chile Pgy Ugy", "Brazil.", "North Africa", "Sahel (Africa)", "Central Africa", "Southern Africa"};
    Map<String, qtset> regionCurves = new HashMap<String, qtset>();
    Map<String, qt> regionContributions = new HashMap<String, qt>();
    String p = "";
    region regset;
    boolean disableloop = true;

    void setupregions() {
        this.regionContributions.clear();
        this.regionCurves.clear();
        for (String s : regionsChosen) {
            this.regionCurves.put(s, new qtset(s, 1850, 2005, 5));
            this.regionContributions.put(s, new qt(new Object[0]));
        }
        this.get(socreg.class).regions.choose(regman.allreg.find("JCM 25 Region Set"));
        this.regset = (region)this.get(socreg.class).regions.chosen;
    }

    public void run() {
        this.setupregions();
        this.link(this.rs.surftemp);
        for (String lu : CalcLucEmit.lucsources) {
            this.cl.lucsource.set(lu);
            if (this.cl.lucsource.chosen.equals("Houghton")) {
                for (double cor = 784.0; cor <= 2700.0; cor += 229.0) {
                    this.cl.landuseemit.set(cor);
                    System.err.println("Houghton emission in 2000 " + cor);
                    this.calc();
                }
                continue;
            }
            if (!this.cl.lucsource.chosen.equals("IVIGmodel")) continue;
            for (LUCdata.biomeclassification bc : LUCdata.biomeclassification.values()) {
                this.cl.biomeclass.set(bc);
                System.err.print("IVIGmodel land use " + (Object)((Object)bc));
                if (this.cl.biomeclass.chosen == LUCdata.biomeclassification.A) {
                    this.ivigmodeloop();
                    continue;
                }
                this.ivigmodeloop();
                this.cl.isam.set(true);
                this.ivigmodeloop();
                this.cl.isam.set(false);
            }
        }
        lineplot.thin = 1000;
        for (String s : regionsChosen) {
            datable.savetable(new File("results" + this.fs + s + ".tab"), this.regionCurves.get(s), "tab");
        }
        System.err.println("All tables saved");
        this.end();
        System.err.println("End of script contribtemp");
        this.cl.lucsource.choose("IVIGmodel");
    }

    public void ivigmodeloop() {
        for (double vc = 0.8; vc <= 1.2; vc += 0.2) {
            this.cl.vegcerror.set(vc);
            System.err.print(" veg carbon error " + vc);
            for (double sa = 0.1; sa <= 0.3; sa += 0.1) {
                this.cl.soillossagric.set(sa);
                System.err.print(" agric soil loss " + sa);
                for (double sp = 0.05; sp <= 0.1; sp += 0.025) {
                    this.cl.soillosspast.set(sp);
                    System.err.println(" past soil loss " + sp);
                    this.p = units.round(vc, 1.0, 1) + " " + units.round(sa, 1.0, 1) + " " + units.round(sp, 1.0, 2) + "_";
                    this.calc();
                }
            }
        }
    }

    public void calc() {
        for (double beta = 0.56; beta >= 0.0; beta -= 0.28) {
            this.bc.beta.set(beta);
            for (double respq10 = 0.6; respq10 <= 1.6; respq10 += 0.3) {
                this.bc.respq10.set(respq10);
                for (double diffu = 1.75; diffu >= 0.5; diffu -= 0.5) {
                    this.bc.diffufac.set(diffu);
                    this.checkbut();
                    loop.gonow(false);
                    String err = units.round(this.cc.error, 1.0, 0);
                    String c = " ";
                    c = this.cl.lucsource.chosen.equals("IVIGmodel") ? (this.cl.biomeclass.chosen == LUCdata.biomeclassification.A ? "-A_" : (!this.cl.isam.istrue() ? "-B_" : "-B/ISAM_")) + this.p : "_" + this.cl.landuseemit.getval() + "_";
                    String name = this.cl.lucsource.chosen + c + beta + " " + respq10 + " " + diffu + "_" + err;
                    if (this.cc.error <= 2700.0) {
                        this.report(name);
                        for (int y = 1850; y <= 2005; ++y) {
                            this.tot.set(y, 0.0f);
                        }
                        for (region r : this.regset.reg) {
                            for (int y = 1850; y <= 2005; ++y) {
                                this.tot.set(y, this.tot.get(y) + this.rs.surftemp.get(r, y));
                            }
                        }
                        for (int y = 1850; y <= 2005; ++y) {
                            for (String s : regionsChosen) {
                                this.regionContributions.get(s).set(y, this.rs.surftemp.get(this.regset.find(s), y) * 100.0f / this.tot.get(y));
                            }
                        }
                        Color col = Color.black;
                        try {
                            col = new Color(255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 0 : 1), 255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (this.cl.biomeclass.chosen == LUCdata.biomeclassification.A ? 1 : 0), 255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (this.cl.biomeclass.chosen == LUCdata.biomeclassification.A ? 0 : 1), (int)(3000.0 / (this.cc.error - 450.0)));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        for (String s : regionsChosen) {
                            this.regionCurves.get(s).add(this.regionContributions.get(s).cloneIndependent(1850, 2005, 5, name, col));
                        }
                        continue;
                    }
                    System.err.println(name + " Bypassed, error > 700!");
                }
            }
        }
    }
}

