/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.soc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.interacob;
import jcm.core.module;
import jcm.core.param;
import jcm.core.reg.region;
import jcm.mod.carbon.carboncycle;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.ogas.othgasemit;
import jcm.mod.soc.costs;
import jcm.mod.soc.responsibility;
import jcm.mod.soc.socio;
import jcm.mod.soc.socreg;

public class shares
extends module {
    String[] distriboptions = new String[]{"unspecified", "percapita", "brazilian", "sresdist", "convpergdp", "grandfather", "cheapest_iterative", "cheapest_algebraic"};
    public param distribution = new param("distribmenu", this.distriboptions, "sresdist");
    public param convergey = new param("convyear", "", 2040, 2010, 2100);
    public param popcoy = new param("popcoy", "", 2030, 1990, 2100);
    public param cvf = new param("convfac", "", 6, 1, 13);
    public param exponential = new param("expconvopt", false);
    public param popcoyoption = new param("popcoyopt", false);
    public param kyotop = new param(new Object[]{"kyotoopt", false, complexity.experimental});
    public param incusa = new param(new Object[]{"incusaopt", true, complexity.experimental});
    socreg socreg;
    responsibility rs;
    socio socio;
    List<region> reg;
    int sy;
    double cf;
    Map<region, Float> fp = new HashMap<region, Float>();
    Map<region, Float> feff = new HashMap<region, Float>();
    Map<region, Float> fr = new HashMap<region, Float>();
    Set<region> participate = new HashSet<region>();
    Set<region> notparticipate = new HashSet<region>();
    float npemit = 0.0f;
    float pemit = 0.0f;
    float tfr = 0.0f;
    float fostot = 0.0f;
    float tempinctot = 0.0f;
    float poptot = 0.0f;
    float tempincp = 0.0f;

    public void initsetup() {
        this.socreg = this.get(socreg.class);
        this.rs = this.get(responsibility.class);
        this.socio = this.get(socio.class);
        this.follows(globco2emit.class);
        this.follows(othgasemit.class);
        this.setaffectedby(this.socreg.regions);
        this.distribution.setaffectedby(this.get(controller.class).objective);
        this.affectsfutureonly = true;
    }

    public void setinteractions() {
        this.setaffectedby((interacob)this.get(responsibility.class), this.distribution.chosen == "brazilian");
        this.setaffectedby((interacob)this.get(costs.class), ((String)this.distribution.chosen).startsWith("cheapest"));
    }

    public void precalc() {
        this.sy = this.kyotop.istrue() ? 2012 : fsy;
        this.cf = this.cvf.getval() / (this.convergey.getval() - (double)this.sy);
        if (this.get(controller.class).objective.chosen == "nopolicy") {
            this.distribution.chosen = "sresdist";
        }
        this.fp.clear();
        this.feff.clear();
        this.fr.clear();
        this.participate.clear();
        this.reg = ((region)this.socreg.regions.chosen).reg;
    }

    public void calcstep() {
        if (year >= this.sy) {
            for (region r : this.reg) {
                this.socreg.emitfosquota.set(r, this.socreg.emitfosbase.get(r));
            }
            if (this.distribution.chosen == "unspecified") {
                for (region r : this.reg) {
                    this.socreg.emitfosquota.set(r, 0.0f);
                }
            }
            if (this.distribution.chosen == "grandfather") {
                for (region r : this.reg) {
                    this.socreg.emitfosquota.set(r, this.socreg.emitfosquota.get(r, year - 1));
                }
            }
            if (this.distribution.chosen == "percapita") {
                this.converge("pop");
            }
            if (this.distribution.chosen == "convpergdp") {
                this.converge("gdp");
            }
            if (this.distribution.chosen == "cheapest-algebraic") {
                this.leastcost(false);
            }
            if (this.distribution.chosen == "cheapest-iterative") {
                this.leastcost(true);
            }
            if (this.distribution.chosen.equals("brazilian")) {
                this.brazil();
            } else {
                this.socreg.emitfosquota.topdownscale(this.get(carboncycle.class).fossil.get(), true);
            }
            this.socreg.emitch4.topdownscale(this.get(othgasemit.class).ch4emit.get());
            this.socreg.emitn2o.topdownscale(this.get(othgasemit.class).n2oemit.get());
        }
        if (year >= 1890 && year <= 2100) {
            this.socreg.calcequiv();
        }
    }

    void brazil() {
        this.npemit = 0.0f;
        this.pemit = 0.0f;
        this.tfr = 0.0f;
        this.fostot = 0.0f;
        this.tempinctot = 0.0f;
        this.tempincp = 0.0f;
        this.poptot = 0.0f;
        if (!this.kyotop.istrue() || year > 2012) {
            int respyear = year <= 2100 ? year - 1 : (int)Math.max(2100.0, this.rs.endyear.getval());
            for (region r : this.reg) {
                this.tempinctot += this.rs.surftemp.get(r, respyear);
                this.poptot += this.socio.pop.get(r, year);
                this.fostot += this.socreg.emitfosquota.get(r, year - 1);
            }
            for (region r : this.reg) {
                this.fr.put(r, Float.valueOf(this.rs.surftemp.get(r, respyear) / this.tempinctot));
                this.fp.put(r, Float.valueOf(this.socio.pop.get(r, year) / this.poptot));
                this.feff.put(r, Float.valueOf(this.socreg.emitfosquota.get(r, year - 1) / this.fostot));
                if (this.feff.get(r).floatValue() > this.fp.get(r).floatValue()) {
                    this.participate.add(r);
                    continue;
                }
                if (!this.participate.contains(r)) continue;
                this.socreg.emitfosquota.set(r, year, this.fostot * this.socio.pop.get(r, year) / this.poptot);
                this.participate.remove(r);
            }
            for (region r : this.participate) {
                this.tempincp += this.rs.surftemp.get(r, respyear);
                this.pemit += this.socreg.emitfosquota.get(r, year - 1);
            }
            this.notparticipate.clear();
            this.notparticipate.addAll(this.reg);
            this.notparticipate.removeAll(this.participate);
            for (region r : this.notparticipate) {
                this.npemit += this.socreg.emitfosquota.get(r, year);
            }
            float totred = this.pemit - (this.get(carboncycle.class).fossil.get() - this.socreg.emitfosquota.get("bunker") - this.npemit);
            for (region r : this.participate) {
                this.socreg.emitfosquota.set(r, this.socreg.emitfosquota.get(r, year - 1) - totred * this.rs.surftemp.get(r, respyear) / this.tempincp);
            }
        }
    }

    void converge(String cw) {
        int cyear;
        int n = cyear = (double)year <= this.popcoy.getval() || !this.popcoyoption.istrue() ? year : (int)this.popcoy.getval();
        double f = (double)year >= this.convergey.getval() ? 1.0 : (this.exponential.istrue() ? Math.exp(this.cf * ((double)year - this.convergey.getval() - 1.0)) : 1.0 / (this.convergey.getval() - (double)year));
        float poptot = 0.0f;
        float gdptot = 0.0f;
        float emittot = 0.0f;
        for (region r : this.reg) {
            if (r.name.equals("bunker")) continue;
            poptot += this.socio.pop.get(r, cyear);
            gdptot += this.socio.gdp.get(r, cyear);
            emittot += this.socreg.emitfosquota.get(r);
        }
        float cr = 1.0f;
        for (region r : this.reg) {
            if (r.name.equals("bunker")) continue;
            if (cw == "pop") {
                cr = this.socio.pop.get(r, cyear) / poptot;
            }
            if (cw == "gdp") {
                cr = this.socio.gdp.get(r, cyear) / gdptot;
            }
            float er = this.socreg.emitfosquota.get(r, year - 1) / emittot;
            this.socreg.emitfosquota.set(r, (float)((double)er - f * (double)(er - cr)));
        }
    }

    public int nr(region r) {
        return this.reg.indexOf(r);
    }

    void leastcost(boolean iterative) {
        float suma = 0.0f;
        float sumb = 0.0f;
        float sums = 0.0f;
        float summ = 0.0f;
        int nregs = ((region)this.socreg.regions.chosen).reg.size();
        float[] mac = new float[nregs];
        float[] abateshare = new float[nregs];
        if (iterative) {
            for (region r : ((region)this.socreg.regions.chosen).reg) {
                mac[this.nr((region)r)] = 1.0f / (this.get(costs.class).mac(r, year - 1) * this.get(costs.class).ew(r, year - 1));
                if (Float.isInfinite(mac[this.nr(r)]) || Float.isNaN(mac[this.nr(r)])) {
                    mac[this.nr((region)r)] = 0.0f;
                }
                summ += mac[this.nr(r)];
            }
            for (region r : ((region)this.socreg.regions.chosen).reg) {
                if (summ > 0.0f) {
                    int n = this.nr(r);
                    abateshare[n] = abateshare[n] * (0.6f + 0.4f * mac[this.nr(r)] / summ);
                } else {
                    abateshare[this.nr((region)r)] = this.socreg.emitfosbase.get(r) / this.get(carboncycle.class).fossil.get();
                }
                this.socreg.emitfosquota.set(r, this.socreg.emitfosquota.get(r, year - 1) + (this.socreg.emitfosbase.get(r) - this.socreg.emitfosbase.get(r, year - 1)));
            }
        } else {
            for (region r : ((region)this.socreg.regions.chosen).reg) {
                abateshare[this.nr((region)r)] = 1.0f / (float)Math.pow(this.get(costs.class).alpha(r), 1.0f / (this.get(costs.class).beta(r) - 1.0f));
                this.socreg.emitfosquota.set(r, this.socreg.emitfosbase.get(r));
            }
        }
        for (region r : ((region)this.socreg.regions.chosen).reg) {
            sums += abateshare[this.nr(r)];
            sumb += this.socreg.emitfosquota.get(r);
        }
        suma = sumb - this.get(carboncycle.class).fossil.get();
        for (region r : ((region)this.socreg.regions.chosen).reg) {
            this.socreg.emitfosquota.set(r, this.socreg.emitfosquota.get(r) - suma * abateshare[this.nr(r)] / sums);
            if (this.socreg.emitfosquota.get(r) < 0.0f) {
                this.socreg.emitfosquota.set(r, 0.0f);
            }
            if (!(this.socreg.emitfosquota.get(r) > this.socreg.emitfosbase.get(r))) continue;
            this.socreg.emitfosquota.set(r, this.socreg.emitfosbase.get(r));
        }
    }
}

