/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.soc;

import jcm.core.complexity;
import jcm.core.data.histdata;
import jcm.core.data.interpolator;
import jcm.core.data.matchdata;
import jcm.core.interacob;
import jcm.core.module;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.core.reg.region;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.obj.globco2emit;
import jcm.mod.ogas.othgasemit;
import jcm.mod.soc.AviaShipEmit;
import jcm.mod.soc.socio;
import jcm.mod.soc.socreg;

public class history
extends module {
    qtset emitfos;
    qtset emitluc;
    qtset emitch4;
    qtset emitn2o;
    qtset pop;
    qtset gdp;
    qtset energy;
    region regset;
    socreg socreg;
    AviaShipEmit av;
    socio socio;
    globco2emit gc;
    public static qtset fosCO2 = new qtset(new Object[]{"fosCO2", "mega&ton&carbon", 1750, 2002, complexity.expert});
    public static qtset hydepop = new qtset(new Object[]{"pop", "kilo&person", 1700, 2002, complexity.expert});
    public static qtset epaCH4 = new qtset(new Object[]{"epaCH4", "mega&ton&CH4", 1990, 2020, 5, complexity.expert});
    public static qtset epaN2O = new qtset(new Object[]{"epaN2O", "mega&ton&N", 1990, 2020, 5, complexity.expert});
    public static float[][] jcm12pop;
    public static float[][] jcm12gdp;
    public static float[][] jcm12en;

    public void initsetup() {
        this.follows(this.get(CalcLucEmit.class));
        this.setaffectedby(this.get(socreg.class).regions);
        this.makegdpen();
    }

    public void setinteractions() {
        this.setaffectedby((interacob)this.get(carboncycle.class), this.get(CalcLucEmit.class).lucsource.chosen.equals("Inverse") || this.get(CalcLucEmit.class).lucsource.chosen.equals("Houghton"));
    }

    public void precalc() {
        int y;
        this.socreg = this.get(socreg.class);
        this.socio = this.get(socio.class);
        this.av = this.get(AviaShipEmit.class);
        this.gc = this.get(globco2emit.class);
        this.emitfos = this.socreg.emitfosbase;
        this.emitch4 = this.socreg.emitch4;
        this.emitn2o = this.socreg.emitn2o;
        this.emitluc = this.socreg.emitlucbase;
        this.pop = this.socio.pop;
        this.gdp = this.socio.gdp;
        this.energy = this.socio.energy;
        this.regset = (region)this.socreg.regions.chosen;
        qt fossil = this.gc.fossil;
        qt lucf = this.gc.lucf;
        qt totemit = this.gc.totemit;
        this.socreg.clearoldregions();
        this.socreg.clearoldregions(this.socio);
        interpolator.fillregdata(hydepop, this.pop, this.regset, 0.001f);
        new interpolator(new Object[]{jcm12gdp, "JCM12", 1900, 1, false}).fill(this.gdp, this.regset, 1900, 2000, hydepop);
        new interpolator(new Object[]{jcm12en, "JCM12", 1900, 1, false}).fill(this.energy, this.regset, 1900, 2000, hydepop);
        if (this.get(CalcLucEmit.class).lucsource.chosen.equals("EDGAR")) {
            interpolator.fillregdata(LUCdata.edgarff, this.emitfos, this.regset, 0.001f);
        } else {
            interpolator.fillregdata(fosCO2, this.emitfos, this.regset, 0.001f);
        }
        if (this.get(CalcLucEmit.class).lucsource.chosen.equals("Houghton")) {
            float scalefactor = (float)this.get(CalcLucEmit.class).landuseemit.getval() / 2158.09f;
            new interpolator(LUCdata.lucCO2Houghton, 1950, Float.valueOf(1.0f), Float.valueOf(scalefactor * 0.001f)).fill(this.emitluc, this.regset, 1850, 2000, LUCdata.lucCO2CAIT);
        }
        if (this.get(CalcLucEmit.class).lucsource.chosen.equals("EDGAR")) {
            interpolator.fillregdata(LUCdata.edgarluc, this.emitluc, this.regset, 0.001f);
        }
        if (this.get(CalcLucEmit.class).lucsource.chosen.equals("IVIGmodel")) {
            interpolator.fillregdata(this.get(CalcLucEmit.class).lucemit, this.emitluc, this.regset, 0.001f);
        }
        new interpolator(new Object[]{matchdata.Edgar14CH4_1890_1970, "EDGAR", 1890, 10, true}).fill(this.emitch4, this.regset, 1890, 1970, epaCH4);
        new interpolator(new Object[]{matchdata.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true}).fill(this.emitch4, this.regset, 1971, 2000, epaCH4);
        for (y = 1890; y < 2000; ++y) {
            this.get(othgasemit.class).ch4emit.set(y, this.emitch4.calctot(y));
        }
        new interpolator(new Object[]{matchdata.Edgar14N2O_1890_1970, "EDGAR", 1890, 10, true}).fill(this.emitn2o, this.regset, 1890, 1970, epaN2O);
        new interpolator(new Object[]{matchdata.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true}).fill(this.emitn2o, this.regset, 1971, 2000, epaN2O);
        for (y = 1890; y < 2000; ++y) {
            this.get(othgasemit.class).n2oemit.set(y, this.emitn2o.calctot(y));
        }
    }

    public void calcstep() {
        if (year < fsy) {
            for (region r : this.regset.reg) {
                this.socreg.emitfosquota.set(r, this.socreg.emitfosbase.get(r));
                this.socreg.emitlucquota.set(r, this.emitluc.get(r));
            }
            float bunker = year > 1900 ? this.av.secemit.get((Object)AviaShipEmit.sec.tot_int) : 0.0f;
            this.socreg.emitfosbase.set("bunker", bunker);
            this.socreg.emitfosquota.set("bunker", bunker);
            this.gc.fossil.set(this.socreg.emitfosbase.calctot());
            this.socreg.emitfosquota.calctot();
            this.pop.calctot();
            this.gdp.calctot();
            this.energy.calctot();
            this.emitch4.calctot();
            this.emitn2o.calctot();
        }
        if (year > 1755 && (this.get(CalcLucEmit.class).lucsource.chosen.equals("Inverse") && year < 2005 || this.get(CalcLucEmit.class).lucsource.chosen.equals("Houghton") && year < 1850)) {
            this.get(carboncycle.class).inverseluc();
        } else if (year < fsy) {
            this.gc.lucf.set(this.emitluc.calctot());
        }
        if (year < fsy) {
            this.gc.totemit.set(this.gc.fossil.get() + this.gc.lucf.get());
        }
    }

    void makegdpen() {
        for (int i = 0; i < 13; ++i) {
            int j;
            for (j = 70; j < 101; ++j) {
                float[] fArray = jcm12gdp[i];
                int n = j;
                fArray[n] = fArray[n] * (0.001f * jcm12pop[i][j]);
            }
            for (j = 71; j < 101; ++j) {
                float[] fArray = jcm12en[i];
                int n = j;
                fArray[n] = fArray[n] * jcm12pop[i][j];
            }
        }
    }

    static {
        histdata.loaddata(fosCO2, "cdiacrows.csv", ",", false, 1.0f, 1750, 2000, 1750);
        histdata.oldsplit(fosCO2);
        histdata.loaddata(fosCO2, "eia_co2_emission.csv", "\t", false, 1.0f, 1980, 2002, 2001);
        histdata.loaddata(fosCO2, "UNFCCC_CO2emit.csv", ",", false, 0.27272728f, 1990, 2002, 1990);
        histdata.loaddata(hydepop, "HYDE_pop_kkg.csv", "\t", true, 1.0f, 1700, 1995, 1700);
        histdata.loaddata(hydepop, "pop2002.csv", "\t", false, 1.0f, 2002, 2002, 2002);
        interpolator.linearinterp(hydepop, 1995, 2002);
        histdata.loaddata(epaCH4, "EPA_CH4.csv", "\t", false, 0.04347826f, 1990, 2020, 5, 1990);
        histdata.loaddata(epaN2O, "EPA_N2O.csv", "\t", false, 0.0010749386f, 1990, 2020, 5, 1990);
        jcm12pop = new float[14][101];
        jcm12gdp = new float[14][101];
        jcm12en = new float[14][101];
    }
}

