/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.soc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.interacob;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qtset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.obj.futbasescen;
import jcm.mod.obj.sres;
import jcm.mod.soc.history;
import jcm.mod.soc.socio;
import jcm.mod.soc.socreg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class costs
extends module {
    public qtset abatecost = new qtset("abatecost", "giga&dollar&per&year");
    public qtset damagecost = new qtset("damagecost", "giga&dollar&per&year");
    public qtset totalcost = new qtset("totalcost", "giga&dollar&per&year");
    public qtset abatewelch = new qtset(new Object[]{"abatewelch"});
    public qtset damagewelch = new qtset(new Object[]{"damagewelch"});
    public qtset totalwelch = new qtset(new Object[]{"totalwelch"});
    public qtset reducedgdp = new qtset("reducedgdp", "giga&dollar&per&year");
    public qtset origwelf = new qtset(new Object[]{"welfare no-cli", complexity.expert});
    public param prtp = new param("pure rate time pref", "%", 1.5, 0, 6);
    public param ineqav = new param("inequality-aversion", "", 1.0, 0, 2);
    public param effdisc2000 = new param("effdisc2000", "%", 2.78, 0, 6);
    public param constdisc = new param("fix-effdisc2000", false);
    public param scaleabate = new param(new Object[]{"scaledown abatement", "", 0.33, 0, 1, complexity.expert});
    public param useprtp = new param(new Object[]{"useprtp", true, complexity.expert});
    public param ch4n2o = new param(new Object[]{"ch4n2o", false, complexity.expert});
    public param dyngdp = new param(new Object[]{"dyngdp", true, complexity.expert});
    public param usebackstop = new param("backstop", false);
    public param macgem = new param("macgem", true);
    public param abatepow = new param("abatepow", "", 2.887, 0, 6);
    public param abatelin = new param("abatelin", "", 1, 0, 3);
    public param damagepow = new param("damagecostpow", "", 1.5, 0, 6);
    public param damagelin = new param("damagelin", "", 1, 0, 3);
    public param backstop = new param("backstop", "$", 500, 0, 1000);
    public param impfunc = new param("impfunc", new String[]{"cws", "rice99", "tol02"}, "rice99");
    public float base;
    public float idw;
    public float iaw;
    public float iac;
    public float itw;
    public float iow;
    public float cumprtp;
    public float gtc;
    public float igwp;
    public float scaledownfac;
    boolean firsttime = true;
    List<region> regions;
    Map<region, Float> a1;
    Map<region, Float> b1;
    Map<region, Float> th1;
    Map<region, Float> th2;
    Map<region, Float> macgema;
    Map<region, Float> macgemb;
    static double[] b1_jcm12 = new double[]{0.07, 0.07, 0.05, 0.05, 0.1, 0.15, 0.1, 0.15, 0.1, 0.1, 0.1, 0.1};
    static double[] a1_jcm12 = new double[]{0.01102, 0.01102, 0.01174, 0.01174, 0.01, 0.00857, 0.02093, 0.01523, 0.02903, 0.02903, 0.02903, 0.02903};
    static double[] th1_jcm12 = new double[]{-0.0026, -0.007, -0.007, -0.001, -0.0076, -0.0076, 0.0039, -0.0041, 0.0022, 0.0039, 0.01, 0.01};
    static double[] th2_jcm12 = new double[]{0.0017, 0.003, 0.003, 0.0049, 0.0025, 0.0025, 0.0013, 0.002, 0.0026, 0.0013, 0.0027, 0.0027};
    static double[] macgema_jcm12 = new double[]{373.612, 337.0, 290.224, 241.278, 694.559, 694.559, 269.217, 199.02, 523.793, 496.158, 500.0, 235.499};
    static double[] macgemb_jcm12 = new double[]{1.22, 1.372, 1.251, 1.426, 1.1, 1.1, 1.279, 1.634, 1.209, 1.18, 1.2, 1.846};

    @Override
    public void initsetup() {
        this.follows(this.get(socreg.class));
        this.follows(this.get(glotemp.class));
        this.affectsfutureonly = true;
    }

    @Override
    public void setinteractions() {
        this.setaffects((interacob)this.prtp, this.constdisc.istrue());
        this.setaffects((interacob)this.effdisc2000, !this.constdisc.istrue());
    }

    @Override
    public void precalc() {
        if (!this.firsttime) {
            this.adjdisc();
        }
        for (qtset qq : this.qtsets) {
            this.get(socreg.class).clearoldregions(qq);
        }
        this.regions = ((region)this.get(socreg.class).regions.chosen).reg;
        this.a1 = this.interpolatefac(a1_jcm12, "JCM12", history.hydepop);
        this.b1 = this.interpolatefac(b1_jcm12, "JCM12", history.hydepop);
        this.th1 = this.interpolatefac(th1_jcm12, "JCM12", history.hydepop);
        this.th2 = this.interpolatefac(th2_jcm12, "JCM12", history.hydepop);
        this.macgema = this.interpolatefac(macgema_jcm12, "JCM12", history.hydepop);
        this.macgemb = this.interpolatefac(macgemb_jcm12, "JCM12", history.hydepop);
    }

    @Override
    public void postcalc() {
        if (this.firsttime) {
            this.adjdisc();
        }
    }

    public void reportcosts() {
        System.out.println("emit2050fos, emit2050tot, conc, temp2150, iaw, idw,  =" + this.get(carboncycle.class).fossil.get(2050) + "\t" + this.get(carboncycle.class).totemit.get(2050) + "\t" + this.get(carboncycle.class).co2atppm.get(2200) + "\t" + this.get(glotemp.class).avchangeby.get(2150) + "\t" + this.iaw + "\t" + this.idw);
        System.err.println("emit2050fos, emit2050tot, conc, temp2150, iaw, idw,  =" + this.get(carboncycle.class).fossil.get(2050) + "\t" + this.get(carboncycle.class).totemit.get(2050) + "\t" + this.get(carboncycle.class).co2atppm.get(2200) + "\t" + this.get(glotemp.class).avchangeby.get(2150) + "\t" + this.iaw + "\t" + this.idw);
    }

    void adjdisc() {
        socio soc = this.get(socio.class);
        float dgpcdt = (soc.gdp.get(regman.world, 2000) / soc.pop.get(regman.world, 2000) / (soc.gdp.get(regman.world, 1990) / soc.pop.get(regman.world, 1990)) - 1.0f) / 10.0f;
        this.firsttime = false;
        if (this.constdisc.istrue()) {
            this.prtp.putval(this.effdisc2000.getval() - (double)(100.0f * dgpcdt) * this.ineqav.getval());
            this.prtp.changed = true;
        } else {
            this.effdisc2000.putval(this.prtp.getval() + (double)(100.0f * dgpcdt) * this.ineqav.getval());
            this.effdisc2000.changed = true;
        }
    }

    @Override
    public void calcstep() {
        if (year >= fsy) {
            if (year == fsy) {
                this.ewbase();
            }
            if (year == fsy) {
                this.cumprtp = 1.0f;
                this.iaw = 0.0f;
                this.idw = 0.0f;
                this.itw = 0.0f;
                this.iow = 0.0f;
                this.gtc = 0.0f;
                this.iac = 0.0f;
                this.igwp = 0.0f;
            }
            if (year > fsy && this.useprtp.istrue()) {
                this.cumprtp = (float)((double)this.cumprtp * (1.0 - this.prtp.getval() / 100.0));
            }
            socio soc = this.get(socio.class);
            for (region r : this.regions) {
                float weight = this.ew(r);
                this.damagecost.set(r, this.dc(r));
                this.abatecost.set(r, this.ac(r));
                this.totalcost.set(r, this.damagecost.get(r) + this.abatecost.get(r));
                this.reducedgdp.set(r, soc.gdp.get(r) - this.totalcost.get(r));
                this.origwelf.set(r, soc.gdp.get(r) * weight * this.cumprtp);
                this.damagewelch.set(r, this.damagecost.get(r) * weight * this.cumprtp);
                this.abatewelch.set(r, this.abatecost.get(r) * weight * this.cumprtp);
                this.totalwelch.set(r, this.abatewelch.get(r) + this.damagewelch.get(r));
                this.iaw += this.abatewelch.get(r);
                this.idw += this.damagewelch.get(r);
                this.itw += this.totalwelch.get(r);
                this.iow += this.origwelf.get(r);
                this.iac += this.abatecost.get(r) * this.cumprtp;
                this.igwp += soc.gdp.get(r) * this.cumprtp;
                if (year > 2100) continue;
                this.gtc += this.get(socreg.class).emitfosabate.get(r) * 0.001f;
            }
            for (qtset qq : this.qtsets) {
                qq.calctot();
            }
            if (year == 2100) {
                this.scaledownfac = 7.0E-4f * this.gtc / (100.0f * this.iaw / this.iow);
                System.err.println(" gtc=" + this.gtc + " \t\t awelfloss= " + 100.0f * this.iaw / this.iow + "% \t\t gwploss= " + 100.0f * this.iac / this.igwp + " \t\t scaledown= " + this.scaledownfac);
            }
        }
    }

    public void scaledown() {
        this.scaledownfac = 7.0E-4f * this.gtc / (100.0f * this.iaw / this.iow);
        System.err.println(" gtc=" + this.gtc + " \t\t gwploss= " + 100.0f * this.iaw / this.iow + "% /t/t scaledown= " + this.scaledownfac);
        this.iaw *= this.scaledownfac;
        this.itw = this.iaw + this.idw;
        for (int y = fsy; y <= gey; ++y) {
            for (region r : this.regions) {
                this.abatecost.set(r, y, this.abatecost.get(r, y) * this.scaledownfac);
                this.abatewelch.set(r, y, this.abatewelch.get(r, y) * this.scaledownfac);
                this.totalcost.set(r, y, this.damagecost.get(r, y) + this.abatecost.get(r, y));
                this.reducedgdp.set(r, y, this.get(socio.class).gdp.get(r, y) - this.totalcost.get(r, y));
                this.totalwelch.set(r, y, this.abatewelch.get(r, y) + this.damagewelch.get(r, y));
            }
        }
    }

    public int nr(region r) {
        return this.regions.indexOf(r);
    }

    public float beta(region r) {
        return (float)(this.macgem.istrue() ? 1.0 + this.scaleabate.getval() * (double)(this.macgemb.get(r).floatValue() - 1.0f) : this.abatepow.getval());
    }

    public float gdp(region r) {
        if (this.dyngdp.istrue() && year > fsy) {
            return this.get(socio.class).gdp.get(r) * this.reducedgdp.get(r, year - 1) / this.get(socio.class).gdp.get(r, year - 1);
        }
        return this.get(socio.class).gdp.get(r);
    }

    public float alpha(region r) {
        return (float)(this.abatelin.getval() * (this.macgem.istrue() ? (double)this.macgema.get(r).floatValue() * this.scaleabate.getval() / Math.pow(1000.0, this.beta(r)) : (double)(this.gdp(r) * this.b1.get(r).floatValue()) / Math.pow(this.get(socreg.class).emitfosbase.get(r), this.beta(r))));
    }

    public float ac(region r) {
        float ac;
        if (this.get(socreg.class).emitfosquota.get(r) < 0.0f) {
            return Float.MAX_VALUE;
        }
        float f = ac = this.get(socreg.class).emitfosabate.get(r) > 0.0f ? (float)((double)this.alpha(r) * Math.pow(this.get(socreg.class).emitfosabate.get(r), this.beta(r))) : 0.0f;
        if (this.usebackstop.istrue() && ac / this.get(socreg.class).emitfosabate.get(r) > (float)this.backstop.getval() / 1000.0f) {
            ac = (float)this.backstop.getval() / 1000.0f * this.get(socreg.class).emitfosabate.get(r);
        }
        if (this.ch4n2o.istrue()) {
            float scale = this.get(carboncycle.class).fossil.get(year) / (1000.0f * sres.interp(sres.fosemit, this.get(futbasescen.class).scenario.getchosenindex(), year));
            float ch4red = sres.interp(sres.ch4emit, this.get(futbasescen.class).scenario.getchosenindex(), year) * (1.0f - scale) - 22.0f;
            if (ch4red < 0.0f) {
                ch4red = 0.0f;
            }
            float ch4cost = 0.003f * ch4red * ch4red + 2.0E-4f * ch4red * ch4red * ch4red;
            ac += ch4cost * this.get(socreg.class).emitch4.get(r, 1990) / this.get(socreg.class).emitch4.calctot(1990);
        }
        return ac;
    }

    public float mac(region r) {
        return this.mac(r, module.year);
    }

    public float mac(region r, int year) {
        return (float)((double)(this.beta(r) * this.alpha(r)) * Math.pow(this.get(socreg.class).emitfosabate.get(r, year - 1), this.beta(r) - 1.0f));
    }

    public float dc(region r) {
        if (this.impfunc.chosen == "cws") {
            return (float)((double)this.gdp(r) * this.damagelin.getval() * (double)this.a1.get(r).floatValue() * Math.pow((double)this.get(glotemp.class).avchange.get(year) / 2.5, this.damagepow.getval()));
        }
        if (this.impfunc.chosen == "rice99") {
            float dt = this.get(glotemp.class).avchange.get(year) - this.get(glotemp.class).avchange.get(1990);
            float df = this.th1.get(r).floatValue() * dt + this.th2.get(r).floatValue() * dt * dt;
            return this.gdp(r) * (float)this.damagelin.getval() * (df / 1.0f + df);
        }
        return 0.0f;
    }

    public float ew(region r) {
        return this.ew(r, module.year);
    }

    public float ew(region r, int year) {
        return (float)Math.pow(this.get(socio.class).pop.get(r) / this.gdp(r) * this.base, this.ineqav.getval());
    }

    void ewbase() {
        if (this.dyngdp.istrue()) {
            this.base = 0.0f;
            for (region r : this.regions) {
                this.base += this.gdp(r);
            }
            this.base /= this.get(socio.class).pop.get(regman.world);
        } else {
            this.base = this.get(socio.class).gdp.get(regman.world) / this.get(socio.class).pop.get(regman.world);
        }
    }

    Map<region, Float> interpolatefac(double[] source, String sourcesetname, qtset weights) {
        int year = 2002;
        HashMap<region, Float> dest = new HashMap<region, Float>();
        List<region> sourceset = regman.allreg.find((String)sourcesetname).reg;
        for (region r : this.regions) {
            float sumfac = 0.0f;
            float sumweight = 0.0f;
            Set<region> regnat = r.subreg(regman.nations);
            for (region sr : sourceset) {
                int ri = sourceset.indexOf(sr);
                for (region nat : sr.subreg(regman.nations)) {
                    if (!regnat.contains(nat)) continue;
                    sumfac = (float)((double)sumfac + source[ri] * (double)weights.get(nat, year));
                    sumweight += weights.get(nat, year);
                }
            }
            dest.put(r, Float.valueOf(sumfac / sumweight));
        }
        return dest;
    }
}

