/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.soc;

import java.awt.Color;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.obj.globco2emit;
import jcm.mod.soc.history;
import jcm.mod.soc.socreg;

public class AviaShipEmit
extends module {
    public static int sy = 1900;
    public static int ey = 2200;
    public param<scen> aviascen = new param(new Object[]{"Aviation Scenario", scen.values(), scen.Fa1});
    public param scaleavia = new param("Reduce for Stabilisation", true);
    public qtset secemit = new qtset("Aviation & Shipping CO2 Emissions", "mega&ton&carbon&per&yr", sy, ey);
    float avtotbase;
    float matotbase;
    float totbunk;
    float avnomil;
    float manomil;
    float mainc;
    float favdom;
    float favA1;
    float fmadom;
    float fmaA1;
    float scaledown;
    scen sc;
    int scenyear = 0;
    socreg sr;
    globco2emit gc;

    public void initsetup() {
        this.sr = this.get(socreg.class);
        this.gc = this.get(globco2emit.class);
        for (sec s : sec.values()) {
            this.secemit.reg((Object)((Object)s)).color = s.col;
            if (!s.name().startsWith("tot")) continue;
            this.secemit.reg((Object)((Object)s)).type = qt.Type.total;
        }
        this.aviashiphistory();
        this.follows(globco2emit.class);
    }

    void aviashiphistory() {
        float CO2fac = 0.27272728f;
        this.secemit.set((Object)sec.Ship_A1_int, 2002, 204.0f * CO2fac);
        this.secemit.set((Object)sec.Ship_A1_dom, 2002, 100.0f * CO2fac);
        this.secemit.set((Object)sec.Avia_A1_int, 2002, 205.0f * CO2fac);
        this.secemit.set((Object)sec.Avia_A1_dom, 2002, 240.0f * CO2fac);
        this.secemit.set((Object)sec.Ship_DC_int, 2002, this.secemit.get((Object)sec.Ship_A1_int, 2002));
        this.secemit.set((Object)sec.Ship_DC_dom, 2002, this.secemit.get((Object)sec.Ship_A1_dom, 2002));
        this.secemit.set((Object)sec.Avia_DC_int, 2002, this.secemit.get((Object)sec.Avia_A1_int, 2002) * 0.5f);
        this.secemit.set((Object)sec.Avia_DC_dom, 2002, this.secemit.get((Object)sec.Avia_A1_dom, 2002) * 0.5f);
        float cf = 187.0f * (history.fosCO2.calctot(2002) / history.fosCO2.calctot(2000)) / (660.825f * CO2fac * (1.0f + this.fracmil(2000)));
        for (sec s : sec.values()) {
            if (!s.name().contains("Avia") || s.name().contains("mil")) continue;
            this.secemit.set((Object)s, 2002, this.secemit.get((Object)s, 2002) * cf);
        }
        for (int y = 2002; y >= sy; --y) {
            float rtot = history.fosCO2.calctot(y) / history.fosCO2.calctot(y + 1);
            for (sec s : sec.values()) {
                int i$;
                if (s.name().contains("tot")) {
                    String tt = s.name().substring(4);
                    float t = 0.0f;
                    for (sec ss : s.values()) {
                        if (ss.name().contains("tot") || !ss.name().contains(tt)) continue;
                        t += this.secemit.get((Object)ss, y);
                    }
                    this.secemit.set((Object)s, y, t);
                    continue;
                }
                if (s == sec.Avia_mil) {
                    float f = 0.0f;
                    sec[] arr$ = s.values();
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        sec ss = arr$[i$];
                        if (ss == sec.Avia_mil || !ss.name().contains("Avia")) continue;
                        f += this.secemit.get((Object)ss, y);
                    }
                    this.secemit.set((Object)s, y, f * this.fracmil(y));
                    continue;
                }
                if (s == sec.Ship_mil) {
                    float f = 0.0f;
                    sec[] arr$ = s.values();
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        sec ss = arr$[i$];
                        if (ss == sec.Ship_mil || !ss.name().contains("Ship")) continue;
                        f += this.secemit.get((Object)ss, y);
                    }
                    this.secemit.set((Object)s, y, f * this.fracmil(y) * 0.25f);
                    continue;
                }
                if (y >= 2002) continue;
                float incperyr = (s.name().contains("Avia") && y < 2000 ? 2.5f : 0.0f) + (s.name().contains("DC") ? 1.5f : 0.0f);
                this.secemit.set((Object)s, y, this.secemit.get((Object)s, y + 1) * (100.0f / (100.0f + incperyr)) * rtot);
            }
        }
    }

    void setupfuture() {
        this.sc = (scen)((Object)this.aviascen.chosen);
        this.scenyear = 0;
        this.mainc = 0.01f;
        this.favdom = this.secemit.get((Object)sec.Avia_A1_dom, fsy - 1) / (this.secemit.get((Object)sec.Avia_A1_int, fsy - 1) + this.secemit.get((Object)sec.Avia_A1_dom, fsy - 1));
        this.favA1 = this.secemit.get((Object)sec.Avia_A1_int, fsy - 1) / (this.secemit.get((Object)sec.Avia_A1_int, fsy - 1) + this.secemit.get((Object)sec.Avia_DC_int, fsy - 1));
        this.fmadom = this.secemit.get((Object)sec.Ship_A1_dom, fsy - 1) / (this.secemit.get((Object)sec.Ship_A1_int, fsy - 1) + this.secemit.get((Object)sec.Ship_A1_dom, fsy - 1));
        this.fmaA1 = this.secemit.get((Object)sec.Ship_A1_int, fsy - 1) / (this.secemit.get((Object)sec.Ship_A1_int, fsy - 1) + this.secemit.get((Object)sec.Ship_DC_int, fsy - 1));
    }

    public void calcstep() {
        if (year == fsy) {
            this.setupfuture();
        }
        if (year >= fsy && year <= ey) {
            this.favdom *= 0.99f;
            this.favA1 *= 0.99f;
            this.fmadom *= 0.99f;
            this.fmaA1 *= 0.99f;
            this.mainc *= 0.99f;
            if (year > scen.y[this.scenyear] && year < 2050) {
                ++this.scenyear;
            }
            this.avtotbase = 1000.0f * ((float)(year - scen.y[this.scenyear - 1]) * this.sc.co2[this.scenyear] + (float)(scen.y[this.scenyear] - year) * this.sc.co2[this.scenyear - 1]) / (float)(scen.y[this.scenyear] - scen.y[this.scenyear - 1]);
            this.avnomil = this.avtotbase / (1.0f + this.fracmil(year));
            this.matotbase = year == fsy ? this.secemit.get((Object)sec.tot_Ship, fsy - 1) : this.matotbase * (1.0f + this.mainc);
            this.manomil = this.matotbase / (1.0f + this.fracmil(year) * 0.25f);
            this.totbunk = this.avnomil * (1.0f - this.favdom) + this.manomil * (1.0f - this.fmadom);
            this.sr.emitfosbase.set("bunker", this.totbunk);
            if (year <= 2100) {
                this.sr.emitfosbase.topdownscale(this.gc.fossilbase.get(), true);
            } else {
                this.gc.fossilbase.set(this.sr.emitfosbase.calctot());
            }
            this.scaledown = this.scaleavia.istrue() ? this.gc.fossil.get() / this.gc.fossilbase.get() : 1.0f;
            this.sr.emitfosquota.set("bunker", this.totbunk * this.scaledown);
            this.avnomil *= this.scaledown;
            this.manomil *= this.scaledown;
            this.secemit.set((Object)sec.tot_Avia, year, this.avtotbase * this.scaledown);
            this.secemit.set((Object)sec.Avia_mil, year, this.avnomil * this.fracmil(year));
            this.secemit.set((Object)sec.Avia_A1_int, year, this.avnomil * (1.0f - this.favdom) * this.favA1);
            this.secemit.set((Object)sec.Avia_A1_dom, year, this.avnomil * this.favdom * this.favA1);
            this.secemit.set((Object)sec.Avia_DC_int, year, this.avnomil * (1.0f - this.favdom) * (1.0f - this.favA1));
            this.secemit.set((Object)sec.Avia_DC_dom, year, this.avnomil * this.favdom * (1.0f - this.favA1));
            this.secemit.set((Object)sec.tot_Ship, year, this.matotbase * this.scaledown);
            this.secemit.set((Object)sec.Ship_mil, year, this.manomil * this.fracmil(year) * 0.25f);
            this.secemit.set((Object)sec.Ship_A1_int, year, this.manomil * (1.0f - this.fmadom) * this.fmaA1);
            this.secemit.set((Object)sec.Ship_A1_dom, year, this.manomil * this.fmadom * this.fmaA1);
            this.secemit.set((Object)sec.Ship_DC_int, year, this.manomil * (1.0f - this.fmadom) * (1.0f - this.fmaA1));
            this.secemit.set((Object)sec.Ship_DC_dom, year, this.manomil * this.fmadom * (1.0f - this.fmaA1));
            for (sec s : sec.values()) {
                if (!s.name().contains("tot")) continue;
                String tt = s.name().substring(4);
                float t = 0.0f;
                for (sec ss : s.values()) {
                    if (ss.name().contains("tot") || !ss.name().contains(tt)) continue;
                    t += this.secemit.get((Object)ss, year);
                }
                this.secemit.set((Object)s, year, t);
            }
        }
    }

    float fracmil(int year) {
        int[] y = new int[]{0, 1945, 1976, 1992, 2015, 2050, 9999};
        float[] f = new float[]{0.4f, 0.6f, 0.36f, 0.18f, 0.07f, 0.03f, 0.03f};
        int i = 0;
        while (year >= y[i]) {
            ++i;
        }
        float ff = ((float)(year - y[i - 1]) * f[i] + (float)(y[i] - year) * f[i - 1]) / (float)(y[i] - y[i - 1]);
        return ff / (1.0f - ff);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum scen {
        Fa1(new float[]{0.147f, 0.187f, 0.279f, 0.315f, 0.405f}, new float[]{2.0f, 2.8f, 4.3f, 5.1f, 7.2f}),
        Fa2(new float[]{0.147f, 0.187f, 0.279f, 0.319f, 0.419f}, new float[]{2.0f, 2.8f, 4.3f, 4.7f, 5.6f}),
        Fc1(new float[]{0.147f, 0.187f, 0.279f, 0.265f, 0.231f}, new float[]{2.0f, 2.8f, 4.3f, 4.2f, 4.0f}),
        Fe1(new float[]{0.147f, 0.187f, 0.279f, 0.382f, 0.64f}, new float[]{2.0f, 2.8f, 4.3f, 6.4f, 11.4f}),
        Eab(new float[]{0.147f, 0.179f, 0.255f, 0.463f, 0.983f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f}),
        Edh(new float[]{0.147f, 0.224f, 0.385f, 0.69f, 1.452f}, new float[]{2.0f, 2.8f, 4.3f, 6.4f, 11.6f});

        public static int[] y;
        public float[] co2;
        public float[] nox;

        private scen(float[] f1, float[] f2) {
            this.co2 = f1;
            this.nox = f2;
        }

        static {
            y = new int[]{1990, 2000, 2015, 2025, 2050};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum sec {
        Ship_A1_int(colfont.dkblue),
        Ship_DC_int(colfont.dkcyan),
        Ship_A1_dom(colfont.ltblue),
        Ship_DC_dom(colfont.cyan),
        Ship_mil(colfont.dkyellowgreen),
        Avia_A1_int(colfont.dkred),
        Avia_DC_int(colfont.dkorange),
        Avia_A1_dom(colfont.pink),
        Avia_DC_dom(colfont.orange),
        Avia_mil(colfont.yellow),
        tot_int(colfont.dkgrey),
        tot_dom(colfont.grey),
        tot_Ship(colfont.blue),
        tot_Avia(colfont.red),
        tot_all(colfont.black),
        tot_all_base(colfont.green);

        Color col;

        private sec(Color c) {
            this.col = c;
        }
    }
}

