/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.obj;

import jcm.core.complexity;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.obj.controller;
import jcm.mod.obj.futbasescen;
import jcm.mod.obj.sres;
import jcm.mod.soc.AviaShipEmit;
import jcm.mod.soc.history;
import jcm.mod.soc.socreg;
import jcm.mod.soc.sresext;

public class globco2emit
extends module {
    public param potlucfrac = new param(new Object[]{"potlucfrac%", "", colfont.green, 1.0, 0, 2, complexity.expert});
    public param potlucconvergence = new param(new Object[]{"potlucfracConverg%", "", colfont.green, 0.5, 0, 2, complexity.expert});
    public param fixedfrac = new param(new Object[]{"fix luc/fossil stab", false, complexity.experimental});
    public param correctfosstart = new param("correct2000fos", true);
    public param correctlucstart = new param("correct2000luc", true);
    public qt fossil;
    public qt lucf;
    public qt totemit;
    public qt potlucbase = new qt(new Object[]{"globpotlucbase", colfont.ltgreen, fsy, gey, complexity.expert});
    public qt potlucquota = new qt(new Object[]{"globpotlucquota", colfont.dkgreen, complexity.expert});
    public qt fossilbase = new qt("fossilemitbase", colfont.dkred, fsy, gey);
    public qt lucfbase = new qt("lucemitbase", colfont.dkorange, fsy, gey);
    public qtset globco2curves;
    float globalcorrfacfos;
    float globalcorrfacluc;
    carboncycle carb;
    futbasescen fbs;
    qtset emitfosbase;
    qtset emitlucbase;
    private float alpha;
    public float plf;
    public int fsyluc;
    public int sc;
    public boolean nopolicy;
    public boolean houghton;

    public void initsetup() {
        this.follows(history.class);
        this.follows(futbasescen.class);
        this.follows(sresext.class);
        this.follows(controller.class);
        this.setaffectedby(AviaShipEmit.class);
        this.fbs = this.get(futbasescen.class);
        this.carb = this.get(carboncycle.class);
        this.fossil = this.carb.fossil;
        this.lucf = this.carb.lucf;
        this.totemit = this.carb.totemit;
        this.globco2curves = new qtset("globco2curves", this.fossilbase, this.lucfbase, this.fossil, this.lucf, this.totemit, this.potlucbase, this.potlucquota);
        this.potlucquota.set(gsy, 0.0f);
        this.emitfosbase = this.get(socreg.class).emitfosbase;
        this.emitlucbase = this.get(socreg.class).emitlucbase;
        this.affectsfutureonly = true;
    }

    public void precalc() {
        this.nopolicy = this.get(controller.class).objective.chosen.equals("nopolicy");
        this.plf = -((float)(this.potlucfrac.getval() / 100.0));
        this.sc = this.get(futbasescen.class).scenario.getchosenindex();
        this.houghton = this.get(CalcLucEmit.class).lucsource.chosen.equals("Houghton");
        this.fsyluc = this.houghton ? 2001 : 2003;
    }

    public void calcstep() {
        if (year > gsy) {
            this.potlucquota.set(this.potlucquota.get(year - 1) + this.lucf.get(year - 1) * this.plf);
        }
        if (year >= fsy && year <= 2100) {
            this.globalcorrfacfos = this.correctfosstart.istrue() ? (year == fsy ? 1000.0f * sres.interp(sres.fosemit, this.sc, fsy - 1) - this.emitfosbase.calctot(fsy - 1) : this.globalcorrfacfos * 0.95f) : 0.0f;
            this.fossilbase.set(1000.0f * sres.interp(sres.fosemit, this.sc, year) - this.globalcorrfacfos);
            this.emitfosbase.topdownscale(this.fossilbase.get(), true);
            this.globalcorrfacluc = this.correctlucstart.istrue() ? (year == this.fsyluc ? this.emitlucbase.calctot(this.fsyluc - 1) / (1000.0f * sres.interp(sres.lucemit, this.sc, this.fsyluc - 1)) : 0.05f + this.globalcorrfacluc * 0.95f) : 1.0f;
            this.lucfbase.set(1000.0f * sres.interp(sres.lucemit, this.sc, year) * this.globalcorrfacluc);
        }
        if (year > 2100) {
            float fac = this.lucfbase.get(year - 1) < this.potlucbase.get(year - 1) ? 1.0f : (float)this.potlucconvergence.getval() / 100.0f;
            this.lucfbase.set(fac * this.potlucbase.get(year - 1) + (1.0f - fac) * this.lucfbase.get(year - 1));
        }
        if (year >= fsy) {
            this.potlucbase.set(year == fsy ? this.potlucquota.get() : this.potlucbase.get(year - 1) + this.lucfbase.get() * this.plf);
            this.alpha = (this.lucfbase.get() - this.potlucbase.get()) / this.fossilbase.get();
            if (this.nopolicy) {
                this.fossil.set(this.fossilbase.get());
                this.lucf.set(this.lucfbase.get());
                this.totemit.set(this.fossilbase.get() + this.lucfbase.get());
            } else {
                this.lucf.set(this.fixedfrac.istrue() ? this.totemit.get() * this.lucf.get(fsy - 1) / this.totemit.get(fsy - 1) : (this.totemit.get() * this.alpha + this.potlucquota.get()) / (1.0f + this.alpha));
                this.fossil.set(this.totemit.get() - this.lucf.get());
                if (this.fossil.get() < 0.0f) {
                    this.fossil.set(0.0f);
                    this.lucf.set(this.totemit.get());
                }
            }
        }
    }
}

