/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jcm.core.complexity;
import jcm.core.interacob;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.gui.gen.colfont;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;

public class udebclimod
extends module {
    double[][] cmp = new double[][]{{3.71, 4.2, 8.0, 2.3, 1.2, 1.0, 1.0, 60.0, 0.2, 1.25}, {3.45, 3.7, 5.0, 1.6, 1.2, 1.0, 1.0, 60.0, 0.2, 1.25}, {3.74, 3.0, 25.0, 1.9, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {3.47, 2.5, 12.0, 1.7, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {3.8, 2.6, 20.0, 9.0, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {3.6, 1.9, 9999.0, 2.3, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {3.6, 1.7, 14.0, 2.3, 1.4, 0.5, 0.5, 60.0, 0.2, 1.25}, {4.37, 2.5, 7.0, 1.0, 1.3, 1.0, 1.0, 90.0, 0.2, 1.0}, {3.0, 1.5, 0.0, 0.05, 0.7, 0.0, 0.0, 1.0, 0.0, 0.8}, {5.0, 4.5, 30.0, 4.0, 1.5, 4.0, 2.0, 120.0, 1.0, 1.6}};
    int model = 2;
    String[] climodname = new String[]{"gfdl", "csiro", "hadcm3", "hadcm2", "echam4", "csm", "doe", "ipccsar"};
    public param climod = new param(new Object[]{"climodmenu", this.climodname, "hadcm3", complexity.simplest}){

        public void precalc() {
            udebclimod.this.changeclimod(this.getchosenindex());
            udebclimod.this.get(sealevel.class).seticecaptomod(this.getchosenindex());
        }
    };
    public param rfco2double = new param("rfco2d", "w&per&m2", this.cmp[this.model][0], this.cmp[8][0], this.cmp[9][0]);
    public param climsens = new param(new Object[]{"climsens", "degc", this.cmp[this.model][1], 1, 7, colfont.red, complexity.simplest});
    public param heatdiffusivity = new param("teddydiff", "cm2&per&s", this.cmp[this.model][3], this.cmp[8][3], this.cmp[9][3], colfont.dkblue);
    public param landoceantempratio = new param(new Object[]{"lotr", "", this.cmp[this.model][4], this.cmp[8][4], this.cmp[9][4], colfont.orange, complexity.expert});
    public param knorthsouth = new param(new Object[]{"kns", "", this.cmp[this.model][5], this.cmp[8][5], this.cmp[9][5], colfont.dkgreen, complexity.expert});
    public param klandocean = new param(new Object[]{"klo", "", this.cmp[this.model][6], this.cmp[8][6], this.cmp[9][6], colfont.yellowgreen, complexity.expert});
    public param mixlaydepth = new param(new Object[]{"tmixlay", "metres", this.cmp[this.model][7], this.cmp[8][7], this.cmp[9][7], colfont.grey, complexity.expert});
    public param polarsinktempratio = new param(new Object[]{"psi", "", this.cmp[this.model][8], this.cmp[8][8], this.cmp[9][8], colfont.blue, complexity.expert});
    public param seaice = new param(new Object[]{"seaice", "", this.cmp[this.model][9], this.cmp[8][9], this.cmp[9][9], colfont.cyan, complexity.expert});
    public param varupwell = new param(new Object[]{"tufbopt", true, colfont.magenta, complexity.expert});
    public param zeroupwelltemp = new param(new Object[]{"tnoupwell", "degc", this.cmp[this.model][2], this.cmp[8][2], this.cmp[9][2], "lilac", complexity.expert});
    public param upwellreducefrac = new param(new Object[]{"uwredfrac", "", 0.3, 0, 1, colfont.dkpurple, complexity.expert});
    public param upwellbaserate = new param(new Object[]{"uwbaserate", "m&per&yr", 4, 0, 8, colfont.pink, complexity.expert});
    param[] climodparam = new param[]{this.rfco2double, this.climsens, this.zeroupwelltemp, this.heatdiffusivity, this.landoceantempratio, this.knorthsouth, this.klandocean, this.mixlaydepth, this.polarsinktempratio, this.seaice};
    public static final int nhl = 34;
    public static final int nhb = 35;
    public double[][] hiq = this.hbox();
    public double[][] hiqi = this.hbox();
    public double[][] hiq99 = this.hbox();
    public double[][] hpropf = this.hbox();
    public double[][] hrML = this.hbox();
    public double[][] shicML = this.hbox();
    public double[][] rhicML = this.hbox();
    public double[][] hrsl = this.hbox();
    public double[] frac = new double[]{0.199, 0.301, 0.406, 0.094};
    double fracl = this.frac[0] + this.frac[3];
    double fraco = 1.0 - this.fracl;
    double[][] khi = new double[4][4];
    double[] khir = new double[4];
    public double tstart = 18.17;
    public double kls;
    public double kos;
    public double klo;
    public double kns;
    public double nstd;
    public double nstdold;
    public double dqin;
    public double qpt;
    public double sl;
    public double cice;
    double[] qin = new double[2];
    double[] qinbase = new double[2];
    double[] qinold = new double[2];
    double[] qinold99 = new double[2];
    double[] mlt = new double[2];
    public double[] spaceflux = new double[2];
    double totrf99;
    double nstd99;
    double nstdold99;
    double dt;
    double hu;
    double pi;
    double diffu;
    double dml;
    double rvu;
    double rv;
    double rjff;
    double polsink;
    double mlbaserate;
    double hiquc;
    double reftemp = 0.0;
    double[] dl;
    double[] vec;
    double[][] rate;
    public double[][] hiqstart = new double[2][35];
    Matrix M;
    Matrix U;
    Matrix[] MV = new Matrix[2];
    Matrix[] MVI = new Matrix[2];
    double[][][] upwellstep = new double[2][35][35];
    int startyear;
    int tstep;
    double guess;
    double nit;
    double ciqr;
    double diff;
    public double sealevteinit;

    public void setinteractions() {
        for (int i = 0; i < this.climodparam.length; ++i) {
            this.climodparam[i].setaffectedby(this.climod);
        }
        this.rfco2double.setaffects(this.get(radfor.class));
        this.setaffectedby((interacob)this.zeroupwelltemp, this.varupwell.istrue());
        this.setaffectedby((interacob)this.upwellreducefrac, this.varupwell.istrue());
        this.setaffectedby((interacob)this.upwellbaserate, this.varupwell.istrue());
    }

    void changeclimod(int mod) {
        this.model = mod;
        for (int i = 0; i < this.climodparam.length; ++i) {
            this.climodparam[i].putval(this.cmp[mod][i]);
        }
        this.setupfluxes();
    }

    public void precalc() {
        if (!this.climod.changed) {
            this.setupfluxes();
        }
    }

    double[][] hbox() {
        return new double[2][35];
    }

    public void setupfluxes() {
        int n;
        int j;
        int i;
        double clotr;
        this.dt = 1.0;
        this.dml = this.mixlaydepth.getval();
        this.dl = new double[34];
        for (int n2 = 0; n2 < 34; ++n2) {
            this.dl[n2] = (n2 < 20 ? 49.0 : 196.0) * 1.0;
        }
        this.diffu = this.heatdiffusivity.getval() * 3.1536E7 / 10000.0;
        this.hu = this.upwellbaserate.getval();
        this.pi = this.polarsinktempratio.getval();
        double cw = 0.1300101471334348;
        this.qpt = cw * this.dml;
        this.klo = this.klandocean.getval();
        this.kns = this.knorthsouth.getval();
        double lotr = this.landoceantempratio.getval();
        this.cice = this.seaice.getval();
        double oldclotr = 1.0;
        double oldkos = -99.0;
        this.kos = 0.9;
        do {
            this.kls = this.rfco2double.getval() / this.climsens.getval() * (lotr * this.fracl + this.fraco) / (lotr * this.fracl) - this.kos * this.fraco / (lotr * this.fracl);
            this.khi = new Matrix(new double[][]{{this.frac[0] * this.kls + this.klo, -this.klo, 0.0, 0.0}, {-this.klo, this.frac[1] * this.kos + this.klo + this.kns, -this.kns, 0.0}, {0.0, -this.kns, this.frac[2] * this.kos + this.klo + this.kns, -this.klo}, {0.0, 0.0, -this.klo, this.frac[3] * this.kls + this.klo}}, 4, 4).inverse().getArray();
            for (i = 0; i < 4; ++i) {
                this.khir[i] = 0.0;
                for (j = 0; j < 4; ++j) {
                    double[] dArray = this.khi[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] * this.frac[j];
                    int n4 = i;
                    this.khir[n4] = this.khir[n4] + this.khi[i][j];
                }
            }
            clotr = (this.frac[0] * this.khir[0] + this.frac[3] * this.khir[3]) / this.fracl / ((this.frac[1] * this.khir[1] + this.frac[2] * this.khir[2]) / this.fraco);
            double newkos = oldkos == -99.0 ? 1.0 : this.kos + (lotr - clotr) * (this.kos - oldkos) / (clotr - oldclotr);
            oldkos = this.kos;
            this.kos = newkos;
            oldclotr = clotr;
        } while (Math.abs(lotr - clotr) > 1.0E-4);
        this.rate = new double[35][35];
        for (i = 0; i < 35; ++i) {
            for (j = 0; j < 35; ++j) {
                this.rate[i][j] = 0.0;
            }
        }
        int n5 = 1;
        while (n5 < 34) {
            this.rvu = (2.0 * this.diffu - this.hu * this.dl[n5]) / (this.dl[n5 - 1] * (this.dl[n5 - 1] + this.dl[n5]));
            this.rv = (2.0 * this.diffu + this.hu * this.dl[n5 - 1]) / (this.dl[n5] * (this.dl[n5 - 1] + this.dl[n5]));
            double[] dArray = this.rate[n5];
            int n6 = n5 - 1;
            dArray[n6] = dArray[n6] + this.rvu;
            double[] dArray2 = this.rate[n5 - 1];
            int n7 = n5 - 1;
            dArray2[n7] = dArray2[n7] - this.rvu;
            double[] dArray3 = this.rate[n5 - 1];
            int n8 = n5;
            dArray3[n8] = dArray3[n8] + this.rv;
            double[] dArray4 = this.rate[n5];
            int n9 = n5++;
            dArray4[n9] = dArray4[n9] - this.rv;
        }
        this.rvu = 8.0 * this.diffu / (3.0 * this.dl[0] * this.dml) - this.hu / this.dml;
        this.rv = 3.0 * this.diffu / (this.dl[0] * this.dl[0]);
        this.rjff = this.diffu / (3.0 * this.dl[0] * this.dl[0]);
        double[] dArray = this.rate[0];
        dArray[34] = dArray[34] + this.rvu;
        double[] dArray5 = this.rate[34];
        dArray5[34] = dArray5[34] - this.rvu;
        double[] dArray6 = this.rate[34];
        dArray6[0] = dArray6[0] + this.rv;
        double[] dArray7 = this.rate[0];
        dArray7[0] = dArray7[0] - this.rv;
        double[] dArray8 = this.rate[0];
        dArray8[1] = dArray8[1] + this.rjff;
        double[] dArray9 = this.rate[34];
        dArray9[1] = dArray9[1] - this.rjff;
        this.polsink = this.pi * this.hu / this.dml;
        double[] dArray10 = this.rate[33];
        dArray10[34] = dArray10[34] + this.polsink;
        double[] dArray11 = this.rate[34];
        dArray11[34] = dArray11[34] - this.polsink;
        this.mlbaserate = this.rate[34][34];
        this.M = new Matrix(this.rate, 35, 35);
        if (this.varupwell.istrue()) {
            int n10;
            double[][] urate = new double[35][35];
            for (n10 = 0; n10 < 35; ++n10) {
                for (int m = 0; m < 35; ++m) {
                    urate[n10][m] = 0.0;
                }
            }
            n10 = 1;
            while (n10 < 34) {
                this.rvu = -this.hu * this.dl[n10] / (this.dl[n10 - 1] * (this.dl[n10 - 1] + this.dl[n10]));
                this.rv = this.hu * this.dl[n10 - 1] / (this.dl[n10] * (this.dl[n10 - 1] + this.dl[n10]));
                double[] dArray12 = urate[n10];
                int n11 = n10 - 1;
                dArray12[n11] = dArray12[n11] + this.rvu;
                double[] dArray13 = urate[n10 - 1];
                int n12 = n10 - 1;
                dArray13[n12] = dArray13[n12] - this.rvu;
                double[] dArray14 = urate[n10 - 1];
                int n13 = n10;
                dArray14[n13] = dArray14[n13] + this.rv;
                double[] dArray15 = urate[n10];
                int n14 = n10++;
                dArray15[n14] = dArray15[n14] - this.rv;
            }
            this.rvu = -this.hu / this.dml;
            double[] dArray16 = urate[0];
            dArray16[34] = dArray16[34] + this.rvu;
            double[] dArray17 = urate[34];
            dArray17[34] = dArray17[34] - this.rvu;
            this.polsink = this.pi * this.hu / this.dml;
            double[] dArray18 = urate[33];
            dArray18[34] = dArray18[34] + this.polsink;
            double[] dArray19 = urate[34];
            dArray19[34] = dArray19[34] - this.polsink;
            this.U = new Matrix(urate, 35, 35);
        }
        double mlstart = this.tstart * this.qpt;
        Matrix veclay = this.M.getMatrix(0, 33, 0, 33).inverse().times(this.M.getMatrix(0, 33, 34, 34)).times(-mlstart);
        double[] hss = veclay.transpose().getArray()[0];
        double[] tss = new double[35];
        tss[34] = this.tstart;
        for (int n15 = 0; n15 < 34; ++n15) {
            tss[n15] = hss[n15] / (cw * this.dl[n15]);
        }
        double[] pr = new double[35];
        double pz = 5071.5;
        pr[34] = 101325.0 + pz * this.dml;
        pr[0] = pr[34] + pz * (this.dml + this.dl[0]);
        for (n = 1; n < 34; ++n) {
            pr[n] = pr[n - 1] + pz * (this.dl[n - 1] + this.dl[n]);
        }
        this.vec = new double[35];
        for (n = 0; n < 35; ++n) {
            this.vec[n] = 1.0 / cw * (1.0E-4 * (0.5 + 0.12 * tss[n] - 8.0E-4 * tss[n] * tss[n] + 2.8 * (1.0 - 0.027 * tss[n]) * (pr[n] * 1.0E-8 - 0.24 * pr[n] * pr[n] * 1.0E-16)));
        }
        double[] Eig = new double[35];
        double[] stepf = new double[35];
        double[] rampf = new double[35];
        double[] hicML = new double[35];
        for (int o = 0; o < 2; ++o) {
            int m;
            int n16;
            this.spaceflux[o] = 1.0 / this.qpt * this.cice * (this.kos + this.klo / this.frac[o + 1] * (this.kls * this.frac[o * 3] / (this.kls * this.frac[o * 3] + this.klo)));
            this.M.set(34, 34, this.mlbaserate - this.spaceflux[o]);
            EigenvalueDecomposition ED = new EigenvalueDecomposition(this.M);
            this.MV[o] = ED.getV();
            this.MVI[o] = this.MV[o].inverse();
            for (n16 = 0; n16 < 35; ++n16) {
                this.hiqstart[o][n16] = 0.0;
                for (m = 0; m < 35; ++m) {
                    double[] dArray20 = this.hiqstart[o];
                    int n17 = n16;
                    dArray20[n17] = dArray20[n17] + this.MVI[o].getArray()[n16][m] * (m < 34 ? hss[m] : mlstart);
                }
            }
            Eig = ED.getRealEigenvalues();
            for (n16 = 0; n16 < 35; ++n16) {
                this.hpropf[o][n16] = Math.exp(Eig[n16] * this.dt);
                if (Math.abs(Eig[n16]) < 1.0E-6) {
                    stepf[n16] = this.dt;
                    rampf[n16] = this.dt / 2.0;
                    continue;
                }
                stepf[n16] = (this.hpropf[o][n16] - 1.0) / Eig[n16];
                rampf[n16] = (stepf[n16] - this.dt) / (Eig[n16] * this.dt);
            }
            this.hrML[o] = this.MV[o].getArray()[34];
            hicML = this.MVI[o].transpose().getArray()[34];
            for (n16 = 0; n16 < 35; ++n16) {
                this.rhicML[o][n16] = rampf[n16] * hicML[n16];
                this.shicML[o][n16] = stepf[n16] * hicML[n16];
            }
            n16 = 0;
            while (n16 < 35) {
                for (int i2 = 1; i2 < 35; ++i2) {
                    double[] dArray21 = this.hrsl[o];
                    int n18 = n16;
                    dArray21[n18] = dArray21[n18] + this.MV[o].getArray()[i2][n16];
                }
                double[] dArray22 = this.hrsl[o];
                int n19 = n16;
                dArray22[n19] = dArray22[n19] * this.vec[n16];
                double[] dArray23 = this.hrsl[o];
                int n20 = n16++;
                dArray23[n20] = dArray23[n20] * (this.frac[o + 1] / (this.frac[1] + this.frac[2]));
            }
            if (!this.varupwell.istrue()) continue;
            this.upwellstep[o] = this.MVI[o].times(this.U.times(this.MV[o])).getArray();
            for (n16 = 0; n16 < 35; ++n16) {
                for (m = 0; m < 35; ++m) {
                    double[] dArray24 = this.upwellstep[o][n16];
                    int n21 = m;
                    dArray24[n21] = dArray24[n21] * (stepf[m] / this.zeroupwelltemp.getval());
                }
            }
        }
        Eig = null;
        rampf = null;
        stepf = null;
        hicML = null;
    }

    public void startstate(int startyear) {
        this.startyear = startyear;
        if (startyear == 1750) {
            this.nstd = 0.0;
            this.nstdold = 0.0;
            for (int o = 0; o < 2; ++o) {
                this.qinold[o] = this.spaceflux[o] * this.qpt * this.tstart;
                for (int n = 0; n < 35; ++n) {
                    this.hiq[o][n] = this.hiqstart[o][n];
                }
            }
        } else {
            startyear = 2000;
            this.nstd = this.nstd99;
            this.nstdold = this.nstdold99;
            this.qinold[0] = this.qinold99[0];
            this.qinold[1] = this.qinold99[1];
            for (int o = 0; o < 2; ++o) {
                for (int n = 0; n < 35; ++n) {
                    this.hiq[o][n] = this.hiq99[o][n];
                }
            }
        }
    }

    public void save99() {
        for (int o = 0; o < 2; ++o) {
            this.nstd99 = this.nstd;
            this.nstdold99 = this.nstdold;
            this.qinold99[o] = this.qinold[o];
            for (int n = 0; n < 35; ++n) {
                this.hiq99[o][n] = this.hiq[o][n];
            }
        }
    }

    public float adjust(float[] rf) {
        int n;
        int o;
        this.nstdold = this.nstd = (this.guess = this.nstd + (this.nstd - this.nstdold));
        for (o = 0; o < 2; ++o) {
            for (n = 0; n < 35; ++n) {
                this.hiq[o][n] = this.hpropf[o][n] * this.hiq[o][n] + this.shicML[o][n] * this.qinold[o];
            }
            this.qinbase[o] = rf[o + 1];
            int n2 = o;
            this.qinbase[n2] = this.qinbase[n2] + (double)rf[o * 3] * (this.frac[o * 3] / this.frac[o + 1]) * this.klo / (this.kls * this.frac[o * 3] + this.klo);
            int n3 = o;
            this.qinbase[n3] = this.qinbase[n3] + this.spaceflux[o] * this.qpt * this.tstart;
        }
        this.nit = 0.0;
        do {
            o = 0;
            while (o < 2) {
                this.qin[o] = this.qinbase[o] + (o == 0 ? -1.0 : 1.0) * this.nstd * this.kns / this.frac[o + 1];
                this.dqin = this.qin[o] - this.qinold[o];
                this.mlt[o] = 0.0;
                for (n = 0; n < 35; ++n) {
                    this.hiqi[o][n] = this.hiq[o][n] + this.rhicML[o][n] * this.dqin;
                    int n4 = o;
                    this.mlt[n4] = this.mlt[n4] + this.hrML[o][n] * this.hiqi[o][n];
                }
                int n5 = o++;
                this.mlt[n5] = this.mlt[n5] / this.qpt;
            }
            this.diff = (this.mlt[0] - this.mlt[1]) * this.cice - this.nstd;
            this.nstd += this.diff;
            this.nit += 1.0;
        } while (Math.abs(this.diff) > 0.001 && this.nit < 10.0);
        this.hiq = this.hiqi;
        this.qinold = this.qin;
        o = 0;
        while (o < 2) {
            int n6 = o++;
            this.mlt[n6] = this.mlt[n6] - this.tstart;
        }
        qt[] bt = this.get(glotemp.class).boxtempqt;
        bt[0].set(year, (float)((this.mlt[0] * this.cice * this.klo + this.frac[0] * (double)rf[0]) / (this.kls * this.frac[0] + this.klo)));
        bt[3].set(year, (float)((this.mlt[1] * this.cice * this.klo + this.frac[3] * (double)rf[3]) / (this.kls * this.frac[3] + this.klo)));
        bt[1].set(year, (float)(this.mlt[0] * this.cice));
        bt[2].set(year, (float)(this.mlt[1] * this.cice));
        float globavtemp = 0.0f;
        for (int i = 0; i < 4; ++i) {
            globavtemp += (float)((double)bt[i].get(year) * this.frac[i]);
        }
        return globavtemp;
    }

    float thermalexpansion() {
        float thermexp = 0.0f;
        for (int o = 0; o < 2; ++o) {
            for (int n = 0; n < 35; ++n) {
                thermexp = (float)((double)thermexp + this.hrsl[o][n] * this.hiq[o][n]);
            }
        }
        if (year == gsy) {
            this.sealevteinit = thermexp;
        }
        thermexp = (float)((double)thermexp - this.sealevteinit);
        return thermexp;
    }

    void tempupwellfb(double ut) {
        if (this.varupwell.istrue()) {
            if (ut > this.zeroupwelltemp.getval()) {
                ut = this.zeroupwelltemp.getval();
            }
            for (int o = 0; o < 2; ++o) {
                int n = 0;
                while (n < 35) {
                    this.hiquc = 0.0;
                    for (int m = 0; m < 35; ++m) {
                        this.hiquc += this.hiq[o][m] * this.upwellstep[o][n][m];
                    }
                    double[] dArray = this.hiq[o];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] - this.hiquc * ut * this.upwellreducefrac.getval();
                }
            }
        }
    }
}

