/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jcm.core.complexity;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.udebclimod;

public class sealevel
extends module {
    double[] glsens = new double[]{0.12, 0.16, 0.09, 0.1, 0.03, 0.15, 0.14, 0.3};
    double[] ansens = new double[]{-0.18, -0.37, -0.35, -0.21, -0.48, -0.31, -0.48, -0.21};
    public param greenlandsens = new param(new Object[]{"greenland_sensitivity", "", this.glsens[2], -0.5, 0.5, colfont.green, complexity.expert});
    public param antarcticasens = new param(new Object[]{"antarctica_sensitivity", "", this.ansens[2], -0.5, 0.5, colfont.cyan, complexity.expert});
    public qt thermexp = new qt("thermexp", colfont.red);
    public qt glacier = new qt("glaciers", colfont.grey);
    public qt longterm = new qt("rfia", colfont.black);
    public qt antarctica = new qt("antarctica", colfont.cyan);
    public qt greenland = new qt("greenland", colfont.green);
    public qt freshwater = new qt(new Object[]{"freshwater", colfont.dkgreen, complexity.expert});
    public qt other = new qt("Other", colfont.brown);
    public qt total = new qt(new Object[]{"totsl", colfont.dkblue, complexity.simplest, qt.Type.total});
    public qtset sealevel = new qtset(new Object[]{this.thermexp, this.glacier, this.greenland, this.antarctica, this.longterm, this.freshwater, this.other, this.total, "sealevelrise", "metres", complexity.simplest});
    float totglac = 0.5f;
    float taul = 70.0f;
    float tauh = 130.0f;
    float deltatl = 0.7f;
    float deltath = 3.0f;
    int ng = 10;
    int n;
    float eqglac;
    float[] glac = new float[this.ng];
    float[] glac99 = new float[this.ng];
    float[] tau = new float[this.ng];
    float[] deltat = new float[this.ng];

    public void seticecaptomod(int m) {
        this.greenlandsens.putval(this.glsens[m]);
        this.antarcticasens.putval(this.ansens[m]);
    }

    public void initsetup() {
        this.follows(this.get(glotemp.class));
        this.follows(this.get(udebclimod.class));
        this.greenlandsens.setaffectedby(this.get(udebclimod.class).climod);
        this.antarcticasens.setaffectedby(this.get(udebclimod.class).climod);
    }

    public void precalc() {
        this.glaciersetup();
    }

    public void calcstep() {
        if (year > gsy) {
            this.glaciermelt();
            this.polarmelt();
            this.longterm.set(year, (float)((double)this.longterm.get(year - 1) + 2.5E-4));
            this.other.set(year, (float)((double)this.other.get(year - 1) + (year < 1990 ? 5.0E-5 : 1.7E-4)));
            this.freshwater.set(year, 0.0f);
        }
        this.total.set(year, this.thermexp.get(year) + this.glacier.get(year) + this.longterm.get(year) + this.antarctica.get(year) + this.greenland.get(year) + this.freshwater.get(year) + this.other.get(year));
    }

    public void save99() {
        this.n = 0;
        while (this.n < this.ng) {
            this.glac99[this.n] = this.glac[this.n];
            ++this.n;
        }
    }

    public void startstate(int startyear) {
        this.longterm.set(gsy, 0.0f);
        this.antarctica.set(gsy, 0.0f);
        this.greenland.set(gsy, 0.0f);
        this.freshwater.set(gsy, 0.0f);
        this.glacier.set(gsy, 0.0f);
        this.other.set(gsy, 0.0f);
        if (startyear == 2000) {
            this.n = 0;
            while (this.n < this.ng) {
                this.glac[this.n] = this.glac99[this.n];
                ++this.n;
            }
        } else {
            this.n = 0;
            while (this.n < this.ng) {
                this.glac[this.n] = this.totglac / (float)this.ng;
                ++this.n;
            }
        }
    }

    void glaciersetup() {
        this.n = 0;
        while (this.n < this.ng) {
            this.tau[this.n] = this.taul + (this.tauh - this.taul) * (float)this.n / (float)(this.ng - 1);
            this.deltat[this.n] = this.deltatl + (this.deltath - this.deltatl) * (float)this.n / (float)(this.ng - 1);
            ++this.n;
        }
    }

    void glaciermelt() {
        this.glacier.set(year, this.totglac);
        this.n = 0;
        while (this.n < this.ng) {
            this.eqglac = this.totglac / (float)this.ng * (1.0f - this.get(glotemp.class).avchange.get(year) / this.deltat[this.n]);
            if (this.eqglac < 0.0f) {
                this.eqglac = 0.0f;
            }
            int n = this.n;
            this.glac[n] = (float)((double)this.glac[n] - 0.3 * (double)(this.glac[this.n] - this.eqglac) / (double)this.tau[this.n]);
            this.glacier.set(year, this.glacier.get(year) - this.glac[this.n]);
            ++this.n;
        }
    }

    void polarmelt() {
        double glsensfac = 1.0 + ((double)this.get(glotemp.class).avchange.get(year) - 1.5) * 0.3;
        double ansensfac = (double)this.get(glotemp.class).avchange.get(year) * 0.05;
        this.antarctica.set(year, (float)((double)this.antarctica.get(year - 1) + ((year > 2100 ? ansensfac : 0.0) + this.antarcticasens.getval()) * (double)this.get(glotemp.class).avchange.get(year) * 0.001));
        this.greenland.set(year, (float)((double)this.greenland.get(year - 1) + (year > 2100 ? glsensfac : 1.0) * this.greenlandsens.getval() * (double)this.get(glotemp.class).avchange.get(year) * 0.001));
    }
}

