/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jcm.core.complexity;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.udebclimod;
import jcm.mod.ogas.AviationForcing;
import jcm.mod.ogas.aerosol;
import jcm.mod.ogas.atchem;
import jcm.mod.ogas.fgas;
import jcm.mod.ogas.gas;

public class radfor
extends module {
    carboncycle carboncycle;
    atchem atchem;
    fgas fgas;
    aerosol aerosol;
    AviationForcing aviaf;
    public param unifdist = new param(new Object[]{"unif", false, complexity.expert}){

        public void precalc() {
            radfor.this.distribute();
        }
    };
    public param only4gas = new param(new Object[]{"4gas", false, complexity.experimental});
    public param excavia = new param(new Object[]{"exclude aviation non-co2", false, complexity.expert});
    public param applyefficacy = new param(new Object[]{"include efficacy factor", false, complexity.expert});
    public qt totalrf = new qt(new Object[]{"totrf", colfont.red, complexity.simplest, qt.Type.total});
    public qt ghgrf = new qt(new Object[]{"allghg", colfont.greygreen, complexity.simplest, qt.Type.total});
    public qt anthrorf = new qt(new Object[]{"allghgaero", colfont.dkred, complexity.expert, qt.Type.total});
    public qt nlrf = new qt(new Object[]{"rfnl", colfont.red, complexity.expert});
    public qt norf = new qt(new Object[]{"rfno", colfont.blue, complexity.expert});
    public qt sorf = new qt(new Object[]{"rfso", colfont.cyan, complexity.expert});
    public qt slrf = new qt(new Object[]{"rfsl", colfont.orange, complexity.expert});
    public qt co2eqghg = new qt(new Object[]{"co2eq&allghg", colfont.purple, complexity.expert});
    public qt co2eqghgaero = new qt(new Object[]{"co2eq&allghgaero", colfont.pink, complexity.expert});
    public qt co2eqkyoto = new qt(new Object[]{"co2eq&6gas", colfont.magenta, complexity.expert});
    public qtset concequiv = new qtset(new Object[]{this.co2eqkyoto, this.co2eqghg, this.co2eqghgaero, "co2equivconc", "ppm", complexity.expert});
    public qtset allrf = new qtset(this.totalrf, this.anthrorf, this.ghgrf, "allrf", "w&per&m2");
    public qtset allrf2 = new qtset(new Object[]{this.totalrf, "allrfdetail", "w&per&m2", complexity.normal});
    public qtset regrf = new qtset(new Object[]{this.totalrf, this.nlrf, this.norf, this.sorf, this.slrf, "regrf", "w&per&m2", complexity.expert});
    public qt[] splitrf = new qt[]{this.nlrf, this.norf, this.sorf, this.slrf};
    double[] frac;
    double[] splitnls = new double[4];
    double[] splitnlw = new double[4];
    double[] splitl = new double[4];
    double[] splitsl = new double[4];
    double[] splits = new double[4];

    public void initsetup() {
        super.initsetup();
        this.carboncycle = this.get(carboncycle.class);
        this.atchem = this.get(atchem.class);
        this.aerosol = this.get(aerosol.class);
        this.fgas = this.get(fgas.class);
        this.aviaf = this.get(AviationForcing.class);
        this.follows(this.carboncycle);
        this.follows(this.atchem);
        this.follows(this.aerosol);
        this.follows(this.fgas);
        this.follows(this.aviaf);
        this.concequiv.add(this.carboncycle.co2atppm);
        this.allrf.add(this.carboncycle.co2rf, this.atchem.othgasrf, this.fgas.fgasrf, this.aerosol.aerorf, this.aerosol.natvrf, this.aviaf.rfnonco2);
        this.allrf2.add(this.carboncycle.co2rf, this.atchem.ch4rf, this.atchem.n2orf, this.atchem.tropo3rf, this.atchem.strath2orf, this.fgas.cfcrf, this.fgas.hfcrf, this.fgas.strato3rf, this.aerosol.sulfdirrf, this.aerosol.sulfindrf, this.aerosol.bcrf, this.aerosol.ocrf, this.aerosol.solarrf, this.aerosol.volcanorf, this.aviaf.rfnonco2);
    }

    public float getefficacy(gas g) {
        return this.applyefficacy.istrue() ? g.efficacy : 1.0f;
    }

    public void calcstep() {
        this.calctotals();
        this.calcsplit();
        this.calcequiv();
    }

    void distribute() {
        if (this.unifdist.istrue()) {
            for (int i = 0; i < 4; ++i) {
                this.splitnls[i] = 1.0;
                this.splitnlw[i] = 1.0;
                this.splitl[i] = 1.0;
                this.splitsl[i] = 1.0;
                this.splits[i] = 1.0;
            }
        } else {
            this.frac = this.get(udebclimod.class).frac;
            this.splitnls[0] = 0.6000000000000001 / (0.75 * this.frac[0] + 0.25 * this.frac[1]);
            this.splitnls[1] = this.splitnls[0] / 3.0;
            this.splitnls[3] = 0.15000000000000002 / (0.75 * this.frac[3] + 0.25 * this.frac[2]);
            this.splitnls[2] = this.splitnls[3] / 3.0;
            this.splitnlw[0] = 0.44448888999999997 / (0.6667 * this.frac[0] + 0.3333 * this.frac[1]);
            this.splitnlw[1] = this.splitnlw[0] / 2.0;
            this.splitnlw[3] = 0.22221111 / (0.6667 * this.frac[3] + 0.3333 * this.frac[2]);
            this.splitnlw[2] = this.splitnlw[3] / 2.0;
            this.splitl[0] = 0.6667 / this.frac[0];
            this.splitl[1] = 0.0;
            this.splitl[3] = 0.3333 / this.frac[3];
            this.splitl[2] = 0.0;
            this.splitsl[0] = 0.249975 / (0.75 * this.frac[0] + 0.25 * this.frac[1]);
            this.splitsl[1] = this.splitsl[0] / 3.0;
            this.splitsl[3] = 0.5000249999999999 / (0.75 * this.frac[3] + 0.25 * this.frac[2]);
            this.splitsl[2] = this.splitnls[3] / 3.0;
            this.splits[0] = 0.5;
            this.splits[1] = 0.5;
            this.splits[2] = 1.5;
            this.splits[3] = 1.5;
        }
    }

    void calcsplit() {
        for (int i = 0; i < 4; ++i) {
            this.splitrf[i].set(year, (float)((double)(this.carboncycle.co2rf.get(year) + this.atchem.ch4rf.get(year) + this.atchem.strath2orf.get(year) + this.atchem.n2orf.get(year) + this.fgas.cfcrf.get(year) + this.fgas.hfcrf.get(year) + this.aerosol.natvrf.get(year)) + (double)(this.aerosol.sulfdirrf.get(year) + this.aerosol.bcrf.get(year) + this.aerosol.ocrf.get(year) + this.aviaf.rfnonco2.get(year)) * this.splitnls[i] + (double)(this.aerosol.sulfindrf.get(year) + this.atchem.tropo3rf.get(year)) * this.splitnlw[i] + (double)this.fgas.strato3rf.get(year) * this.splits[i]));
        }
    }

    void calctotals() {
        if (this.get(radfor.class).only4gas.istrue()) {
            this.ghgrf.set(year, this.carboncycle.co2rf.get(year) + this.atchem.ch4rf.get(year) + this.atchem.n2orf.get(year));
            this.anthrorf.set(year, this.ghgrf.get(year) + this.aerosol.sulfdirrf.get(year) + this.aerosol.sulfindrf.get(year));
            this.totalrf.set(year, this.anthrorf.get(year));
        } else {
            this.ghgrf.set(year, this.carboncycle.co2rf.get(year) + this.atchem.othgasrf.get(year) + this.fgas.fgasrf.get(year));
            this.anthrorf.set(year, this.ghgrf.get(year) + this.aerosol.aerorf.get(year) + this.aviaf.rfnonco2.get(year));
            this.totalrf.set(year, this.anthrorf.get(year) + this.aerosol.natvrf.get(year));
        }
    }

    public void calcequiv() {
        double fac = Math.log(2.0) / this.get(udebclimod.class).rfco2double.getval();
        this.co2eqkyoto.set(year, (float)(278.0 * Math.exp((double)(this.fgas.hfcrf.get(year) + this.atchem.ch4rf.get(year) + this.atchem.n2orf.get(year) + this.carboncycle.co2rf.get(year)) * fac)));
        this.co2eqghg.set(year, (float)(278.0 * Math.exp((double)(this.atchem.othgasrf.get(year) + this.fgas.fgasrf.get(year) + this.carboncycle.co2rf.get(year)) * fac)));
        this.co2eqghgaero.set(year, (float)(278.0 * Math.exp((double)(this.atchem.othgasrf.get(year) + this.fgas.fgasrf.get(year) + this.carboncycle.co2rf.get(year) + this.aerosol.aerorf.get(year)) * fac)));
    }
}

