/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jcm.core.complexity;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;
import jcm.mod.cli.udebclimod;

public class glotemp
extends module {
    public static param baseyear = new param("baseyear", "", 1850, 1760, 1997, colfont.blue);
    boolean initialhistdata = true;
    public qt avchange = new qt(new Object[]{"tempavfrom1750", colfont.brown, complexity.experimental});
    public static qt proxytemp = new qt("tempproxy", colfont.greygreen, 1750, 1991);
    public static qt tempdata = new qt(new Object[]{"tempdata", colfont.dkgreen, 1750, 2002, complexity.simplest});
    public static qt temptrend = new qt("temptrend", colfont.green, 1750, 1999);
    public qt avchangeby = new qt(new Object[]{"tempav", colfont.brown, complexity.simplest});
    public qt tempnl = new qt(new Object[]{"tempnl", colfont.red, complexity.expert});
    public qt tempno = new qt(new Object[]{"tempno", colfont.blue, complexity.expert});
    public qt tempso = new qt(new Object[]{"tempso", colfont.cyan, complexity.expert});
    public qt tempsl = new qt(new Object[]{"tempsl", colfont.orange, complexity.expert});
    public qtset temp = new qtset(new Object[]{this.avchange, this.avchangeby, tempdata, proxytemp, temptrend, "glotempcurves", "degcbase", complexity.simplest});
    public qtset boxtemp = new qtset(this.tempnl, this.tempno, this.tempsl, this.tempso, "Box Temperature", "degcbase");
    public double error = 0.0;
    public double offset = 0.0;
    public double oldoffset = 1.0;
    float[] boxoffset = new float[4];
    qt[] boxtempqt = new qt[]{this.tempnl, this.tempno, this.tempso, this.tempsl};
    public boolean usehisttempdata = false;

    public void setinteractions() {
        this.follows(this.get(radfor.class));
        this.setaffectedby(this.get(udebclimod.class));
    }

    public void initsetup() {
        int y;
        for (y = 1750; y < 1860; ++y) {
            tempdata.set(y, 0.0f);
        }
        for (y = 1860; y < 2003; ++y) {
            tempdata.set(y, tempdata.get(y) - 0.42f);
        }
        for (y = 1750; y < 1992; ++y) {
            proxytemp.set(y, proxytemp.get(y) + 0.04f);
        }
        this.temp.associate(baseyear);
        this.boxtemp.associate(baseyear);
    }

    public void startstate(int startyear) {
        this.get(udebclimod.class).startstate(startyear);
    }

    public void save99() {
        this.get(udebclimod.class).save99();
    }

    public void calcstep() {
        udebclimod udeb = this.get(udebclimod.class);
        radfor rf = this.get(radfor.class);
        if (year > gsy) {
            udeb.tempupwellfb(this.avchange.get(year));
        }
        this.avchange.set(year, udeb.adjust(new float[]{rf.splitrf[0].get(year), rf.splitrf[1].get(year), rf.splitrf[2].get(year), rf.splitrf[3].get(year)}));
        if (year == (int)baseyear.getval() + 2) {
            this.calcoffset();
        }
        this.get(sealevel.class).thermexp.set(year, udeb.thermalexpansion());
    }

    public void postcalc() {
        this.applyoffset();
        this.calcerror();
        if (this.initialhistdata || glotemp.baseyear.changed) {
            this.histtemptrend();
        }
    }

    public void calcerror() {
        float sumdiff = 0.0f;
        float sumdata = 0.0f;
        float sumcalc = 0.0f;
        float n = 0.0f;
        for (int y = gsy; y < 2002; ++y) {
            float e;
            float mt;
            float ct = this.avchangeby.get(y);
            if (y < 1860) {
                mt = proxytemp.get(y);
                e = 0.5f;
            } else {
                mt = tempdata.get(y);
                e = 0.05f + 0.0015f * (float)(y < 1950 ? 1950 - y : 0);
            }
            sumdiff += (ct - mt) * (ct - mt) / e;
            sumcalc += ct / e;
            sumdata += mt / e;
            n += 1.0f / e;
        }
        this.error = Math.pow(sumdiff / n - (sumcalc / n - sumdata / n) * (sumcalc / n - sumdata / n), 0.5);
    }

    public void calcoffset() {
        this.oldoffset = this.offset;
        this.offset = 0.0;
        for (int b = 0; b < 4; ++b) {
            this.boxoffset[b] = 0.0f;
        }
        for (int i = 0; i < 5; ++i) {
            int dy = (int)baseyear.getval() + i - 2;
            if (dy < gsy) {
                dy = gsy;
            }
            this.offset += (double)((float)((double)this.avchange.get(dy) / 5.0));
            for (int b = 0; b < 4; ++b) {
                int n = b;
                this.boxoffset[n] = this.boxoffset[n] + (float)((double)this.boxtempqt[b].get(dy) / 5.0);
            }
        }
    }

    void applyoffset() {
        for (int y = 0; y <= gey; ++y) {
            for (int b = 0; b < 4; ++b) {
                this.boxtempqt[b].set(y, this.boxtempqt[b].get(y) - this.boxoffset[b]);
            }
            this.avchangeby.set(y, (float)((double)this.avchange.get(y) - this.offset));
        }
    }

    void histtemptrend() {
        int y;
        int y2;
        temptrend.set(gsy, 0.0f);
        for (y2 = gsy; y2 <= gsy + 6; ++y2) {
            temptrend.set(y2, temptrend.get(y2) + proxytemp.get(y2) / 7.0f);
        }
        for (y2 = gsy + 7; y2 <= 1860; ++y2) {
            temptrend.set(y2 - 3, temptrend.get(y2 - 4) + (proxytemp.get(y2) - proxytemp.get(y2 - 7)) / 7.0f);
        }
        for (y2 = 1860; y2 <= 1867; ++y2) {
            temptrend.set(y2 - 3, temptrend.get(y2 - 4) + (tempdata.get(y2) - proxytemp.get(y2 - 7)) / 7.0f);
        }
        for (y2 = 1868; y2 <= 2002; ++y2) {
            temptrend.set(y2 - 3, temptrend.get(y2 - 4) + (tempdata.get(y2) - tempdata.get(y2 - 7)) / 7.0f);
        }
        float htoffset = 0.0f;
        for (int i = 0; i < 5; ++i) {
            int dy = (int)baseyear.getval() + i - 2;
            if (dy < gsy) {
                dy = gsy;
            }
            if (dy > 2002) {
                dy = 2002;
            }
            htoffset += (float)((double)(baseyear.getval() > 1862.0 ? tempdata.get(dy) : proxytemp.get(dy)) / 5.0);
        }
        float byoffset = temptrend.get((int)baseyear.getval());
        for (y = gsy; y <= 1991; ++y) {
            proxytemp.set(y, proxytemp.get(y) - htoffset);
        }
        for (y = gsy; y <= 2002; ++y) {
            tempdata.set(y, tempdata.get(y) - htoffset);
        }
        for (y = gsy; y <= 1999; ++y) {
            temptrend.set(y, temptrend.get(y) - byoffset);
        }
        for (y = gsy; y < gsy + 3; ++y) {
            temptrend.set(y, -999.0f);
        }
        for (y = gsy; y < 1860; ++y) {
            tempdata.set(y, -999.0f);
        }
        this.initialhistdata = false;
    }

    public double getoceantemprise() {
        return this.gettemprise(1);
    }

    public double getlandtemprise() {
        return this.gettemprise(0);
    }

    double gettemprise(int b) {
        if (this.usehisttempdata && year < 2002) {
            float nfac = 0.0f;
            for (int s = 1848; s < 1853; ++s) {
                nfac += proxytemp.get(s) / 5.0f;
            }
            float temprise = (year < 1860 ? proxytemp.get(year) : tempdata.get(year)) - nfac;
            return (double)temprise * (b == 0 ? 1.356 : 0.847);
        }
        return year > 1750 ? (double)(this.boxtempqt[b].get(year - 1) + this.boxtempqt[3 - b].get(year - 1) + (loop.calcfutureonly && year <= 2000 || !this.changed ? this.boxoffset[b] + this.boxoffset[3 - b] : 0.0f)) / 2.0 : 0.0;
    }
}

