/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.carbon;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jcm.core.complexity;
import jcm.core.module;
import jcm.core.param;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carbonatechemistry;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;

public class berncarbon
extends module {
    public param diffufac = new param("ceddydiff", "", colfont.blue, 1, 0, 2);
    public param sidemix = new param(new Object[]{"csidemix", "", colfont.yellow, 1.858736059479554, 0, 5, complexity.expert});
    public param upwell = new param(new Object[]{"cupwell", "m&per&yr", colfont.red, 0.44, 0, 1, complexity.expert});
    public param hlmix = new param(new Object[]{"chighlat", "m&per&yr", colfont.cyan, 38, 0, 70, complexity.expert});
    public param beta = new param("fertbeta", "", colfont.green, 0.287, 0, 0.6);
    public param fbchfut = new param(new Object[]{"fertn change only in future", false, complexity.experimental});
    public param respq10 = new param("resp_q10", "", colfont.brown, 1.2, 0.5, 2.5);
    static final double ocdepth = 3725.0;
    static final double ocarea = 3.616E14;
    static final double dml = 75.0;
    static final double hfrac = 0.16;
    static final double lhf = 5.25;
    int steps = 1;
    double dt = 1.0 / (double)this.steps;
    public static final int ncl = 34;
    public static final int ncb = 43;
    double[] dl = new double[34];
    double[] diffu = new double[34];
    Matrix MV;
    public double[] cpropf = this.cbox();
    public double[] ciq = this.cbox();
    public double[] ciqi = this.cbox();
    public double[] ciq99 = this.cbox();
    public double[] crBIO = this.cbox();
    public double[] crOC = this.cbox();
    public double[] crAT = this.cbox();
    public double[] crLS = this.cbox();
    public double[] crHS = this.cbox();
    public double[] scicAT = this.cbox();
    public double[] scicLS = this.cbox();
    public double[] scicHS = this.cbox();
    public double[] scicNP = this.cbox();
    public double[] rcicAT = this.cbox();
    public double[] rcicLS = this.cbox();
    public double[] rcicHS = this.cbox();
    public double[] rcicNP = this.cbox();
    public double[] crSO = this.cbox();
    public double[] scicSO = this.cbox();
    public double[] rcicSO = this.cbox();
    public double[] crHU = this.cbox();
    public double[] scicHU = this.cbox();
    public double[] rcicHU = this.cbox();
    public double totemit;
    public double oldtotemit;
    public double oldatinc;
    public double atinc;
    public double oldlsinc;
    public double lsinc;
    public double oldhsinc;
    public double hsinc;
    public double oldnpinc;
    public double npinc;
    public double at;
    public double ls;
    public double hs;
    public double oldls;
    public double oldhs;
    public double tb;
    public double oldtb;
    public double oc;
    public double oldoc;
    public double dat;
    public double dls;
    public double dhs;
    public double dnp;
    double atinc99;
    double lsinc99;
    double hsinc99;
    double npinc99;
    double totemit99;
    double dls99;
    double dhs99;
    double dnp99;
    double atppmy = 278.0;
    double guess;
    double nit;
    double ncit;
    double oldnit = 1.0;
    double ciqr;
    double diff;
    double wit;
    double check;
    String err = "";
    public double soinc;
    public double huinc;
    public double oldsoinc;
    public double soinc99;
    public double huinc99;
    public double oldhuinc;
    public double so;
    public double hu;
    public double oldso;
    public double oldhu;
    public double dso;
    public double dhu;
    public double dso99;
    public double dhu99;
    double nplin;
    double betab;

    public void setinteractions() {
        this.setaffectedby(carbonatechemistry.class);
        this.setaffectedby(glotemp.class, this.respq10.getval() != 1.0);
    }

    public void precalc() {
        this.setupfluxes();
    }

    double[] cbox() {
        return new double[43];
    }

    void setupfluxes() {
        double rh;
        double rv;
        double d = 60000.0 * this.beta.getval();
        this.get(carboncycle.class);
        double d2 = d * 4.71E-4;
        this.get(carboncycle.class);
        this.nplin = d2 / 278.0;
        double dtot = 0.0;
        double ocu = this.upwell.getval();
        double ocw = this.hlmix.getval();
        double srate = this.sidemix.getval() / 1000.0;
        for (int n = 0; n < 34; ++n) {
            double d3 = this.dl[n] = n < 20 ? 49.0 : 196.0;
            if (n > 0) {
                dtot += this.dl[n];
            }
            this.diffu[n] = this.diffufac.getval() * (465.0 + 7096.0 * Math.exp(-dtot / 253.0));
        }
        double[][] rate = new double[43][43];
        for (int i = 0; i < 43; ++i) {
            for (int j = 0; j < 43; ++j) {
                rate[i][j] = 0.0;
            }
        }
        int n = 1;
        while (n < 34) {
            double rvu = (2.0 * this.diffu[n] - ocu * this.dl[n]) / (this.dl[n - 1] * (this.dl[n - 1] + this.dl[n]));
            rv = (2.0 * this.diffu[n] + ocu * this.dl[n - 1]) / (this.dl[n] * (this.dl[n - 1] + this.dl[n]));
            rh = srate * 5.25 * this.dl[n] / 3725.0;
            double[] dArray = rate[n];
            int n2 = n - 1;
            dArray[n2] = dArray[n2] + rvu;
            double[] dArray2 = rate[n - 1];
            int n3 = n - 1;
            dArray2[n3] = dArray2[n3] - rvu;
            double[] dArray3 = rate[n - 1];
            int n4 = n;
            dArray3[n4] = dArray3[n4] + rv;
            double[] dArray4 = rate[n];
            int n5 = n;
            dArray4[n5] = dArray4[n5] - rv;
            double[] dArray5 = rate[n];
            dArray5[36] = dArray5[36] + rh;
            double[] dArray6 = rate[36];
            dArray6[36] = dArray6[36] - rh;
            double[] dArray7 = rate[36];
            int n6 = n;
            dArray7[n6] = dArray7[n6] + srate;
            double[] dArray8 = rate[n];
            int n7 = n++;
            dArray8[n7] = dArray8[n7] - srate;
        }
        double rvu = 8.0 * this.diffu[0] / (3.0 * this.dl[0] * 75.0) - ocu / 75.0;
        rv = 3.0 * this.diffu[0] / (this.dl[0] * this.dl[0]);
        double rjff = this.diffu[0] / (3.0 * this.dl[0] * this.dl[0]);
        double[] dArray = rate[0];
        dArray[34] = dArray[34] + rvu;
        double[] dArray9 = rate[34];
        dArray9[34] = dArray9[34] - rvu;
        double[] dArray10 = rate[34];
        dArray10[0] = dArray10[0] + rv;
        double[] dArray11 = rate[0];
        dArray11[0] = dArray11[0] - rv;
        double[] dArray12 = rate[0];
        dArray12[1] = dArray12[1] + rjff;
        double[] dArray13 = rate[34];
        dArray13[1] = dArray13[1] - rjff;
        rh = srate * 5.25 * this.dl[0] / 3725.0;
        double[] dArray14 = rate[0];
        dArray14[36] = dArray14[36] + rh;
        double[] dArray15 = rate[36];
        dArray15[36] = dArray15[36] - rh;
        double[] dArray16 = rate[36];
        dArray16[0] = dArray16[0] + srate;
        double[] dArray17 = rate[0];
        dArray17[0] = dArray17[0] - srate;
        double[] dArray18 = rate[34];
        dArray18[35] = dArray18[35] + srate * 5.25 * 75.0 / 3725.0;
        double[] dArray19 = rate[35];
        dArray19[35] = dArray19[35] - srate * 5.25 * 75.0 / 3725.0;
        double[] dArray20 = rate[35];
        dArray20[34] = dArray20[34] + (srate + ocu / 75.0);
        double[] dArray21 = rate[34];
        dArray21[34] = dArray21[34] - (srate + ocu / 75.0);
        double[] dArray22 = rate[33];
        dArray22[36] = dArray22[36] + ocu * 5.25 / 3725.0;
        double[] dArray23 = rate[36];
        dArray23[36] = dArray23[36] - ocu * 5.25 / 3725.0;
        double[] dArray24 = rate[35];
        dArray24[36] = dArray24[36] + ocw / 3725.0;
        double[] dArray25 = rate[36];
        dArray25[36] = dArray25[36] - ocw / 3725.0;
        double[] dArray26 = rate[36];
        dArray26[35] = dArray26[35] + (ocw + ocu / 5.25) / 75.0;
        double[] dArray27 = rate[35];
        dArray27[35] = dArray27[35] - (ocw + ocu / 5.25) / 75.0;
        this.get(carbonatechemistry.class).setupchemistry();
        double[] saflin = this.get(carbonatechemistry.class).saflin;
        double[] alpha = this.get(carbonatechemistry.class).alpha;
        double[] dArray28 = rate[37];
        dArray28[34] = dArray28[34] + saflin[0];
        double[] dArray29 = rate[34];
        dArray29[34] = dArray29[34] - saflin[0];
        double[] dArray30 = rate[37];
        dArray30[35] = dArray30[35] + saflin[1];
        double[] dArray31 = rate[35];
        dArray31[35] = dArray31[35] - saflin[1];
        double[] dArray32 = rate[34];
        dArray32[37] = dArray32[37] + alpha[0];
        double[] dArray33 = rate[37];
        dArray33[37] = dArray33[37] - alpha[0];
        double[] dArray34 = rate[35];
        dArray34[37] = dArray34[37] + alpha[1];
        double[] dArray35 = rate[37];
        dArray35[37] = dArray35[37] - alpha[1];
        double[] dArray36 = rate[41];
        dArray36[39] = dArray36[39] + 0.01;
        double[] dArray37 = rate[39];
        dArray37[39] = dArray37[39] - 0.01;
        double[] dArray38 = rate[41];
        dArray38[40] = dArray38[40] + 0.08333;
        double[] dArray39 = rate[40];
        dArray39[40] = dArray39[40] - 0.08333;
        double[] dArray40 = rate[40];
        dArray40[39] = dArray40[39] + 0.04;
        double[] dArray41 = rate[39];
        dArray41[39] = dArray41[39] - 0.04;
        double[] dArray42 = rate[40];
        dArray42[38] = dArray42[38] + 0.35;
        double[] dArray43 = rate[38];
        dArray43[38] = dArray43[38] - 0.35;
        double[] dArray44 = rate[39];
        dArray44[42] = dArray44[42] + 0.41667;
        double[] dArray45 = rate[42];
        dArray45[42] = dArray45[42] - 0.41667;
        double[] dArray46 = rate[38];
        dArray46[42] = dArray46[42] + 0.58333;
        double[] dArray47 = rate[42];
        dArray47[42] = dArray47[42] - 0.58333;
        double[] dArray48 = rate[37];
        dArray48[40] = dArray48[40] + 0.375;
        double[] dArray49 = rate[40];
        dArray49[40] = dArray49[40] - 0.375;
        double[] dArray50 = rate[37];
        dArray50[41] = dArray50[41] + 0.01;
        double[] dArray51 = rate[41];
        dArray51[41] = dArray51[41] - 0.01;
        double[] dArray52 = rate[42];
        dArray52[37] = dArray52[37] + this.nplin;
        double[] dArray53 = rate[37];
        dArray53[37] = dArray53[37] - this.nplin;
        double[] cicAT = this.cbox();
        double[] cicLS = this.cbox();
        double[] cicHS = this.cbox();
        double[] cicNP = this.cbox();
        double[] cicSO = this.cbox();
        double[] cicHU = this.cbox();
        EigenvalueDecomposition ED = new EigenvalueDecomposition(new Matrix(rate, 43, 43));
        this.MV = ED.getV();
        Matrix MVI = this.MV.inverse().transpose();
        this.crLS = this.MV.getArray()[34];
        this.crHS = this.MV.getArray()[35];
        this.crAT = this.MV.getArray()[37];
        this.crSO = this.MV.getArray()[40];
        this.crHU = this.MV.getArray()[41];
        this.crBIO = new double[43];
        this.crOC = new double[43];
        for (int n8 = 0; n8 < 43; ++n8) {
            int i;
            this.crBIO[n8] = 0.0;
            for (i = 0; i < 5; ++i) {
                int n9 = n8;
                this.crBIO[n9] = this.crBIO[n9] + this.MV.getArray()[38 + i][n8];
            }
            this.crOC[n8] = 0.0;
            for (i = 0; i < 37; ++i) {
                int n10 = n8;
                this.crOC[n10] = this.crOC[n10] + this.MV.getArray()[i][n8];
            }
        }
        cicLS = MVI.getArray()[34];
        cicHS = MVI.getArray()[35];
        cicAT = MVI.getArray()[37];
        cicNP = MVI.getArray()[42];
        cicSO = MVI.getArray()[40];
        cicHU = MVI.getArray()[41];
        double[] Eig = ED.getRealEigenvalues();
        for (int n11 = 0; n11 < 43; ++n11) {
            double rampf;
            double stepf;
            this.cpropf[n11] = Math.exp(Eig[n11] * this.dt);
            if (Math.abs(Eig[n11]) < 1.0E-6) {
                stepf = this.dt;
                rampf = this.dt / 2.0;
            } else {
                stepf = (this.cpropf[n11] - 1.0) / Eig[n11];
                rampf = (stepf - this.dt) / (Eig[n11] * this.dt);
            }
            String dummy = "ok here " + n11;
            this.scicLS[n11] = stepf * cicLS[n11];
            this.scicHS[n11] = stepf * cicHS[n11];
            this.scicAT[n11] = stepf * cicAT[n11];
            this.scicNP[n11] = stepf * cicNP[n11];
            this.rcicLS[n11] = rampf * cicLS[n11];
            this.rcicHS[n11] = rampf * cicHS[n11];
            this.rcicAT[n11] = rampf * cicAT[n11];
            this.rcicNP[n11] = rampf * cicNP[n11];
            this.scicSO[n11] = stepf * cicSO[n11];
            this.scicHU[n11] = stepf * cicHU[n11];
            this.rcicSO[n11] = rampf * cicSO[n11];
            this.rcicHU[n11] = rampf * cicHU[n11];
        }
        ED = null;
        MVI = null;
        Eig = null;
        rate = null;
    }

    public void startstate(int startyear) {
        int n;
        this.at = 0.0;
        this.ls = 0.0;
        this.hs = 0.0;
        this.oldls = 0.0;
        this.oldhs = 0.0;
        this.oc = 0.0;
        this.tb = 0.0;
        this.so = 0.0;
        this.hu = 0.0;
        if (startyear == 1750) {
            for (n = 0; n < 43; ++n) {
                this.ciq[n] = 0.0;
            }
            this.atinc = 0.0;
            this.lsinc = 0.0;
            this.hsinc = 0.0;
            this.npinc = 0.0;
            this.oldtotemit = 0.0;
            this.dls = 0.0;
            this.dhs = 0.0;
            this.dnp = 0.0;
            this.soinc = 0.0;
            this.huinc = 0.0;
            this.dso = 0.0;
            this.dhu = 0.0;
        } else {
            for (n = 0; n < 43; ++n) {
                this.ciq[n] = this.ciq99[n];
            }
            this.atinc = this.atinc99;
            this.lsinc = this.lsinc99;
            this.hsinc = this.hsinc99;
            this.npinc = this.npinc99;
            this.oldtotemit = this.totemit99;
            this.dls = this.dls99;
            this.dhs = this.dhs99;
            this.dnp = this.dnp99;
            this.soinc = this.soinc99;
            this.huinc = this.huinc99;
            this.dso = this.dso99;
            this.dhu = this.dhu99;
        }
        this.oldatinc = this.atinc;
        this.oldlsinc = this.lsinc;
        this.oldhsinc = this.hsinc;
        this.oldnpinc = this.npinc;
        this.oldsoinc = this.soinc;
        this.oldhuinc = this.huinc;
        for (n = 0; n < 43; ++n) {
            this.ciqi[n] = this.ciq[n];
        }
        this.tb = 0.0;
        this.oc = 0.0;
        for (n = 0; n < 43; ++n) {
            this.tb += this.ciq[n] * this.crBIO[n];
            this.oc += this.ciq[n] * this.crOC[n];
        }
    }

    float[] addemit(float totemit) {
        this.totemit = totemit;
        this.get(carbonatechemistry.class).temperaturefeedback();
        double soilresptempfbfac = 1.0 - Math.pow(this.respq10.getval(), this.get(glotemp.class).getlandtemprise() / 10.0);
        for (int step = 0; step < this.steps; ++step) {
            int n;
            for (n = 0; n < 43; ++n) {
                this.ciq[n] = this.cpropf[n] * this.ciq[n] + this.scicAT[n] * this.atinc + this.scicLS[n] * this.lsinc + this.scicHS[n] * this.hsinc + this.scicNP[n] * this.npinc + this.scicSO[n] * this.soinc + this.scicHU[n] * this.huinc;
            }
            this.oldls = this.ls;
            this.oldhs = this.hs;
            this.oldso = this.so;
            this.oldhu = this.hu;
            this.nit = 0.0;
            do {
                this.dat = (double)totemit - this.oldtotemit - (this.dls + this.dhs + this.dnp + this.dso + this.dhu);
                this.wit = this.nit == 0.0 ? 1.0 : 0.3;
                this.at = 0.0;
                this.ls = 0.0;
                this.hs = 0.0;
                this.so = 0.0;
                this.hu = 0.0;
                for (n = 0; n < 43; ++n) {
                    this.ciqr = this.rcicAT[n] * this.dat + this.rcicLS[n] * this.dls + this.rcicHS[n] * this.dhs + this.rcicNP[n] * this.dnp + this.rcicSO[n] * this.dso + this.rcicHU[n] * this.dhu;
                    this.ciqi[n] = this.wit * (this.ciq[n] + this.ciqr) + (1.0 - this.wit) * this.ciqi[n];
                    this.at += this.crAT[n] * this.ciqi[n];
                    this.ls += this.crLS[n] * this.ciqi[n];
                    this.hs += this.crHS[n] * this.ciqi[n];
                    this.so += this.crSO[n] * this.ciqi[n];
                    this.hu += this.crHU[n] * this.ciqi[n];
                }
                this.lsinc = -this.get(carbonatechemistry.class).safnonlin(this.ls, 0);
                this.hsinc = -this.get(carbonatechemistry.class).safnonlin(this.hs, 1);
                this.betab = this.fbchfut.istrue() && year < 2000 ? this.beta.getdef() : this.beta.getval();
                this.get(carboncycle.class);
                this.get(carboncycle.class);
                this.npinc = 60000.0 * this.betab * Math.log(this.at * 4.71E-4 / 278.0 + 1.0) - this.at * this.nplin;
                this.soinc = (this.so * 0.375 + 45000.0) * soilresptempfbfac;
                this.huinc = (this.hu * 0.01 + 15000.0) * soilresptempfbfac;
                this.atinc = (double)totemit - (this.lsinc + this.hsinc + this.npinc + this.soinc + this.huinc);
                this.guess = this.dls + this.dhs + this.dnp + this.dso + this.dhu;
                this.dls = this.lsinc - this.oldlsinc;
                this.dhs = this.hsinc - this.oldhsinc;
                this.dnp = this.npinc - this.oldnpinc;
                this.dso = this.soinc - this.oldsoinc;
                this.dhu = this.huinc - this.oldhuinc;
                this.check = this.dls + this.dhs + this.dnp + this.dso + this.dhu;
                this.nit += 1.0;
            } while (Math.abs(this.guess - this.check) > 10.0 && this.nit < 10.0);
            for (n = 0; n < 43; ++n) {
                this.ciq[n] = this.ciqi[n];
            }
            this.oldatinc = this.atinc;
            this.oldlsinc = this.lsinc;
            this.oldhsinc = this.hsinc;
            this.oldnpinc = this.npinc;
            this.oldsoinc = this.soinc;
            this.oldhuinc = this.huinc;
            this.oldtotemit = totemit;
        }
        this.oldtb = this.tb;
        this.tb = 0.0;
        this.oldoc = this.oc;
        this.oc = 0.0;
        for (int n = 0; n < 43; ++n) {
            this.tb += this.ciq[n] * this.crBIO[n];
            this.oc += this.ciq[n] * this.crOC[n];
        }
        this.get(carboncycle.class);
        this.get(carboncycle.class);
        this.atppmy = 278.0 + 4.71E-4 * this.at;
        return new float[]{(float)this.atppmy, (float)(this.tb - this.oldtb), (float)(this.oc - this.oldoc)};
    }

    public void save99() {
        this.atinc99 = this.atinc;
        this.lsinc99 = this.lsinc;
        this.hsinc99 = this.hsinc;
        this.npinc99 = this.npinc;
        this.soinc99 = this.soinc;
        this.huinc99 = this.huinc;
        this.dso99 = this.dso;
        this.dhu99 = this.dhu;
        this.totemit99 = this.totemit;
        this.dls99 = this.dls;
        this.dhs99 = this.dhs;
        this.dnp99 = this.dnp;
        for (int n = 0; n < 43; ++n) {
            this.ciq99[n] = this.ciq[n];
        }
    }
}

