/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jcm.core.interacob;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.param;
import jcm.core.qtset;
import jcm.core.reg.mapprojection;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.reg.regpoly;
import jcm.core.register;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.menuFiller;
import jcm.gui.nav.showpan;
import jcm.gui.plot.colormap;
import jcm.gui.plot.colorscale;
import jcm.gui.plot.qtsetcolormap;
import jcm.mod.soc.socreg;

public class mapplot
extends JPanel {
    public param startlon = new param("mapstartlongitude", "degrees", 349, 0, 360);
    public param projection = mapprojection.getparam();
    public param<region> regions;
    interacob source;
    colormap cm;
    colorscale cols;
    JPanel intpan;
    boolean ownregions = false;

    mapprojection getprojection() {
        return (mapprojection)this.projection.chosen;
    }

    public mapplot(interacob io) {
        this.source = io;
        if (this.source instanceof colormap) {
            this.cm = (colormap)((Object)this.source);
        }
        this.setName(labman.getTitle(this.source.getNameWithWorld() + "&map"));
        if (this.source instanceof param) {
            this.regions = (param)this.source;
        }
        if (this.source instanceof qtset) {
            this.cm = new qtsetcolormap((qtset)this.source);
            this.regions = this.source.getworld().get(socreg.class).regions;
        }
        if (this.regions == null) {
            this.regions = regman.makeregionparam("mapregions", "ALL");
            this.ownregions = true;
        }
        this.setToolTipText(this.getName());
        this.setPreferredSize(new Dimension(400, 300));
        this.setCursor(new Cursor(1));
        this.setLayout(new BorderLayout());
        JMenuBar mb = new JMenuBar();
        mb.add(this.projection.getMenuItem());
        mb.add(this.regions.getMenuItem());
        this.intpan = new JPanel();
        this.intpan.setLayout(new BorderLayout());
        if (this.cm != null) {
            System.err.println("making colorscale from " + this.cm);
            this.cm.resetscale();
            this.cols = new colorscale(this.cm);
            mb.add(this.cols.reset);
            this.intpan.add((Component)this.cols, "South");
            if (this.cm instanceof qtsetcolormap) {
                mb.add(((qtsetcolormap)this.cm).year.getComponent(new Object[0]));
            }
        }
        this.add((Component)mb, "North");
        map map2 = new map();
        this.intpan.add(map2);
        this.add(this.intpan);
        map2.ready = true;
    }

    public void addNotify() {
        super.addNotify();
        loop.golater();
    }

    public void removeNotify() {
        super.removeNotify();
        if (showpan.moulist.carrying != this) {
            this.projection.dispose();
            this.startlon.dispose();
            if (this.ownregions) {
                this.regions.dispose();
            }
        }
        loop.golater();
    }

    class map
    extends JPanel
    implements MouseInputListener,
    plotlink,
    menuFiller {
        boolean firsttime = true;
        boolean ready = false;
        boolean inside = false;
        Map<region, Set<Polygon>> plotpoly = new HashMap<region, Set<Polygon>>();
        Map<region, Color> plotcolor = new HashMap<region, Color>();
        int ow = 0;
        int oh = 0;
        double mx;
        double oldmx;
        double my;
        JLabel info = new JLabel();
        region insidereg;

        map() {
            this.setLayout(null);
            this.setBackground(Color.white);
            this.add(this.info);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            new jcmMenu(this);
            register.addlink(this, mapplot.this.regions, mapplot.this.projection, mapplot.this.startlon, mapplot.this.source);
            if (mapplot.this.cm != null) {
                register.addlink(this, mapplot.this.cols.sp);
                System.err.println("map linked to sp");
            }
            if (mapplot.this.cm != null && mapplot.this.cm instanceof qtsetcolormap) {
                register.addlink(this, ((qtsetcolormap)mapplot.this.cm).year);
            }
            loop.gonow();
        }

        public void doplot() {
            if (this.ready) {
                if (this.firsttime) {
                    mapplot.this.cols.resetAction.act();
                }
                this.makepolys();
                this.repaint();
            }
        }

        public boolean isShowing() {
            return !this.ready || super.isShowing();
        }

        void makepolys() {
            boolean colorschanged;
            int w = this.getWidth();
            int h = this.getHeight();
            List<region> rs = ((region)mapplot.this.regions.chosen).reg;
            boolean sizechanged = w != this.ow || h != this.oh || mapplot.this.startlon.changed || mapplot.this.projection.changed;
            boolean regchanged = this.firsttime || mapplot.this.regions.changed;
            boolean bl = colorschanged = mapplot.this.cm != null && (mapplot.this.cols.sp.changed || regchanged || mapplot.this.source.changed || mapplot.this.cm instanceof qtsetcolormap && ((qtsetcolormap)mapplot.this.cm).year.changed);
            if (sizechanged) {
                mapplot.this.getprojection().setsize(0, 0, w, h, (int)mapplot.this.startlon.val);
            }
            this.ow = w;
            this.oh = h;
            if (regchanged) {
                ((region)mapplot.this.regions.chosen).makepolys();
                for (region r : rs) {
                    r.makepolys();
                }
                this.plotpoly.clear();
                for (region r : rs) {
                    this.plotpoly.put(r, new HashSet());
                }
                this.plotcolor.clear();
            }
            if (regchanged || sizechanged) {
                mapprojection mp = mapplot.this.getprojection();
                for (region r : rs) {
                    this.plotpoly.get(r).clear();
                }
                for (region r : rs) {
                    for (regpoly p : r.polyset) {
                        this.plotpoly.get(r).add(mp.translate(p));
                    }
                }
            }
            if (colorschanged) {
                for (region r : rs) {
                    this.plotcolor.put(r, mapplot.this.cols.getColor(mapplot.this.cm.getValue(r)));
                }
            }
            this.firsttime = false;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            lookandfeel.setAntiAlias(g);
            this.makepolys();
            region rs = (region)mapplot.this.regions.chosen;
            for (region r : rs.reg) {
                g.setColor(mapplot.this.cm != null ? this.plotcolor.get(r) : r.getColor());
                for (Polygon p : this.plotpoly.get(r)) {
                    try {
                        g.fillPolygon(p);
                    }
                    catch (Exception e) {
                        System.err.println("mapplot problem plotting " + r.name);
                    }
                }
            }
            for (region r : rs.reg) {
                g.setColor(mapplot.this.cm != null ? Color.black : r.getColor().darker());
                for (Polygon p : this.plotpoly.get(r)) {
                    try {
                        g.drawPolygon(p);
                    }
                    catch (Exception e) {}
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.findpos(e);
            if (this.inside) {
                mapplot.this.startlon.val = (int)(((double)((int)mapplot.this.startlon.val) + (this.mx - this.oldmx) + 360.0) % 360.0);
                mapplot.this.startlon.respond(true);
            }
        }

        public void mouseMoved(MouseEvent e) {
            this.findpos(e);
            if (this.inside) {
                this.writepos();
            }
        }

        public void mousePressed(MouseEvent e) {
            this.findpos(e);
            if (this.inside) {
                this.oldmx = this.mx;
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void fillMenu(jcmMenu popup) {
            popup.add(imagesaver.copyaction(mapplot.this.intpan));
            popup.add(imagesaver.saveimagemenu(mapplot.this.intpan, "JCM-map"));
            popup.add(showpan.pan("Show doc", docview.class, "mapplot"));
        }

        void findpos(MouseEvent e) {
            this.findpos(e.getX(), e.getY());
        }

        void findpos(int x, int y) {
            Point p = mapplot.this.getprojection().translateback(x, y);
            this.mx = p.x;
            this.my = p.y;
            this.inside = this.my < 90.0 && this.my > -90.0 && this.mx < 180.0 && this.mx > -180.0;
            this.insidereg = this.findreg(x, y);
            this.info.setLocation(x + 4, y + 4);
        }

        public region findreg(int x, int y) {
            for (region r : ((region)mapplot.this.regions.chosen).reg) {
                if (!r.contains(mapplot.this.getprojection().translateback(x, y))) continue;
                return r;
            }
            return null;
        }

        public void writepos() {
            this.info.setText(this.inside ? this.latlon() + " " + (this.insidereg != null ? this.insidereg.getName() + (mapplot.this.cm != null ? " " + mapplot.this.cm.getMapInfo(this.insidereg) : "") : "") : "");
            this.info.setSize(this.info.getPreferredSize());
        }

        public String latlon() {
            return (int)Math.abs(this.my) + (this.my > 0.0 ? " N" : " S") + " " + (int)Math.abs(this.mx) + (this.mx > 0.0 ? " E" : " W");
        }
    }
}

