/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import jcm.core.complexity;
import jcm.core.infob;
import jcm.core.jcmAction;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.doc.labman;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.gui.plot.arrow;
import jcm.gui.plot.backImage;
import jcm.gui.plot.baseplot;

public class lineplot
extends baseplot {
    boolean stacked = false;
    public static int thin = 250;

    public lineplot(qtset qq) {
        this(new Object[]{qq});
    }

    public lineplot(Object[] args) {
        for (Object o : args) {
            if (o.toString().contains("stacked")) {
                this.stacked = true;
            }
            if (o instanceof qtset) {
                this.qq = (qtset)o;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(o.toString())));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.setup();
        if (this.stacked) {
            this.legend.stacked = true;
        }
    }

    void extrasavesetup(List al) {
        if (this.stacked) {
            al.add("stacked");
        }
    }

    void makescales() {
        this.xscale = this.qq.getxscale();
        this.yscale = this.qq.getyscale();
    }

    void makeplot() {
        this.plot = new lineplotmainpan();
    }

    public void fillMenu(jcmMenu popup) {
        qt.Type cfr_ignored_0 = this.qq.type;
        if (this.qq.type != qt.Type.ratio) {
            qt.Type cfr_ignored_1 = this.qq.type;
            if (this.qq.type != qt.Type.rate) {
                popup.add(new jcmAction("Stack Curves", complexity.simplest){

                    public void act() {
                        lineplot.this.changestack();
                    }
                });
                popup.addSeparator();
            }
        }
        super.fillMenu(popup);
    }

    public void changestack() {
        this.legend.stacked = this.stacked = !this.stacked;
        this.yscale.max = this.qq.getmax(this.stacked);
        this.yscale.units.checkunitfac(this.yscale.max() - this.yscale.min());
        this.ysv.repaint();
        this.doplot();
    }

    class lineplotmainpan
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        Set<arrow> arrows;
        backImage b;
        arrow dragarrow = null;

        public lineplotmainpan() {
            this.setLayout(null);
            this.setBackground(Color.white);
            this.add(lineplot.this.info);
            lineplot.this.info.setOpaque(true);
            this.setOpaque(true);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setCursor(new Cursor(1));
            if (lineplot.this.qq.assocparams != null) {
                this.arrows = new HashSet<arrow>(lineplot.this.qq.assocparams.size());
                for (param p : lineplot.this.qq.assocparams) {
                    this.arrows.add(new arrow(p, lineplot.this.xscale, lineplot.this.yscale, this));
                }
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            lookandfeel.setAntiAlias(g);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldat = g2.getTransform();
            float xsf = (float)this.getWidth() / lineplot.this.xscale.range();
            float ysf = (float)(-this.getHeight()) / lineplot.this.yscale.range();
            float xyf = xsf / ysf;
            g2.scale(ysf, ysf);
            g2.translate(-lineplot.this.xscale.min() * xyf, -lineplot.this.yscale.max());
            g2.setStroke(new BasicStroke(Math.abs(lineplot.this.yscale.range()) / (float)thin));
            if (lineplot.this.stacked) {
                int xmin = (int)lineplot.this.xscale.min();
                int xmax = (int)lineplot.this.xscale.max();
                int xstep = (int)Math.max((float)lineplot.this.qq.map.values().iterator().next().xstep, lineplot.this.xscale.range() / (float)this.getWidth());
                if (xstep < 1) {
                    xstep = 1;
                }
                int ns = (xmax - xmin) / xstep;
                float[] totpos = new float[1 + ns];
                float[] totneg = new float[1 + ns];
                GeneralPath basepos = new GeneralPath();
                GeneralPath baseneg = new GeneralPath();
                basepos.moveTo((float)xmin * xyf, 0.0f);
                baseneg.moveTo((float)xmin * xyf, 0.0f);
                basepos.lineTo((float)lineplot.this.qq.ey * xyf, 0.0f);
                baseneg.lineTo((float)lineplot.this.qq.ey * xyf, 0.0f);
                int x = xmin;
                int i = 0;
                while (x <= xmax) {
                    totpos[i] = 0.0f;
                    totneg[i] = 0.0f;
                    x += xstep;
                    ++i;
                }
                boolean even = true;
                for (qt q : lineplot.this.qq.mapwithouttotal().values()) {
                    int i2;
                    if (!q.checkcomplexity()) continue;
                    even = !even;
                    GeneralPath linepos = basepos;
                    GeneralPath lineneg = baseneg;
                    basepos = new GeneralPath();
                    baseneg = new GeneralPath();
                    boolean first = true;
                    int x2 = even ? xmin : xmax;
                    int n = i2 = even ? 0 : ns;
                    while (even ? x2 <= xmax : x2 >= xmin) {
                        if (q.gotdata(x2)) {
                            float dy = q.get(x2);
                            int n2 = i2;
                            totpos[n2] = totpos[n2] + (dy > 0.0f ? dy : 0.0f);
                            int n3 = i2;
                            totneg[n3] = totneg[n3] + (dy < 0.0f ? dy : 0.0f);
                            linepos.lineTo((float)x2 * xyf, totpos[i2]);
                            lineneg.lineTo((float)x2 * xyf, totneg[i2]);
                            if (first) {
                                basepos.moveTo((float)x2 * xyf, totpos[i2]);
                            } else {
                                basepos.lineTo((float)x2 * xyf, totpos[i2]);
                            }
                            if (first) {
                                baseneg.moveTo((float)x2 * xyf, totneg[i2]);
                            } else {
                                baseneg.lineTo((float)x2 * xyf, totneg[i2]);
                            }
                            first = false;
                        }
                        x2 += even ? xstep : -xstep;
                        i2 += even ? 1 : -1;
                    }
                    g2.setColor(q.color);
                    g2.fill(linepos);
                    g2.fill(lineneg);
                }
            } else {
                for (qt q : lineplot.this.qq.map.values()) {
                    if (!q.checkcomplexity()) continue;
                    GeneralPath line = new GeneralPath();
                    boolean haddata = false;
                    int xstep = (int)Math.max((float)q.xstep, lineplot.this.xscale.range() / (float)this.getWidth());
                    if (xstep < 1) {
                        xstep = 1;
                    }
                    for (int x = (int)lineplot.this.xscale.min(); x <= (int)lineplot.this.xscale.max(); x += xstep) {
                        if (!q.gotdata(x)) {
                            haddata = false;
                        }
                        if (q.gotdata(x) && !haddata) {
                            line.moveTo((float)x * xyf, q.get(x));
                            haddata = true;
                        }
                        if (!q.gotdata(x) || !haddata) continue;
                        line.lineTo((float)x * xyf, q.get(x));
                    }
                    g2.setColor(q.color);
                    try {
                        g2.draw(line);
                    }
                    catch (Throwable e) {
                        System.err.println("line drawing error");
                    }
                }
            }
            g2.setTransform(oldat);
            lineplot.this.ready = true;
            if (this.arrows != null) {
                for (arrow a : this.arrows) {
                    if (!a.checkenabled()) continue;
                    try {
                        a.getpos();
                        a.draw(g);
                    }
                    catch (Throwable e) {
                        System.err.println("arrow drawing error" + a + " " + e);
                    }
                }
            }
            if (this.dragarrow == null) {
                lineplot.this.info.repaint();
            }
            g2.dispose();
        }

        public void mouseMoved(MouseEvent e) {
            try {
                block11: {
                    if (this.arrows != null) {
                        for (arrow a : this.arrows) {
                            if (!a.checkenabled() || !a.poly.contains(e.getPoint())) continue;
                            lineplot.this.info.setText(a.getinfo());
                            break block11;
                        }
                    }
                    infob best = null;
                    float x = lineplot.this.xscale.min() + lineplot.this.xscale.range() * (float)e.getX() / (float)this.getWidth();
                    float y = lineplot.this.yscale.max() - lineplot.this.yscale.range() * (float)e.getY() / (float)this.getHeight();
                    float y2 = 0.0f;
                    int xi = (int)((double)x + 0.5);
                    if (x > lineplot.this.xscale.min() && x < lineplot.this.xscale.max() && y > lineplot.this.yscale.min() && y < lineplot.this.yscale.max()) {
                        int locx = Math.min(e.getX() + 4, this.getWidth() - lineplot.this.info.getWidth() - 4);
                        lineplot.this.info.setLocation(locx, e.getY() + 4);
                        if (lineplot.this.stacked) {
                            float sum = 0.0f;
                            for (qt q : lineplot.this.qq.mapwithouttotal().values()) {
                                if (!q.checkcomplexity()) continue;
                                y2 = q.get(xi);
                                if (Math.signum(y) == Math.signum(y2)) {
                                    sum += y2;
                                    best = q;
                                }
                                if (!(Math.abs(sum) > Math.abs(y))) {
                                    best = null;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (qt q : lineplot.this.qq.map.values()) {
                                if (!q.checkcomplexity()) continue;
                                float y2t = q.get(xi);
                                float f = Math.abs(y2t - y);
                                float f2 = best == null ? lineplot.this.yscale.range() / 20.0f : Math.abs(y2 - y);
                                if (!(f < f2)) continue;
                                best = q;
                                y2 = y2t;
                            }
                        }
                        lineplot.this.info.setText((best == null ? "" : "<html>" + best.hashcolor() + labman.getTitle(((qt)best).name) + " </font>") + xi + ": " + lineplot.this.yscale.units.round(best == null ? y : y2, 2));
                    }
                }
                lineplot.this.info.setSize(lineplot.this.info.getPreferredSize());
            }
            catch (Throwable ex) {
                System.err.println("lineplot mouse moved error");
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragarrow != null) {
                this.dragarrow.move(e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (this.dragarrow == null && this.arrows != null) {
                for (arrow a : this.arrows) {
                    if (!a.poly.contains(e.getPoint())) continue;
                    this.dragarrow = a;
                    lineplot.this.info.setSize(0, 0);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.dragarrow = null;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            lineplot.this.info.setText("");
            lineplot.this.info.setSize(new Dimension(0, 0));
        }
    }
}

