/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import jcm.core.infob;
import jcm.core.param;
import jcm.core.qtset;
import jcm.core.register;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.plot.baseplot;

public class histoplot
extends baseplot {
    param year;
    List regs = new ArrayList();
    Comparator comp = new Comparator(){

        public int compare(Object a, Object b) {
            return histoplot.this.calcratio(a) > histoplot.this.calcratio(b) ? 1 : (histoplot.this.calcratio(a) < histoplot.this.calcratio(b) ? -1 : 0);
        }
    };

    public histoplot(qtset qq) {
        this(new Object[]{qq});
    }

    public histoplot(Object[] args) {
        for (Object o : args) {
            if (o instanceof qtset) {
                this.qq = (qtset)o;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(o.toString())));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.canaddextra = true;
        double minsy = Math.max(this.qq.qqa.sy, this.qq.qqb.sy);
        double maxey = Math.min(this.qq.qqa.ey, this.qq.qqb.ey);
        this.year = new param("year", 2002, minsy, maxey, "year");
        register.addlink(this, this.year);
        this.setup();
        this.sort();
        this.plot.add((Component)new paramValueChooser(this.year, new Object[0]), "North");
    }

    void makeplot() {
        this.plot = new histo();
    }

    public void doplot() {
        this.sort();
        super.repaint();
    }

    void makescales() {
        for (Object o : this.qq.qqb.mapwithouttotal().keySet()) {
            this.regs.add(o);
        }
        float sum = 0.0f;
        float max = 0.0f;
        for (Object o : this.regs) {
            sum += this.qq.qqb.reg(o).get((int)this.year.val);
            float f = this.calcratiotot(o);
            if (!(f > max)) continue;
            max = f;
        }
        this.yscale = new param(new Object[]{param.Type.Yscale, "Yscale", this.qq.qqa.units + "&per&" + this.qq.qqb.units, 0, 0, Float.valueOf(max)});
        this.xscale = new param(new Object[]{param.Type.Xscale, "Xscale", this.qq.qqb.units, 0, 0, Float.valueOf(sum)});
    }

    float calcratio(Object o) {
        return this.calcratio(o, this.qq.qqa);
    }

    float calcratio(Object o, qtset qqy) {
        float fr = this.qq.qqb.reg(o).get((int)this.year.val);
        if (fr <= 0.0f) {
            return 0.0f;
        }
        return qqy.reg(o).get((int)this.year.val) / fr;
    }

    float calcratiotot(Object o) {
        float f = 0.0f;
        for (qtset qqy : this.qq.qqalist()) {
            f += this.calcratio(o, qqy);
        }
        return f;
    }

    void sort() {
        Collections.sort(this.regs, this.comp);
    }

    class histo
    extends JPanel
    implements MouseMotionListener {
        public histo() {
            this.addMouseMotionListener(this);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            lookandfeel.setAntiAlias(g);
            int w = this.getSize().width;
            int h = this.getSize().height;
            float xx = -histoplot.this.xscale.min() * (float)w / histoplot.this.xscale.range();
            for (Object o : histoplot.this.regs) {
                if (o instanceof infob) {
                    g.setColor(((infob)o).getColor());
                }
                float x = histoplot.this.qq.qqb.reg(o).get((int)histoplot.this.year.val) * (float)w / histoplot.this.xscale.range();
                float yy = h;
                for (qtset qqy : histoplot.this.qq.qqalist()) {
                    float y = (int)(histoplot.this.calcratio(o, qqy) * (float)h / histoplot.this.yscale.max());
                    if (y < 0.0f) {
                        g.setColor(Color.white);
                        g.fillRect((int)xx + 1, (int)yy + 1, (int)x - 2, (int)(-y) - 1);
                    } else {
                        g.fillRect((int)xx, (int)(yy - y) - 1, (int)x, (int)y - 1);
                    }
                    g.setColor(histoplot.this.variant(g.getColor()));
                    yy -= y;
                }
                xx += x;
            }
            histoplot.this.ready = true;
        }

        public void mouseMoved(MouseEvent e) {
            float xx = 0.0f;
            for (Object o : histoplot.this.regs) {
                float x = histoplot.this.qq.qqb.reg(o).get((int)histoplot.this.year.val) * (float)this.getSize().width / histoplot.this.xscale.max();
                if (xx + x > (float)e.getX() && o instanceof infob) {
                    String s = "<html>" + ((infob)o).hashcolor() + ((infob)o).getName();
                    for (qtset qqy : histoplot.this.qq.qqalist()) {
                        s = s + " " + histoplot.this.calcratio(o, qqy);
                    }
                    this.setToolTipText(s);
                    return;
                }
                xx += x;
            }
        }

        public void mouseDragged(MouseEvent e) {
        }
    }
}

