/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import jcm.core.itf.plotlink;
import jcm.core.jcmAction;
import jcm.core.loop;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.core.register;
import jcm.core.tls.fileio;
import jcm.gui.doc.labman;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.menuFiller;
import jcm.gui.plot.jcmTM;

public class datable
extends JScrollPane
implements plotlink {
    jcmTM tm;
    boolean ready = false;

    public datable(final qtset qq) {
        this.setName(labman.getTitle(qq.getNameWithWorld()));
        this.setToolTipText(this.getName());
        register.addlink(this, qq);
        loop.gonow();
        this.tm = new jcmTM(qq);
        JTable tab = new JTable(this.tm);
        tab.setColumnSelectionAllowed(true);
        this.setcolor(tab, 0, Color.black);
        int c = 1;
        for (qt q : qq.map.values()) {
            this.setcolor(tab, c, q.color);
            ++c;
        }
        tab.setAutoResizeMode(0);
        this.setViewportView(tab);
        new jcmMenu(tab, new menuFiller(){

            public void fillMenu(jcmMenu pop) {
                pop.add(datable.savetablemenu(qq));
                pop.addSeparator();
                qq.fillMenu(pop);
            }
        });
        this.ready = true;
    }

    void setcolor(JTable tab, int column, final Color color) {
        tab.getColumnModel().getColumn(column).setCellRenderer(new DefaultTableCellRenderer(){

            public void setValue(Object value) {
                this.setForeground(color);
                super.setValue(value);
            }
        });
    }

    public void doplot() {
        try {
            this.tm.fireTableDataChanged();
            this.repaint();
        }
        catch (Exception e) {
            System.out.println("table plot problem");
        }
    }

    public boolean isShowing() {
        return !this.ready || super.isShowing();
    }

    public static jcmMenu savetablemenu(final qtset qq) {
        jcmMenu savetable = new jcmMenu(new Object[]{"Save table"});
        for (final String s : new String[]{"csv", "tab"}) {
            savetable.add(new jcmAction(s){

                public void act() {
                    qq.forcecalc();
                    datable.savetable(qq.name, (TableModel)new jcmTM(qq), s);
                }
            });
        }
        return savetable;
    }

    public static jcmMenu savetablemenu(final String name, final TableModel tm) {
        jcmMenu savetable = new jcmMenu(new Object[]{"Save table"});
        for (final String s : new String[]{"csv", "tab"}) {
            savetable.add(new jcmAction(s){

                public void act() {
                    datable.savetable(name, tm, s);
                }
            });
        }
        return savetable;
    }

    public static void savetable(String name, TableModel tm, String type2) {
        File f = fileio.getFileFromDialog("user", name + "." + type2, "Save Table", "save");
        if (f != null) {
            datable.savetable(f, tm, type2);
        }
    }

    public static void savetable(File f, qtset qq, String type2) {
        datable.savetable(f, (TableModel)new jcmTM(qq), type2);
    }

    public static void savetable(File f, TableModel tm, String type2) {
        if (f != null) {
            try {
                FileWriter fw = new FileWriter(f);
                int rows = tm.getRowCount();
                int cols = tm.getColumnCount();
                for (int row = 0; row < rows; ++row) {
                    String line = "";
                    for (int col = 0; col < cols; ++col) {
                        line = line + tm.getValueAt(row, col) + (type2 == "csv" ? ", " : "\t");
                    }
                    fw.write(line + "\n");
                }
                fw.close();
                System.out.println("saved table: " + f);
            }
            catch (IOException e) {
                System.out.println("IO Exception\n" + e);
            }
        }
    }
}

