/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import jcm.core.itf.hasSetupInfo;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.core.register;
import jcm.gui.doc.labman;
import jcm.gui.gen.imagesaver;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.menuFiller;
import jcm.gui.nav.showpan;
import jcm.gui.plot.backImage;
import jcm.gui.plot.legend;
import jcm.gui.plot.lineplot;
import jcm.gui.plot.scaleview;

public abstract class baseplot
extends JSplitPane
implements plotlink,
menuFiller,
hasSetupInfo {
    JPanel plot;
    legend legend;
    jcmMenu popup;
    JLabel info = new JLabel();
    public param xscale;
    public param yscale;
    scaleview xsv;
    scaleview ysv;
    qtset qq;
    boolean canaddextra = false;
    List<Float> scalesetup = new ArrayList<Float>(5);
    boolean ready = false;

    void setup() {
        register.addlink(this, this.qq);
        loop.gonow();
        this.qq.refreshregs();
        this.legend = new legend(this.qq);
        this.setname();
        this.makescales();
        this.restorescalesetup();
        this.makescaleviews();
        this.makeplot();
        this.setlayout();
        this.setcolor();
        this.setToolTipText(this.getToolTip());
        jcmMenu popup = new jcmMenu(this.plot, this);
        popup.addFiller(this.qq);
        this.setVisible(true);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        backImage.paint(this.qq, this, g, this.getWidth(), this.getHeight());
    }

    void makeplot() {
    }

    public void savesetup() {
        List al = register.getargs(this);
        al.clear();
        al.add(this.qq);
        al.add(Float.valueOf(this.xscale.min()));
        al.add(Float.valueOf(this.xscale.max()));
        al.add(Float.valueOf(this.yscale.min()));
        al.add(Float.valueOf(this.yscale.max()));
        al.add(this.plot.getWidth());
        this.extrasavesetup(al);
    }

    void extrasavesetup(List al) {
    }

    void restorescalesetup() {
        if (this.scalesetup.size() > 3) {
            this.xscale.min = this.scalesetup.get(0).floatValue();
            this.xscale.max = this.scalesetup.get(1).floatValue();
            this.yscale.min = this.scalesetup.get(2).floatValue();
            this.yscale.max = this.scalesetup.get(3).floatValue();
        }
    }

    String getlabcode() {
        String s = this instanceof lineplot ? "" : this.getClass().getSimpleName() + "&";
        s = s + this.qq.getNameWithWorld();
        return s;
    }

    String getToolTip() {
        return labman.getTitle(this.getlabcode());
    }

    void setname() {
        this.setName(labman.getShort(this.getlabcode()));
    }

    public void fillMenu(jcmMenu popup) {
        if (this.canaddextra) {
            popup.add(this.qq.makederivmenu(qt.Type.extra));
            popup.addSeparator();
        }
        popup.add(imagesaver.copyaction(this));
        popup.add(imagesaver.saveimagemenu(this, this.qq.name));
        popup.addSeparator();
    }

    abstract void makescales();

    void makescaleviews() {
        this.ysv = new scaleview(this.yscale);
        this.xsv = new scaleview(this.xscale);
        register.addlink(this, this.xscale, this.yscale);
    }

    public void doplot() {
        if (this.ready) {
            this.plot.repaint();
        }
        if (this.ready) {
            this.legend.makelabs(true);
        }
        if (this.ready) {
            this.savesetup();
        }
    }

    public boolean isShowing() {
        return !this.ready || super.isShowing();
    }

    void setlayout() {
        JPanel plotsca = new JPanel(new BorderLayout());
        this.ysv.setMinimumSize(new Dimension(40, 0));
        this.xsv.setMinimumSize(new Dimension(0, 20));
        this.xsv.aboveleft = this.ysv;
        this.plot.setMinimumSize(new Dimension(60, 60));
        this.plot.setPreferredSize(new Dimension(400, 400));
        plotsca.add((Component)this.ysv, "West");
        plotsca.add((Component)this.plot, "Center");
        plotsca.add((Component)this.xsv, "South");
        this.setOrientation(1);
        this.setLeftComponent(plotsca);
        this.setRightComponent(this.legend);
        this.setBorder(null);
        plotsca.setBorder(null);
        this.legend.setBorder(null);
        this.setResizeWeight(0.85);
        this.setDividerSize(4);
    }

    public void removeNotify() {
        super.removeNotify();
        if (showpan.moulist.carrying != this) {
            this.xscale.dispose();
            this.yscale.dispose();
        }
        loop.golater();
    }

    public void addNotify() {
        super.addNotify();
        loop.golater();
    }

    void setcolor() {
        Color bcol = Color.white;
        if (this.qq.owner instanceof module) {
            bcol = this.brighter(((module)this.qq.owner).world.color);
        }
        this.setBackground(bcol);
        this.info.setBackground(bcol);
        this.plot.setBackground(bcol);
        this.ysv.setBackground(bcol);
        this.xsv.setBackground(bcol);
        this.legend.setBackground(bcol);
        this.setOpaque(true);
        this.plot.setOpaque(true);
        this.ysv.setOpaque(true);
        this.xsv.setOpaque(true);
        this.legend.setOpaque(true);
    }

    Color brighter(Color c) {
        if (c == Color.black) {
            return Color.white;
        }
        return new Color(255 - (255 - c.getRed()) / 8, 255 - (255 - c.getGreen()) / 8, 255 - (255 - c.getBlue()) / 8);
    }

    Color variant(Color c) {
        return new Color(this.vary(c.getRed()), this.vary(c.getGreen()), this.vary(c.getBlue()));
    }

    int vary(int c) {
        if (c < 127) {
            return (int)((double)c * 1.5);
        }
        return (int)((double)c * 0.67);
    }
}

