/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jcm.core.infob;
import jcm.core.param;
import jcm.core.tls.fileio;
import jcm.gui.nav.showpan;

public class backImage {
    public static Map<String, String> alias;
    public static Map<String, SoftReference<BufferedImage>> orig;
    public static Map<Object, SoftReference<BufferedImage>> conv;
    public static Map<JComponent, Boolean> origopaque;
    public static param usebackim;

    public static BufferedImage getImage(Object o, int w, int h) {
        BufferedImage bi = null;
        if (conv.containsKey(o)) {
            bi = conv.get(o).get();
        }
        if (bi != null) {
            return bi;
        }
        if (bi == null || bi.getWidth() != w || bi.getHeight() != h) {
            String filename = backImage.getFileName(o);
            if (filename == null) {
                return null;
            }
            BufferedImage or = null;
            if (orig.containsKey(filename)) {
                or = orig.get(filename).get();
            }
            if (or == null && (or = backImage.loadImage(filename)) != null) {
                orig.put(filename, new SoftReference<BufferedImage>(or));
            }
            if (or != null) {
                bi = backImage.convert(or, w, h);
                conv.put(o, new SoftReference<BufferedImage>(bi));
                return bi;
            }
        }
        return null;
    }

    public static String getFileName(Object o) {
        if (o instanceof String) {
            return alias.get(o.toString());
        }
        if (o instanceof infob) {
            infob i = (infob)o;
            if (alias.containsKey(i.name)) {
                return alias.get(i.name);
            }
            if (i.owner != i) {
                return backImage.getFileName(i.owner);
            }
        }
        return null;
    }

    public static BufferedImage loadImage(String filename) {
        try {
            URL u = fileio.getURL("backpic/" + filename);
            return ImageIO.read(u);
        }
        catch (Exception e) {
            System.err.println("can't get background for " + filename);
            return null;
        }
    }

    public static BufferedImage convert(BufferedImage orig, int w, int h) {
        float ow = orig.getWidth();
        float oh = orig.getHeight();
        float f = Math.min(ow / (float)w, oh / (float)h);
        int nw = (int)(f * (float)w);
        int nh = (int)(f * (float)h);
        int x = (int)(ow - (float)nw) / 2;
        int y = (int)(oh - (float)nh) / 2;
        BufferedImage bi = new BufferedImage(w, h, 5);
        Graphics2D g2 = bi.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, w, h);
        g2.setComposite(AlphaComposite.getInstance(3, 0.33f));
        g2.drawImage(orig, 0, 0, w, h, x, y, x + nw, y + nh, null);
        g2.dispose();
        return bi;
    }

    public static void setOpaque(JComponent c, boolean opaque) {
        if (opaque && origopaque.containsKey(c)) {
            c.setOpaque(origopaque.get(c));
        } else {
            origopaque.put(c, c.isOpaque());
            c.setOpaque(false);
        }
        for (Component c2 : c.getComponents()) {
            if (!(c2 instanceof JComponent)) continue;
            backImage.setOpaque((JComponent)c2, opaque);
        }
    }

    public static void paint(Object o, JComponent c, Graphics g, int w, int h) {
        BufferedImage bi;
        backImage.setOpaque(c, usebackim.isfalse());
        if (usebackim.istrue() && (bi = backImage.getImage(o, w, h)) != null) {
            try {
                g.drawImage(bi, 0, 0, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        String[][] sss;
        alias = new HashMap<String, String>();
        orig = new HashMap<String, SoftReference<BufferedImage>>();
        conv = new WeakHashMap<Object, SoftReference<BufferedImage>>();
        origopaque = new WeakHashMap<JComponent, Boolean>();
        usebackim = new param(new Object[]{"BackImage", false}){

            public void respond() {
                SwingUtilities.updateComponentTreeUI(showpan.mf);
                showpan.mf.repaint();
            }
        };
        String[][] arr$ = sss = fileio.loadtab("backpic/backpics.txt", ",");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] ss;
            for (String s : ss = arr$[i$]) {
                alias.put(s, ss[0]);
            }
        }
    }
}

