/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;
import jcm.core.param;
import jcm.core.qtset;
import jcm.core.register;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.plot.baseplot;

public class XYplot
extends baseplot {
    param sy;
    param ey;

    public XYplot(qtset qq) {
        this(new Object[]{qq});
    }

    public XYplot(Object[] args) {
        for (Object o : args) {
            if (o instanceof qtset) {
                this.qq = (qtset)o;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(o.toString())));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.canaddextra = true;
        double minsy = Math.max(this.qq.qqa.sy, this.qq.qqb.sy);
        double maxey = Math.min(this.qq.qqa.ey, this.qq.qqb.ey);
        this.sy = new param(new Object[]{"from", 2002, minsy, maxey, "year"}){

            public void precalc() {
                XYplot.this.ey.min = this.val - 1.0;
            }
        };
        this.ey = new param("until", 2002, minsy, maxey, "year");
        register.addlink(this, this.sy);
        register.addlink(this, this.ey);
        this.setup();
        this.xsv.setMinimumSize(new Dimension(0, 40));
        this.plot.add((Component)new paramValueChooser(this.sy, new Object[0]), "North");
        this.plot.add((Component)new paramValueChooser(this.ey, new Object[0]), "North");
    }

    public void doplot() {
        super.repaint();
    }

    void makeplot() {
        this.plot = new scatter();
    }

    void makescales() {
        this.yscale = this.qq.qqa.getyscale();
        this.xscale = this.qq.qqb.getyscale();
        this.xscale.type = param.Type.Xscale;
    }

    void plot(Graphics2D g2, qtset qqx, qtset qqy, float xyf, float ysf) {
        GeneralPath line = new GeneralPath();
        for (Object o : qqy.map.keySet()) {
            if (!qqx.map.containsKey(o)) continue;
            g2.setColor(qqy.map.get((Object)o).color);
            if ((int)this.sy.getval() < (int)this.ey.getval()) {
                line.reset();
                line.moveTo(qqx.get(o, (int)this.sy.val) * xyf, qqy.get(o, (int)this.sy.val));
                for (int year = (int)this.sy.val + 1; year <= (int)this.ey.val; ++year) {
                    line.lineTo(qqx.get(o, year) * xyf, qqy.get(o, year));
                }
                try {
                    g2.draw(line);
                }
                catch (Error e) {
                    System.err.println("line drawing error");
                }
                continue;
            }
            float rad = -12.0f / ysf;
            g2.draw(new Ellipse2D.Float(qqx.get(o, (int)this.sy.val) * xyf - rad, qqy.get(o, (int)this.sy.val) - rad, rad, rad));
        }
    }

    class scatter
    extends JPanel {
        scatter() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            lookandfeel.setAntiAlias(g);
            Graphics2D g2 = (Graphics2D)g.create();
            AffineTransform oldat = g2.getTransform();
            float xsf = (float)this.getWidth() / XYplot.this.xscale.range();
            float ysf = (float)(-this.getHeight()) / XYplot.this.yscale.range();
            float xyf = xsf / ysf;
            g2.scale(ysf, ysf);
            g2.translate(-XYplot.this.xscale.min() * xyf, -XYplot.this.yscale.max());
            g2.setStroke(new BasicStroke(Math.abs(XYplot.this.yscale.range()) / 250.0f));
            for (qtset qqy : XYplot.this.qq.qqalist()) {
                XYplot.this.plot(g2, XYplot.this.qq.qqb, qqy, xyf, ysf);
            }
            g2.setTransform(oldat);
            g2.dispose();
            XYplot.this.ready = true;
        }
    }
}

