/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jcm.core.complexity;
import jcm.core.infob;
import jcm.core.jcmAction;
import jcm.core.loop;
import jcm.core.register;
import jcm.core.setup;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.doc.sourceview;
import jcm.gui.gen.iconFinder;
import jcm.gui.gen.lookandfeel;
import jcm.gui.gen.sysout;
import jcm.gui.nav.capwin;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.menuFiller;
import jcm.gui.nav.moulist;
import jcm.gui.nav.topMenus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class showpan {
    public static JFrame mf;
    public static moulist moulist;
    public static JMenuBar mb;
    public static Color bg;

    public static Dimension screensize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Point screencenter(Component c) {
        return new Point((showpan.screensize().width - c.getSize().width) / 2, (showpan.screensize().height - c.getSize().height) / 2);
    }

    public static JFrame mainframe() {
        return showpan.mainframe(new Dimension(600, 400), new Point(showpan.screensize().width / 6, showpan.screensize().height / 6));
    }

    public static JFrame mainframe(Dimension d, Point p) {
        lookandfeel.lookAndFeelParam.precalc();
        loop.gonow(false);
        mf = new JFrame("Java Climate Model ( www.climate.be / jcm ) ");
        mf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                showpan.close();
            }
        });
        JSplitPane right = new JSplitPane(0, new jcmTabbedPane(), new jcmTabbedPane());
        JSplitPane main = new JSplitPane(1, new jcmTabbedPane(), right);
        right.setResizeWeight(0.5);
        main.setResizeWeight(0.3);
        mf.setContentPane(main);
        mf.setJMenuBar(mb);
        mf.setLocation(p);
        mf.setPreferredSize(d);
        try {
            mf.setIconImage(((ImageIcon)iconFinder.findIcon("World 1")).getImage());
        }
        catch (Exception e) {
            // empty catch block
        }
        topMenus.makemenus();
        mf.validate();
        mf.pack();
        mf.setVisible(true);
        System.err.println("JCM Main Window Ready");
        return mf;
    }

    public static JDesktopPane makejdp() {
        JDesktopPane jdp = new JDesktopPane();
        showpan.addpanmenu(jdp);
        return jdp;
    }

    public static void close() {
        try {
            labman.saveonexit();
            setup.savesetupdefault();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static JComponent findContainer(Point p) {
        return showpan.findContainer(mf.getRootPane().findComponentAt(p));
    }

    public static JComponent findContainer(Component c) {
        while (c != null && c != c.getParent() && !(c instanceof jcmTabbedPane) && !(c instanceof JDesktopPane)) {
            c = c.getParent();
        }
        return (JComponent)c;
    }

    public static jcmTabbedPane findTabbedPane(Component c) {
        return (jcmTabbedPane)showpan.findContainer(c);
    }

    public static void dispose(JComponent c) {
        try {
            Container cont = c.getRootPane().getParent();
            if (cont instanceof JInternalFrame) {
                ((JInternalFrame)cont).dispose();
                return;
            }
            if (cont instanceof JFrame && cont != mf) {
                ((JFrame)cont).dispose();
                return;
            }
            showpan.findTabbedPane(c).remove(c);
            c.removeNotify();
            c = null;
        }
        catch (Exception e) {
            System.err.println("error disposing " + c + " " + e);
        }
    }

    public static void toFront(JComponent c) {
        try {
            Container cont = c.getRootPane().getParent();
            if (cont instanceof JInternalFrame) {
                ((JInternalFrame)cont).toFront();
                return;
            }
            if (cont instanceof JFrame && cont != mf) {
                ((JFrame)cont).toFront();
                return;
            }
            showpan.findTabbedPane(c).setSelectedComponent(c);
        }
        catch (Exception e) {
            System.err.println("error toFront " + c + " " + e);
        }
    }

    public static Container show(JComponent c, Object ... args) {
        String name = c.getName();
        Point po = null;
        Icon i = null;
        Component cont = null;
        for (Object o : args) {
            if (o == null) continue;
            if (o instanceof String) {
                name = (String)o;
            }
            if (o instanceof Point) {
                po = (Point)o;
            }
            if (o instanceof Icon) {
                i = (Icon)o;
            }
            if (o instanceof Component) {
                cont = (Component)o;
            }
            if (!(o instanceof infob) || i != null) continue;
            i = ((infob)o).getIcon();
        }
        if (i == null) {
            i = iconFinder.findIcon(name);
        }
        if (i == null) {
            i = iconFinder.findIcon(c);
        }
        if (cont == null) {
            if (po == null) {
                Point point = c instanceof jcmTree ? new Point(100, 100) : (c instanceof docview || c instanceof sourceview ? new Point(mf.getWidth() - 100, 100) : (po = c instanceof sysout || c instanceof Box ? new Point(mf.getWidth() / 2, mf.getHeight() - 100) : new Point(mf.getWidth() / 2, mf.getHeight() / 2)));
            }
            if ((cont = showpan.findContainer(po)) == null) {
                po.translate(-20, -20);
                cont = showpan.findContainer(po);
            }
            if (cont == null) {
                po.translate(40, 40);
                cont = showpan.findContainer(po);
            }
            if (cont == null) {
                mf.getGlassPane().setVisible(true);
                mf.getGlassPane().getGraphics().fillRect(po.x - 10, po.y - 10, 20, 20);
            }
            if (cont == null) {
                System.err.println("Try to Show " + c + "\n in " + cont + "\n at " + po);
            }
        }
        if (cont instanceof jcmTabbedPane) {
            jcmTabbedPane jtp = (jcmTabbedPane)cont;
            if (i != null) {
                jtp.addTab(labman.getTitle(name) + "  ", i, c);
            } else {
                jtp.addTab(labman.getTitle(name) + "  ", c);
            }
            showpan.toFront(c);
            return jtp;
        }
        if (cont instanceof JDesktopPane) {
            JDesktopPane jdp = (JDesktopPane)cont;
            JInternalFrame[] fa = jdp.getAllFrames();
            po = fa.length > 0 ? new Point((fa[fa.length - 1].getX() + 40) % jdp.getWidth(), (fa[fa.length - 1].getY() + 40) % jdp.getHeight()) : new Point(20, 20);
            JInternalFrame f = new JInternalFrame(labman.getTitle(name), true, true, true);
            f.add(c);
            f.pack();
            if (i != null) {
                f.setFrameIcon(i);
            }
            jdp.add(f);
            f.setLocation(po);
            f.setVisible(true);
            showpan.toFront(c);
            return f;
        }
        if (cont instanceof JFrame) {
            JFrame f = (JFrame)cont;
            f.add(c);
            f.pack();
            if (i != null && i instanceof ImageIcon) {
                f.setIconImage(((ImageIcon)i).getImage());
            }
            if (po != null) {
                f.setLocation(po);
            }
            f.setVisible(true);
            showpan.toFront(c);
            return f;
        }
        return null;
    }

    public static jcmAction pan(Class<? extends JComponent> c) {
        return showpan.pan(c.getSimpleName(), c, null);
    }

    public static jcmAction pan(Class<? extends JComponent> c, complexity complex) {
        return showpan.pan(c.getSimpleName(), c, null, complex);
    }

    public static jcmAction pan(Class<? extends JComponent> c, Object o) {
        return showpan.pan(o.toString(), c, o);
    }

    public static jcmAction pan(String name, Class<? extends JComponent> c, Object o) {
        return showpan.pan(name, c, o, complexity.simplest);
    }

    public static jcmAction pan(String name, final Class<? extends JComponent> c, final Object o, complexity complex) {
        jcmAction a = new jcmAction(name, complex){

            public void act() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        showpan.makepan(c, o, new Object[0]);
                    }
                });
            }
        };
        Icon i = iconFinder.findIcon(name);
        if (i == null && o instanceof infob) {
            i = iconFinder.findIcon((infob)o);
        }
        if (i == null) {
            i = iconFinder.findIcon(c.getSimpleName());
        }
        a.putValue("SmallIcon", i);
        return a;
    }

    public static JComponent makepan(Class<? extends JComponent> c, Object o, final Object ... args) {
        try {
            JComponent com;
            if (o == null) {
                com = c.newInstance();
            } else {
                Class<?> ic = o.getClass();
                Constructor<? extends JComponent> con = null;
                while (true) {
                    try {
                        con = c.getConstructor(ic);
                    }
                    catch (Exception ex) {
                        Class<?> ac;
                        if ((ic = ic.isArray() ? ((ac = ic.getComponentType().getSuperclass()) != null ? Array.newInstance(ac, 1).getClass() : null) : ic.getSuperclass()) != null) continue;
                    }
                    break;
                }
                if (con == null) {
                    System.err.println("can't find constructor for " + c + " / " + o);
                    return null;
                }
                com = con.newInstance(o);
            }
            final JComponent com2 = com;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    showpan.show(com2, args);
                }
            });
            register.addargs(com, o);
            return com;
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
            return null;
        }
    }

    public static void addpanmenu(final JComponent c) {
        new jcmMenu(c, new menuFiller(){

            public void fillMenu(jcmMenu pop) {
                if (c instanceof jcmTabbedPane) {
                    pop.add(new jcmAction("Convert to Internal Frames"){

                        public void act() {
                            JDesktopPane jdp = showpan.makejdp();
                            JSplitPane jsp = (JSplitPane)c.getParent();
                            jcmTabbedPane jtp = (jcmTabbedPane)c;
                            if (jsp.getTopComponent() == c) {
                                jsp.setTopComponent(jdp);
                            } else {
                                jsp.setBottomComponent(jdp);
                            }
                            mf.validate();
                            int i = 0;
                            while (i < jtp.getTabCount()) {
                                showpan.show((JComponent)jtp.getComponentAt(i), jdp, jtp.getIconAt(i), jtp.getTitleAt(i));
                            }
                        }
                    });
                }
                if (c instanceof JDesktopPane) {
                    pop.add(new jcmAction("Convert to Tabbed Pane"){

                        public void act() {
                            jcmTabbedPane jtp = new jcmTabbedPane();
                            JSplitPane jsp = (JSplitPane)c.getParent();
                            if (jsp.getTopComponent() == c) {
                                jsp.setTopComponent(jtp);
                            } else {
                                jsp.setBottomComponent(jtp);
                            }
                            mf.validate();
                            for (JInternalFrame jif : ((JDesktopPane)c).getAllFrames()) {
                                showpan.show((JComponent)jif.getContentPane(), jtp, jif.getFrameIcon(), jif.getTitle());
                                jif.dispose();
                            }
                        }
                    });
                }
                pop.add(new jcmAction("Remove Panel"){

                    public void act() {
                        JSplitPane jsp = (JSplitPane)c.getParent();
                        JSplitPane jsp2 = (JSplitPane)jsp.getParent();
                        JComponent other = (JComponent)(jsp.getTopComponent() == c ? jsp.getBottomComponent() : jsp.getTopComponent());
                        if (jsp2.getTopComponent() == jsp) {
                            jsp2.setTopComponent(other);
                        } else {
                            jsp2.setBottomComponent(other);
                        }
                    }
                });
                pop.add(new jcmAction("Split Vertical"){

                    public void act() {
                        showpan.split(c, true);
                    }
                });
                pop.add(new jcmAction("Split Horizontal"){

                    public void act() {
                        showpan.split(c, false);
                    }
                });
            }
        });
    }

    static JComponent split(JComponent c, boolean vertical) {
        JSplitPane jsp = (JSplitPane)c.getParent();
        JSplitPane jspn = new JSplitPane(vertical ? 0 : 1);
        jspn.setResizeWeight(0.5);
        jcmTabbedPane jtpn = new jcmTabbedPane();
        if (jsp.getTopComponent() == c) {
            jsp.setTopComponent(jspn);
        } else {
            jsp.setBottomComponent(jspn);
        }
        jspn.setTopComponent(c);
        jspn.setBottomComponent(jtpn);
        return jtpn;
    }

    public static void addwindow(JComponent c) {
        showpan.addwindow(c, new Point(200, 200));
    }

    public static void addwindow(JComponent c, Point p) {
        JLayeredPane lp = mf.getLayeredPane();
        lp.add(c);
        lp.setLayer(c, JLayeredPane.POPUP_LAYER);
        c.setLocation(p);
    }

    public static void topwindow(Window w, JComponent c, Point p) {
        Rectangle cap = new Rectangle(p.x, p.y, c.getSize().width + 10, c.getSize().height + 10);
        capwin win = new capwin(w, cap);
        win.add(c);
        try {
            win.setAlwaysOnTop(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        win.setLocation(p);
        win.pack();
        win.setVisible(true);
    }

    static {
        moulist = new moulist();
        mb = new JMenuBar();
        bg = new Color(217, 255, 217);
    }
}

