/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import jcm.core.infob;
import jcm.core.param;
import jcm.core.qtset;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.nav.showpan;
import jcm.gui.plot.lineplot;

public class moulist
implements MouseListener,
MouseMotionListener {
    JComponent source;
    public Object carrying;
    String dragname;
    Icon dragicon;
    int x;
    int y;
    int oldx = 0;
    int oldy = 0;
    int w;
    int h;
    int iw;
    int ih;
    Point p;
    Point rp;
    boolean inside;
    boolean maysplit;
    public Map<Component, infob> cimap = new WeakHashMap<Component, infob>();

    void getAbsLocation(MouseEvent e) {
        this.source = (JComponent)e.getComponent();
        this.p = this.source.getLocationOnScreen();
        this.rp = showpan.mf.getRootPane().getLocationOnScreen();
        this.x = this.p.x - this.rp.x + e.getX() - 10;
        this.y = this.p.y - this.rp.y + e.getY() - 10;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.inside = this.source.contains(e.getPoint()) && (!(this.source instanceof JInternalFrame) || !((JInternalFrame)this.source).getRootPane().getContentPane().contains(e.getPoint()));
        this.maysplit = this.inside && this.source instanceof jcmTabbedPane && ((jcmTabbedPane)this.source).intab(e) < 0;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.carrying != null && this.dragicon != null) {
            this.getAbsLocation(e);
            int iw = this.dragicon.getIconWidth();
            int ih = this.dragicon.getIconHeight();
            Graphics g = showpan.mf.getRootPane().getGlassPane().getGraphics();
            g.setColor(this.maysplit && e.getY() < this.h / 2 ? Color.red : Color.white);
            g.drawLine(this.p.x - this.rp.x + this.w / 2, this.p.y - this.rp.y, this.p.x - this.rp.x + this.w / 2, this.p.y - this.rp.y + this.h);
            g.setColor(this.maysplit && e.getY() >= this.h / 2 ? Color.red : Color.white);
            g.drawLine(this.p.x - this.rp.x, this.p.y - this.rp.y + this.h / 2, this.p.x - this.rp.x + this.w, this.p.y - this.rp.y + this.h / 2);
            g.setClip(this.oldx, this.oldy, iw, ih);
            showpan.mf.getRootPane().paint(g);
            g.setClip(this.x, this.y, iw, ih);
            this.dragicon.paintIcon(showpan.mf.getRootPane().getGlassPane(), g, this.x, this.y);
            this.oldx = this.x;
            this.oldy = this.y;
            g.dispose();
        }
    }

    public void mousePressed(MouseEvent e) {
        jcmTabbedPane jtp;
        int i;
        this.getAbsLocation(e);
        if (this.cimap.get(this.source) != null && !(this.source instanceof paramValueChooser.jcmslider)) {
            infob io = this.cimap.get(this.source);
            this.dragicon = io.getIcon();
            this.dragname = io.getName();
            this.carrying = io;
        }
        if (this.source instanceof JTree) {
            JTree tree = (JTree)this.source;
            TreePath tp = tree.getClosestPathForLocation(e.getX(), e.getY());
            if (tp == null) {
                return;
            }
            Object o = tp.getLastPathComponent();
            if (o instanceof infob && !(o instanceof param)) {
                infob io = (infob)o;
                this.dragicon = io.getIcon();
                this.dragname = io.getName();
                this.carrying = io;
            }
        }
        if (this.source instanceof jcmTabbedPane && (i = (jtp = (jcmTabbedPane)this.source).intab(e)) >= 0) {
            this.carrying = (JComponent)jtp.getComponentAt(i);
            this.dragicon = jtp.getIconAt(i);
            this.dragname = jtp.getTitleAt(i);
        }
        if (this.source instanceof JInternalFrame) {
            System.err.println("MousePressed JIF");
            if (this.inside) {
                this.carrying = (JComponent)((JInternalFrame)this.source).getContentPane();
                this.dragicon = ((JInternalFrame)this.source).getFrameIcon();
            }
        }
        if (this.carrying != null) {
            showpan.mf.getRootPane().getGlassPane().setVisible(true);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.getAbsLocation(e);
        if (this.source instanceof jcmTabbedPane) {
            ((jcmTabbedPane)this.source).tryclose(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.getAbsLocation(e);
        showpan.mf.getRootPane().getGlassPane().setVisible(false);
        if (this.carrying != null) {
            if (this.maysplit) {
                this.drop(showpan.split(this.source, e.getY() > this.h / 2));
            } else if (!this.inside) {
                if (!showpan.mf.contains(new Point(this.x, this.y))) {
                    JFrame f = new JFrame(this.dragname);
                    f.setLocation(new Point(this.p.x + e.getX(), this.p.y + e.getY()));
                    this.drop(f);
                } else {
                    this.drop(showpan.findContainer(new Point(this.x, this.y)));
                }
            }
            this.carrying = null;
            this.source = null;
        }
    }

    void drop(Container dest) {
        if (this.carrying != null) {
            if (this.carrying instanceof JComponent) {
                if (this.source != null) {
                    this.source.remove((JComponent)this.carrying);
                }
                showpan.show((JComponent)this.carrying, dest, this.dragicon, this.dragname);
            } else if (this.carrying instanceof qtset) {
                showpan.makepan(lineplot.class, this.carrying, dest, this.dragicon, this.dragname);
            } else if (this.carrying instanceof infob) {
                showpan.makepan(jcmTree.class, new Object[]{"[" + this.carrying + "]"}, dest, this.dragicon, this.dragname);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

