/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;

public class jcmTabbedPane
extends JTabbedPane {
    List<Rectangle> rect = new LinkedList<Rectangle>();
    JSplitPane jsp;

    public jcmTabbedPane() {
        this.setPreferredSize(new Dimension(100, 200));
        this.addMouseListener(showpan.moulist);
        this.addMouseMotionListener(showpan.moulist);
        this.setOpaque(false);
        this.setFont(colfont.bigfont);
        showpan.addpanmenu(this);
    }

    public void doLayout() {
        try {
            super.doLayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(Component c) {
        super.remove(c);
        try {
            c.removeNotify();
        }
        catch (Exception e) {
            System.err.println(e + " removing tabbed pane");
        }
        c = null;
    }

    public void paintComponent(Graphics g) {
        try {
            lookandfeel.setAntiAlias(g);
            super.paintComponent(g);
            this.rect.clear();
            for (int i = 0; i < this.getTabCount(); ++i) {
                Rectangle r = this.getUI().getTabBounds(this, i);
                int w = 8;
                int h = 8;
                int x = r.x + r.width - 4 - w;
                int y = r.y + r.height / 2 - h / 2;
                this.rect.add(new Rectangle(x, y, w, h));
                g.setColor(Color.red);
                g.drawRect(x, y, w, h);
                g.drawLine(x + w, y, x, y + h);
                g.drawLine(x, y, x + w, y + h);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int intab(MouseEvent e) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getUI().getTabBounds(this, i).contains(e.getPoint())) continue;
            return i;
        }
        return -1;
    }

    void tryclose(MouseEvent e) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.rect.get(i).contains(e.getPoint())) continue;
            this.remove(i);
        }
    }
}

