/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import jcm.core.complexity;
import jcm.core.param;
import jcm.core.register;
import jcm.core.setup;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;
import jcm.gui.gen.themes;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.showpan;
import jcm.gui.nav.topMenus;

public class lookandfeel {
    static final MetalTheme ocean = MetalLookAndFeel.getCurrentTheme();
    static final MetalTheme metal = new DefaultMetalTheme();
    static UIManager.LookAndFeelInfo systemlf;
    public static boolean isSubstance;
    static String[] SubstanceThemes;
    public static param antiAlias;
    public static param fontSize;
    public static param lookAndFeelParam;
    public static param<String> themeparam;

    public static void setAntiAlias(Graphics g) {
        if (antiAlias.istrue()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    static void setlf(UIManager.LookAndFeelInfo lfi) {
        if (lfi != null) {
            if (lfi.getName().startsWith("Metal")) {
                MetalLookAndFeel.setCurrentTheme(metal);
            }
            if (lfi.getName() == "Ocean") {
                MetalLookAndFeel.setCurrentTheme(ocean);
            }
            lookandfeel.setlf(lfi.getClassName());
        }
    }

    static void setlf(String classname) {
        try {
            UIManager.setLookAndFeel(classname);
            isSubstance = false;
            try {
                isSubstance = themes.checkIsSubstance();
                if (isSubstance) {
                    themes.removeSearch();
                    try {
                        themes.changetheme((String)lookandfeel.themeparam.chosen);
                    }
                    catch (Exception e) {
                        System.err.println("problem setting theme: " + (String)lookandfeel.themeparam.chosen);
                    }
                }
            }
            catch (Error e) {
                System.err.println("Substance L&F not in class path");
            }
            if (showpan.mf != null) {
                SwingUtilities.updateComponentTreeUI(showpan.mf);
            }
            lookandfeel.thememenu(topMenus.view);
        }
        catch (Exception ex) {
            System.err.println("problem for " + classname + " look & feel: " + ex);
        }
    }

    public static void thememenu(jcmMenu view) {
        if (isSubstance && view != null) {
            if (!view.list.contains(themeparam)) {
                view.list.add(themeparam);
            }
        } else if (view != null) {
            view.list.remove(themeparam);
        }
    }

    static {
        isSubstance = false;
        try {
            String[][] elfs;
            UIManager.installLookAndFeel("Ocean", "javax.swing.plaf.metal.MetalLookAndFeel");
            for (String[] elf : elfs = fileio.loadtab(new File(setup.savedir + File.separator + "lookandfeel.info"), ",")) {
                if (elf.length <= 0) continue;
                UIManager.installLookAndFeel(elf[0], elf[1]);
            }
        }
        catch (Exception ex) {
            System.err.println("look&feel install not complete: ");
            ex.printStackTrace();
        }
        for (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels()) {
            if (!lafi.getClassName().equals(UIManager.getSystemLookAndFeelClassName())) continue;
            systemlf = lafi;
        }
        SubstanceThemes = new String[]{"Aqua", "Barby Pink", "Bottle Green", "Brown", "Charcoal", "Dark Violet", "Ebony", "Light Aqua", "Lime Green", "Olive", "Orange", "Purple", "Raspberry", "Sepia", "Steel Blue", "Sun Glare", "Sunset", "Terracotta"};
        antiAlias = new param(new Object[]{"AntiAlias", true}){

            public void precalc() {
                if (showpan.mf != null) {
                    showpan.mf.repaint();
                }
            }
        };
        fontSize = new param(new Object[]{"FontSize", "", Float.valueOf(12.0f), Float.valueOf(0.0f), Float.valueOf(36.0f), complexity.simplest}){

            public void precalc() {
                colfont.setFontSize(this.val);
                if (showpan.mf != null) {
                    showpan.mf.repaint();
                }
            }
        };
        lookAndFeelParam = new param(new Object[]{"lookandfeelmenu", UIManager.getInstalledLookAndFeels(), systemlf, complexity.simplest}){

            public void precalc() {
                if (this.chosen != null) {
                    lookandfeel.setlf((UIManager.LookAndFeelInfo)this.getchosen());
                }
            }
        };
        themeparam = new param(new Object[]{"SubstanceThemes", SubstanceThemes, "Aqua"}){

            public void precalc() {
                lookAndFeelParam.precalc();
            }
        };
        register.setAlwaysOutput(lookAndFeelParam);
        register.setAlwaysOutput(themeparam);
        register.setAlwaysOutput(antiAlias);
        register.setAlwaysOutput(fontSize);
    }
}

