/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import jcm.core.complexity;
import jcm.core.filter;
import jcm.core.interacob;
import jcm.core.itf.plotlink;
import jcm.core.jcmAction;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.core.register;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.menuFiller;
import jcm.gui.nav.showpan;

public class interacmap
extends JPanel
implements Runnable,
plotlink {
    Map<interacob, node> map = new HashMap<interacob, node>();
    Set<node> vis = new HashSet<node>();
    Set<filter.filtertype> filters = new HashSet<filter.filtertype>(Arrays.asList(filter.filtertype.NeededParams, filter.filtertype.Curves, filter.filtertype.Maps));
    int z = 1000;
    int z2 = 1000;
    float edgepushfac = 1000.0f;
    int nstep = 0;
    int w;
    int h;
    int cx = 0;
    int cy = 0;
    int initrun = 0;
    int initsteps = 1000;
    int minlev = 1;
    boolean running = false;
    boolean painting = false;
    node centre = new node();
    node zoomcentre = new node();
    node closest = null;
    node focus = null;
    node lastfocus = null;
    JMenuBar mb;
    static Font bold = new Font("Arial", 1, 12);
    static Font plain = new Font("Arial", 0, 9);
    static Font italic = new Font("Arial", 2, 9);
    static interacmap cfc;
    Thread mythread;
    param level = complexity.defaultcomplexity;
    float pullfac = 0.1f;
    float pushfac = 1000.0f;
    float avdistcentre;
    float avd;

    public interacmap() {
        this((interacob)null);
    }

    public interacmap(interacob fi) {
        this.setName("JCM Interactions");
        intmap ip = new intmap();
        if (fi != null) {
            this.focus = new node(fi);
        }
        cfc = this;
        this.mb = new JMenuBar();
        this.setCursor(new Cursor(13));
        this.setLayout(new BorderLayout());
        this.add((Component)ip, "Center");
        this.mb.add(new JButton(new jcmAction("start"){

            public void act() {
                interacmap.this.start();
            }
        }));
        this.mb.add(new JButton(new jcmAction("stop"){

            public void act() {
                interacmap.this.running = false;
            }
        }));
        this.mb.add(new JButton(new jcmAction("step"){

            public void act() {
                interacmap.this.step(true);
                interacmap.this.repaint();
            }
        }));
        this.mb.add(new JButton(new jcmAction("loop-go"){

            public void act() {
                loop.gonow(false);
            }
        }));
        this.mb.add(filter.getToolBar(this.filters, this, this.level));
        this.add((Component)this.mb, "North");
        loop.gonow(false);
        this.start();
        register.addlink(this, this.level);
    }

    public void removeNotify() {
        this.running = false;
        if (cfc == this) {
            cfc = null;
        }
    }

    public void hide() {
        if (cfc == this) {
            cfc = null;
        }
        super.hide();
    }

    public void show() {
        cfc = this;
        super.show();
    }

    public void doplot() {
        this.step(true);
        this.repaint();
    }

    public static void reset() {
        if (cfc != null) {
            System.out.println("reset flowchart");
            interacmap.cfc.running = false;
            cfc.setup();
            cfc.step(true);
            cfc.repaint();
            for (node n : interacmap.cfc.map.values()) {
                n.setlevel();
            }
        }
    }

    public void setup() {
        for (interacob i : register.alliobs) {
            if (!this.map.containsKey(i)) {
                this.map.put(i, new node(i));
            }
            this.map.get(i).setnc();
        }
        Iterator<interacob> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            interacob i;
            i = it.next();
            if (i != null && !i.disposed) continue;
            it.remove();
        }
    }

    public void start() {
        this.running = true;
        this.mythread = new Thread(cfc);
        this.mythread.setPriority(1);
        this.mythread.start();
    }

    public void run() {
        while (this.running) {
            this.step(true);
            Thread.currentThread();
            Thread.yield();
            ++this.nstep;
            this.nstep %= 50;
            if (this.nstep == 0 && this.isShowing()) {
                this.repaint();
            }
            if (this.initrun == this.initsteps) {
                this.running = false;
            }
            if (this.initrun > this.initsteps) continue;
            ++this.initrun;
        }
    }

    void step(boolean random) {
        if (Thread.currentThread() == this.mythread && this.painting) {
            interacmap interacmap2 = this;
            interacmap2.mythread.yield();
        }
        loop.waitUntilLoopDone();
        this.vis.clear();
        for (node n : this.map.values()) {
            if (n.lev <= this.minlev) continue;
            this.vis.add(n);
        }
        if (random) {
            for (node n : this.vis) {
                n.random((50 - this.nstep) / 10);
            }
        }
        for (node n : this.vis) {
            n.cgx = 0.0f;
            n.cgy = 0.0f;
            n.cj = 0;
        }
        for (node n : this.vis) {
            for (interacob i : n.i.vaffectedby) {
                node m = this.map.get(i);
                if (m == null || m.lev <= this.minlev) continue;
                n.cgx += m.x;
                n.cgy += m.y;
                ++n.cj;
                m.cgx += n.x;
                m.cgy += n.y;
                ++m.cj;
            }
        }
        for (node n : this.vis) {
            if (n.cj <= 0) continue;
            n.x += (n.cgx / (float)n.cj - n.x) / 2.0f;
            n.y += (n.cgy / (float)n.cj - n.y) / 2.0f;
        }
        float cgx = 0.0f;
        float cgy = 0.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        for (node n : this.vis) {
            cgx += n.x;
            cgy += n.y;
        }
        dx = this.centre.x - cgx / (float)this.vis.size();
        dy = this.centre.y - cgy / (float)this.vis.size();
        for (node n : this.vis) {
            n.x += dx;
            n.y += dy;
        }
        for (node n : this.vis) {
            n.x += (this.centre.x - n.x) / 80.0f;
            n.y += (this.centre.y - n.y) / 80.0f;
        }
        for (node n : this.vis) {
            n.dx = 0.0f;
            n.dy = 0.0f;
            n.done = false;
        }
        for (node n : this.vis) {
            n.done = true;
            for (node m : this.vis) {
                if (m.done) continue;
                n.push(m, n.lev * m.lev);
            }
        }
        this.avd = 0.0f;
        for (node n : this.vis) {
            this.avd = (float)((double)this.avd + Math.sqrt(n.dx * n.dx + n.dy * n.dy));
        }
        this.avd /= (float)this.vis.size();
        this.pushfac = 50.0f / this.avd;
        if (this.avd > 0.0f) {
            for (node n : this.vis) {
                n.move(this.pushfac);
            }
        }
    }

    class node {
        float dx;
        float dy;
        float cgx = 0.0f;
        float cgy = 0.0f;
        int cj = 0;
        float x;
        float y;
        interacob i;
        int lev = 1;
        boolean output = false;
        boolean needed = false;
        boolean changed = false;
        boolean done = false;

        node(interacob i) {
            this.i = i;
            this.x = (float)interacmap.this.z * (float)Math.random();
            this.y = (float)interacmap.this.z * (float)Math.random();
            this.dx = 0.0f;
            this.dy = 0.0f;
        }

        node() {
            this.x = interacmap.this.z / 2;
            this.y = interacmap.this.z / 2;
            this.dx = 0.0f;
            this.dy = 0.0f;
        }

        void setnc() {
            this.output = this.i.output;
            this.needed = this.i.needed;
            this.changed = this.i.changed;
        }

        Color getColor() {
            return this.output ? (this.changed ? colfont.purple : colfont.red) : (this.needed ? (this.changed ? colfont.blue : colfont.green) : (this.changed ? colfont.ltblue : colfont.grey));
        }

        Color getColorTo(node to) {
            return to.needed ? (this.changed ? colfont.blue : colfont.green) : (this.changed ? colfont.ltblue : colfont.grey);
        }

        int px() {
            return interacmap.this.cx + (int)((this.x - interacmap.this.zoomcentre.x) * (float)interacmap.this.w / (float)interacmap.this.z2);
        }

        int py() {
            return interacmap.this.cy + (int)((this.y - interacmap.this.zoomcentre.y) * (float)interacmap.this.h / (float)interacmap.this.z2);
        }

        void move(int px, int py) {
            this.x = interacmap.this.zoomcentre.x + (float)((px - interacmap.this.cx) * interacmap.this.z2 / interacmap.this.w);
            this.y = interacmap.this.zoomcentre.y + (float)((py - interacmap.this.cy) * interacmap.this.z2 / interacmap.this.h);
        }

        float dist(node m) {
            return (float)Math.sqrt((m.x - this.x) * (m.x - this.x) + (m.y - this.y) * (m.y - this.y));
        }

        void setlevel() {
            block8: {
                boolean include;
                boolean bl = include = this.i.checkcomplexity() && this.i.checkenabled(interacmap.this.filters);
                if (!(include |= register.checkneededforplotexcept(this.i, jcmTree.class))) {
                    this.lev = 0;
                    return;
                }
                int n = this.lev = this.i instanceof module ? 3 : 1;
                if (interacmap.this.focus != null) {
                    if (this == interacmap.this.focus) {
                        this.lev += 4;
                    } else if (this.i.affectedby(interacmap.this.focus.i) || this.i.affects(interacmap.this.focus.i)) {
                        this.lev += 2;
                    } else {
                        for (interacob ii : this.i.vaffectedby) {
                            if (!ii.affectedby(interacmap.this.focus.i) && !ii.affects(interacmap.this.focus.i)) continue;
                            ++this.lev;
                            break block8;
                        }
                        for (interacob ii : this.i.vaffects) {
                            if (!ii.affectedby(interacmap.this.focus.i) && !ii.affects(interacmap.this.focus.i)) continue;
                            ++this.lev;
                            break;
                        }
                    }
                }
            }
        }

        void random(float f) {
            this.x += (float)((double)f * (Math.random() - 0.5));
            this.y += (float)((double)f * (Math.random() - 0.5));
        }

        void push(node m, float f) {
            float d = (m.x - this.x) * (m.x - this.x) + (m.y - this.y) * (m.y - this.y);
            if (d > 1.0f) {
                this.dx -= f / d * (m.x - this.x);
                m.dx += f / d * (m.x - this.x);
                this.dy -= f / d * (m.y - this.y);
                m.dy += f / d * (m.y - this.y);
            } else {
                this.dx -= f;
                m.dx += f;
                this.dy -= f;
                m.dy += f;
            }
        }

        void move(float f) {
            this.x += f * this.dx;
            this.y += f * this.dy;
        }
    }

    public class intmap
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    menuFiller {
        Component added = null;

        public intmap() {
            this.setBackground(Color.white);
            this.setPreferredSize(new Dimension(600, 600));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            new jcmMenu(this);
            this.setLayout(null);
        }

        public void setfocus(node n) {
            interacmap.this.focus = interacmap.this.focus == n ? null : n;
            for (int i = 0; i < 5; ++i) {
                interacmap.this.step(false);
            }
            this.repaint();
            for (node n2 : interacmap.cfc.map.values()) {
                n2.setlevel();
            }
        }

        public void paintComponent(Graphics g) {
            lookandfeel.setAntiAlias(g);
            interacmap.this.w = this.getSize().width;
            interacmap.this.h = this.getSize().height;
            if (interacmap.this.cx == 0) {
                interacmap.this.cx = interacmap.this.w / 2;
                interacmap.this.cy = interacmap.this.h / 2;
            }
            super.paintComponent(g);
            interacmap.this.painting = true;
            interacmap.this.vis.clear();
            for (node n : interacmap.this.map.values()) {
                if (n.lev <= interacmap.this.minlev) continue;
                interacmap.this.vis.add(n);
            }
            for (node n : interacmap.this.vis) {
                for (interacob i : n.i.vaffectedby) {
                    int dy;
                    int dx;
                    int dl;
                    node m = interacmap.this.map.get(i);
                    if (m == null || m.lev <= interacmap.this.minlev || (dl = (int)Math.sqrt((dx = m.px() - n.px()) * dx + (dy = m.py() - n.py()) * dy)) <= 0) continue;
                    int onx = n.lev * dy / dl;
                    int ony = -n.lev * dx / dl;
                    int omx = m.lev * dy / dl;
                    int omy = -m.lev * dx / dl;
                    Polygon p1 = new Polygon();
                    p1.addPoint(onx + n.px(), ony + n.py());
                    p1.addPoint(-onx + n.px(), -ony + n.py());
                    p1.addPoint(-omx + m.px(), -omy + m.py());
                    p1.addPoint(omx + m.px(), omy + m.py());
                    g.setColor(colfont.yellow);
                    g.fillPolygon(p1);
                    Polygon p2 = new Polygon();
                    p2.addPoint(n.px(), n.py());
                    if (n.i.affects(m.i)) {
                        p2.addPoint((m.px() + n.px() + omx + onx) / 2, (m.py() + n.py() + omy + ony) / 2);
                        p2.addPoint(m.px(), m.py());
                        p2.addPoint((m.px() + n.px() - omx - onx) / 2, (m.py() + n.py() - omy - ony) / 2);
                    } else {
                        p2.addPoint(omx + m.px(), omy + m.py());
                        p2.addPoint(-omx + m.px(), -omy + m.py());
                    }
                    g.setColor(m.getColorTo(n).brighter());
                    g.fillPolygon(p2);
                }
            }
            for (node n : interacmap.this.vis) {
                Icon i;
                if (n.lev > interacmap.this.minlev + 1 && (i = n.i.getIcon()) != null) {
                    i.paintIcon(this, g, n.px() - 10, n.py() - 10);
                }
                String s = labman.getShort(n.i.name);
                if (n.i instanceof module) {
                    s = ((module)n.i).order + " " + s;
                }
                if (n.i.timespent != 0L) {
                    s = s + " " + n.i.timespent;
                }
                g.setFont(new Font("Arial", 0, n.lev * 2 + 6));
                g.setColor(n.getColor().darker());
                g.drawString(s, n.px() + (n.lev > interacmap.this.minlev + 1 ? 20 : 2), n.py() + 3 + n.lev);
            }
            interacmap.this.painting = false;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.added != null) {
                interacmap.this.mb.remove(this.added);
                this.added = null;
            }
            if (interacmap.this.closest != null) {
                this.added = interacmap.this.closest.i.getComponent(new Object[0]);
                interacmap.this.mb.add(this.added);
                interacmap.this.mb.revalidate();
                interacmap.this.mb.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
            double cdist = 20.0;
            interacmap.this.closest = null;
            for (node n : interacmap.this.vis) {
                double dist = Math.sqrt((e.getX() - n.px()) * (e.getX() - n.px()) + (e.getY() - n.py()) * (e.getY() - n.py()));
                if (!(dist < cdist)) continue;
                cdist = dist;
                interacmap.this.closest = n;
            }
            interacmap.this.zoomcentre.move(e.getX(), e.getY());
            interacmap.this.cx = e.getX();
            interacmap.this.cy = e.getY();
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (interacmap.this.closest != null) {
                interacmap.this.closest.move(e.getX(), e.getY());
            } else {
                interacmap.this.cx = e.getX();
                interacmap.this.cy = e.getY();
            }
            interacmap.this.step(false);
            this.repaint();
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            interacmap.this.z2 = (int)((float)interacmap.this.z2 * (1.0f + (float)e.getWheelRotation() * 0.05f));
            this.repaint();
        }

        public void fillMenu(jcmMenu p) {
            if (interacmap.this.closest != null) {
                p.add(new jcmAction(interacmap.this.focus == interacmap.this.closest ? "de-Focus" : "Focus on &" + interacmap.this.closest.i.name){

                    public void act() {
                        intmap.this.setfocus(interacmap.this.closest);
                    }
                });
                interacmap.this.closest.i.fillMenu(p);
            } else {
                p.add(showpan.pan(docview.class, "interacmap"));
                p.add(imagesaver.copyaction(this));
                p.add(imagesaver.saveimagemenu(this, "JCM-Interactions"));
            }
        }
    }
}

