/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.doc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jcm.core.complexity;
import jcm.core.jcmAction;
import jcm.core.param;
import jcm.core.register;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.label;
import jcm.gui.gen.processdialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class labman {
    private static Map<String, label> ldm = new TreeMap<String, label>();
    static Map<label.langcode, Set<String>> loaded = new EnumMap<label.langcode, Set<String>>(label.langcode.class);
    public static Set<String> category = new HashSet<String>();
    static int sy = 1;
    public static param<label.langcode> language = new param(new Object[]{"languagemenu", label.langcode.values(), label.langcode.en, complexity.simplest});
    public static boolean recordchanged = false;
    public static Action loadchangesaction;
    public static Action savechangesaction;
    public static Action savecopyaction;
    public static File defaultstore;
    static Comparator<label> labcomp;
    static String meta;
    static String style;
    static String extlink;
    static String[] opencat;
    static String[] closecat;
    static String[] openkey;
    static String[] closekey;
    static String[] closeentry;
    static String[] filesuffix;
    static String[] head;
    static String[] foot;
    public static param<label.langcode> currentlangchooser;
    public static String searchstring;
    public static boolean anywords;
    public static boolean titlesonly;

    public static void saveonexit() {
        labman.savedoc(defaultstore, true);
    }

    public static void loaddefaultchanges() {
        try {
            if (defaultstore.exists() && defaultstore.isDirectory() && defaultstore.listFiles().length > 0) {
                labman.loadFromDirectory(defaultstore);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadFromDirectory(File f) {
        labman.loadFromJar(label.langcode.en, "");
        if (f.isDirectory()) {
            System.err.println("Updating labels from " + f);
            for (File ff : f.listFiles()) {
                labman.loadFromDirectory(ff);
            }
        } else {
            try {
                String fn = f.getName();
                int a = fn.indexOf("_");
                int b = fn.lastIndexOf("_");
                String cat2 = a == b ? "" : fn.substring(a + 1, b);
                label.langcode lang = label.langcode.valueOf(fn.substring(b + 1, b + 3));
                if (lang == null) {
                    System.err.println("couldn't identify language of " + fn);
                }
                labman.loadFromJar(lang, cat2);
                labman.interpret(fileio.loadstring(f, "UTF8"), lang, cat2);
            }
            catch (Exception e) {
                System.err.println("couldn't load file " + f);
                e.printStackTrace();
            }
        }
    }

    public static void loadAllJarWithDialog() {
        new processdialog("Loading Labels", new JLabel("Please  wait while loading labels"), new Runnable(){

            public void run() {
                labman.loadAllJar();
            }
        });
    }

    public static void loadAllJar() {
        for (label.langcode lang : label.langcode.values()) {
            labman.loadFromJar(lang, "");
            for (String cat2 : category) {
                labman.loadFromJar(lang, cat2);
            }
        }
    }

    public static void loadFromJar(label.langcode lang, String cat2) {
        if (loaded.get((Object)lang) == null) {
            loaded.put(lang, new HashSet());
        } else if (loaded.get((Object)lang).contains(cat2)) {
            return;
        }
        loaded.get((Object)lang).add(cat2);
        String filename = cat2 == "" ? "lab" : "doc_" + cat2;
        String ls = lang == label.langcode.it ? fileio.loadstring("labdoc/" + filename + "_" + (Object)((Object)lang) + ".txt") : fileio.loadstring("labdoc/" + filename + "_" + (Object)((Object)lang) + ".txt", "UTF8");
        recordchanged = false;
        labman.interpret(ls, lang, cat2);
        recordchanged = true;
    }

    static void interpret(String ls, label.langcode lang, String cat2) {
        if (ls.length() < 1) {
            return;
        }
        System.err.println("Loading Labels " + (Object)((Object)lang) + " " + cat2);
        String[] items = txt.split(ls, "#");
        category.add(cat2);
        int nt = label.smd.values().length;
        int[] split = new int[nt + 1];
        for (String item : items) {
            try {
                String key;
                if (item.indexOf("===>") >= 0) {
                    cat2 = item.substring(item.indexOf("===>") + 4, item.indexOf("<===")).trim();
                    category.add(cat2);
                    key = "";
                } else {
                    key = labman.convertkey(txt.tonextspace(item, 0));
                }
                label lab = ldm.get(key);
                if (lab == null) {
                    if (lang != label.langcode.en) {
                        System.err.println((Object)((Object)lang) + " added " + key);
                    }
                    lab = new label(key, cat2);
                    ldm.put(key, lab);
                }
                if (lab.cat != cat2) {
                    lab.cat = cat2;
                }
                for (label.smd t : label.smd.values()) {
                    split[t.ordinal()] = item.indexOf(t.getcode());
                }
                split[nt] = item.length();
                for (int j = nt - 1; j >= 0; --j) {
                    if (split[j] == -1 || split[j] >= split[j + 1]) {
                        split[j] = split[j + 1];
                        continue;
                    }
                    String dat = item.substring(split[j] + 1, split[j + 1]).trim();
                    if (j == 0) {
                        if (lang == label.langcode.en) {
                            lab.set(lang, label.smd.i, dat);
                        }
                    }
                    if (j == 1) {
                        lab.set(lang, label.smd.s, dat);
                    }
                    if (j == 2) {
                        lab.set(lang, label.smd.m, dat);
                    }
                    if (j == 3) {
                        lab.set(lang, label.smd.d, autodoc.convertold(dat));
                    }
                    if (j != 4) continue;
                    lab.icon = dat;
                }
            }
            catch (Exception e) {
                System.err.println("Problem parsing " + item);
            }
        }
        System.gc();
    }

    public static void savedoc(File f, boolean filterchanged) {
        ArrayList<label> savelist = new ArrayList<label>(ldm.values());
        Collections.sort(savelist, labcomp);
        EnumSet<label.langcode> langs = EnumSet.complementOf(EnumSet.of(label.langcode.sc));
        String oldcat = "dummy";
        EnumMap docsb = new EnumMap(label.langcode.class);
        for (label.langcode l : langs) {
            if (l == label.langcode.sc) continue;
            docsb.put(l, new HashMap());
            for (String c : category) {
                ((Map)docsb.get((Object)l)).put(c, new StringBuffer());
            }
        }
        EnumSet<label.langcode> newcat = EnumSet.noneOf(label.langcode.class);
        for (label lab : savelist) {
            if (!oldcat.equals(lab.cat)) {
                oldcat = lab.cat;
                for (label.langcode l : langs) {
                    newcat.add(l);
                }
            }
            String newcathead = opencat[sy] + lab.cat + closecat[sy];
            String ikso = openkey[sy] + labman.ntb(lab.key) + closekey[sy];
            for (label.langcode l : langs) {
                String iks = ikso + lab.savetext(l, label.smd.i, sy);
                if (!(filterchanged && lab.getchanged(l, label.smd.s) <= 0L && lab.getchanged(l, label.smd.m) <= 0L || l != label.langcode.en && lab.getorig(l, label.smd.s) == null && lab.getorig(l, label.smd.m) == null)) {
                    if (newcat.contains((Object)l)) {
                        ((StringBuffer)((Map)docsb.get((Object)l)).get("")).append(newcathead);
                        newcat.remove((Object)l);
                    }
                    ((StringBuffer)((Map)docsb.get((Object)l)).get("")).append("\n" + iks + lab.savetext(l, label.smd.s, sy) + lab.savetext(l, label.smd.m, sy) + closeentry[sy]);
                }
                if (filterchanged && lab.getchanged(l, label.smd.d) <= 0L || lab.getorig(l, label.smd.d) == null) continue;
                ((StringBuffer)((Map)docsb.get((Object)l)).get(lab.cat)).append("\n\n" + iks + lab.savetext(l, label.smd.d, sy) + closeentry[sy]);
            }
        }
        if (!f.exists()) {
            f.mkdir();
        }
        for (String c : category) {
            for (label.langcode l : langs) {
                if (((StringBuffer)((Map)docsb.get((Object)l)).get(c)).length() <= 0) continue;
                System.err.println("saving " + (Object)((Object)l) + " " + c);
                fileio.savetextfile(f, (c == "" ? "lab" : "doc_" + c) + "_" + (Object)((Object)l) + filesuffix[sy], head[sy] + ((StringBuffer)((Map)docsb.get((Object)l)).get(c)).toString() + foot[sy], "UTF8");
            }
        }
    }

    public static boolean gotLabelForKey(String name) {
        return ldm.containsKey(labman.convertkey(name));
    }

    public static void addLabel(String name, label lab) {
        ldm.put(labman.convertkey(name), lab);
    }

    public static label getLabel(String name) {
        return ldm.get(labman.convertkey(name));
    }

    public static List<label> getLabelList() {
        return new ArrayList<label>(ldm.values());
    }

    public static String convertkey(String name) {
        return name.trim().toLowerCase().replace(" ", "_");
    }

    public static String getShort(String requestkey) {
        return labman.getlabeltext(requestkey, label.smd.s);
    }

    public static String getTitle(String requestkey) {
        return labman.getlabeltext(requestkey, label.smd.m);
    }

    public static String getTitleIfDifferent(String requestkey) {
        String popup = labman.getTitle(requestkey);
        if (!popup.equals(labman.getShort(requestkey)) && !popup.equals(labman.getDoc(requestkey))) {
            return "(" + popup + ") ";
        }
        return "";
    }

    public static String getShortIfDifferent(String requestkey) {
        String popup = labman.getShort(requestkey);
        if (!popup.equals(labman.getTitle(requestkey)) && !popup.equals(labman.getDoc(requestkey))) {
            return "(" + popup + ") ";
        }
        return "";
    }

    public static String getDoc(String requestkey) {
        if (requestkey.equals("doclist")) {
            return labman.doclist();
        }
        if (requestkey.equals("docsearch")) {
            return labman.docsearch();
        }
        return labman.getlabeltext(requestkey, label.smd.d);
    }

    public static String getlabeltext(String requestkey, String typecode) {
        for (label.smd t : label.smd.values()) {
            if (!t.getcode().equals(typecode)) continue;
            return labman.getlabeltext(requestkey, t);
        }
        return labman.getlabeltext(requestkey, label.smd.s);
    }

    public static String getlabeltext(String requestkey, label.smd t) {
        try {
            return labman.getlabeltext(requestkey, t, (label.langcode)((Object)labman.currentlangchooser.chosen));
        }
        catch (Exception e) {
            return labman.getlabeltext(requestkey, t, label.langcode.en);
        }
    }

    public static String getlabeltext(String requestkey, label.smd t, label.langcode lang) {
        String key = labman.convertkey(requestkey);
        try {
            if (lang == label.langcode.sc && t != label.smd.d) {
                return key;
            }
            if (key == "") {
                return "";
            }
            labman.loadFromJar(label.langcode.en, "");
            labman.loadFromJar(lang, "");
            label lab = ldm.get(key);
            if (lab == null) {
                int split = key.indexOf("&");
                if (split < 0) {
                    return t != label.smd.d ? requestkey.replace("_", " ") : "";
                }
                if (split >= key.length() - 1) {
                    return labman.getlabeltext(key.substring(0, split), t);
                }
                String label1 = labman.getlabeltext(key.substring(0, split), t);
                String label2 = labman.getlabeltext(key.substring(split + 1), t);
                return label1 + (label1.length() > 1 ? " " : "") + label2;
            }
            if (t == label.smd.d) {
                labman.loadFromJar(label.langcode.en, lab.cat);
                labman.loadFromJar(lang, lab.cat);
            }
            return lab.get(lang, t);
        }
        catch (RuntimeException e) {
            System.err.println(" getlabel " + (Object)((Object)t) + " " + key + " : " + e);
            return (t != label.smd.d ? "!" : "can't find ") + key;
        }
    }

    public static String ntb(String s) {
        return s == null ? "" : s;
    }

    public static void search(String s, boolean a, boolean t) {
        searchstring = s;
        anywords = a;
        titlesonly = t;
    }

    public static String docsearch() {
        return labman.searchresults();
    }

    public static String searchbox() {
        return "<form><input id=searchbox type=text size=30 style='font:75%' value='" + searchstring + "'  >" + " <br> @docsearch  \u00a3\u00a7searchresults ";
    }

    public static String searchresults() {
        if (searchstring.equals("")) {
            return "\u00a3\u00a7aboutsearch";
        }
        TreeMap<Float, String> rs = new TreeMap<Float, String>();
        String[] ss = txt.split(searchstring.trim(), " ", true);
        for (label lab : ldm.values()) {
            boolean include = !anywords;
            float score = 1.0f;
            try {
                for (int j = 0; j < ss.length; ++j) {
                    String q = ss[j].toLowerCase();
                    boolean found = false;
                    float score2 = 0.0f;
                    EnumSet<label.langcode> langs = EnumSet.complementOf(EnumSet.of(label.langcode.sc));
                    for (label.smd t : label.smd.values()) {
                        String p;
                        if (t == label.smd.i || titlesonly && t == label.smd.d || (p = (t != label.smd.d ? labman.getlabeltext(lab.key, t) : autodoc.parse(labman.getlabeltext(lab.key, t), register.findiob(lab.key), false)).toLowerCase()).length() <= 0) continue;
                        int r = -1;
                        while ((r = p.indexOf(q, r + 1)) > 0) {
                            found = true;
                            score2 = (float)((double)score2 + 10.0 / Math.pow(1000 + p.length(), 0.33));
                        }
                    }
                    include = anywords ? (include |= found) : (include &= found);
                    score *= score2;
                }
                if (!include) continue;
                rs.put(Float.valueOf(100.0f - score), "<li>(" + (int)score + ") @" + lab.key + " " + labman.getTitleIfDifferent(lab.key));
            }
            catch (RuntimeException e) {
                System.out.println("Search error" + lab.key + ": " + e);
            }
        }
        StringBuffer out = new StringBuffer(" \u00a3\u00a7aboutsearch ==\u00a3`searchresults : " + searchstring + " ==");
        for (String r : rs.values()) {
            out.append(r);
        }
        return out.toString();
    }

    public static String doclist() {
        label.langcode lang = (label.langcode)((Object)labman.language.chosen);
        labman.loadFromJar(lang, "");
        for (String cat2 : category) {
            labman.loadFromJar(lang, cat2);
        }
        TreeSet<String> rs = new TreeSet<String>();
        for (label lab : ldm.values()) {
            try {
                if (lab.key.startsWith("!") || lab.key.equals("doclist") || lab.key.length() <= 1) continue;
                String u = " " + (labman.getTitleIfDifferent(lab.key) != labman.getShort(lab.key) ? labman.getTitleIfDifferent(lab.key) + " " : "");
                rs.add(lab.get(label.langcode.en, label.smd.d) != null ? autodoc.link(lab.key) + u : "\u00b2" + labman.getShort(lab.key) + u + "\u00b2");
            }
            catch (Exception e) {
                System.err.println("doclist problem with key " + lab.key + ": " + e);
            }
        }
        StringBuffer s = new StringBuffer("\u00a3\u00a7doclistinfo ");
        for (String r : rs) {
            if (r == null) continue;
            s.append("<li>" + r);
        }
        return s.toString();
    }

    static {
        register.setAlwaysOutput(language);
        loadchangesaction = new jcmAction("Load"){

            public void act() {
                labman.loadFromDirectory(fileio.getFileFromDialog("", "Choose Directory for Loading LabDoc Changes", "load"));
            }
        };
        savechangesaction = new jcmAction("Save Changes"){

            public void act() {
                labman.savedoc(fileio.getFileFromDialog("", "Choose Directory for Saving LabDoc Changes", "save"), true);
            }
        };
        savecopyaction = new jcmAction("Save All"){

            public void act() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        labman.loadAllJar();
                        labman.savedoc(fileio.getFileFromDialog("", "Choose Directory for Saving LabDoc", "save"), false);
                    }
                });
            }
        };
        defaultstore = new File("labdocchanges");
        labcomp = new Comparator<label>(){

            @Override
            public int compare(label a, label b) {
                return a.fo.compareTo(b.fo);
            }
        };
        meta = "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>";
        style = "<style> cat { color: orange font: bold 120% } dt { color: red} lab { color: brown } pop { color: green  } link { color: blue } note { font: italic 70% } icon, info { color: magenta; font: italic  } </style>";
        extlink = "This is part of the labels / documentation for <a href='http://jcm.chooseclimate.org'>Java Climate Model</a><hr/>";
        opencat = new String[]{"</dl><hr/><dl compact><cat>", "\n\n#! ===>"};
        closecat = new String[]{"</cat>", "<==="};
        openkey = new String[]{"<dt>", "#"};
        closekey = new String[]{"</dt><dd> ", ""};
        closeentry = new String[]{"</dd>", ""};
        filesuffix = new String[]{".html", ".txt"};
        head = new String[]{"<html><head>" + meta + style + "</head><body>" + extlink + "<dl  compact>", extlink};
        foot = new String[]{"</dl></html>", ""};
        currentlangchooser = language;
        searchstring = "";
        anywords = false;
        titlesonly = false;
    }
}

