/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.tls;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import jcm.core.reg.regman;
import jcm.core.register;
import jcm.core.tls.meminfo;
import jcm.core.world;
import jcm.gui.doc.labman;
import jcm.gui.nav.showpan;

public class memoryChecker
implements Runnable {
    static HTMLDocument report;
    static Map<Object, meminfo> allinfo;
    static Queue<meminfo> checkqueue;

    public static void checkall() {
        new Thread(new memoryChecker()).start();
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        Thread.currentThread();
        Thread.yield();
        allinfo.clear();
        System.gc();
        byte[] block = new byte[1000000];
        System.err.println("Checking All Objects");
        memoryChecker.show();
        memoryChecker.report("JCM memory use, starting from world.class");
        memoryChecker.report("<i>beware this process itself uses a lot of memory and prevents memory from being cleared!</i><hr>");
        try {
            meminfo.get(world.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
            meminfo.get(regman.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
            meminfo.get(labman.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
            meminfo.get(register.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
            meminfo.get(showpan.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
        }
        catch (Error e) {
            block = null;
            System.gc();
            e.printStackTrace();
            memoryChecker.report("UNFINISHED DUE TO LACK OF MEMORY <hr>");
        }
        block = null;
        System.err.println("Calc Size");
        for (meminfo i : allinfo.values()) {
            if (i.parent != null) continue;
            i.sublev = 0;
        }
        for (meminfo i : allinfo.values()) {
            i.calcsizesub();
        }
        for (meminfo i : allinfo.values()) {
            if (i.sub == null) continue;
            Collections.sort(i.sub);
        }
        TreeSet<meminfo> initial = new TreeSet<meminfo>();
        for (meminfo i : allinfo.values()) {
            if (i.sublev >= 1 || i.size + i.sizesub <= 0) continue;
            initial.add(i);
        }
        System.err.println("Report");
        for (meminfo i : initial) {
            memoryChecker.report(i.report() + "</div>");
        }
        initial = null;
        System.gc();
    }

    static void report(String s) {
        try {
            report.insertBeforeEnd(report.getDefaultRootElement(), s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void show() {
        JEditorPane jep = new JEditorPane();
        jep.setContentType("text/html;");
        report = (HTMLDocument)jep.getDocument();
        jep.setEditable(false);
        jep.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    memoryChecker.open(e);
                }
            }
        });
        final JFrame mf = new JFrame();
        mf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                mf.dispose();
                report = null;
                allinfo.clear();
                System.gc();
            }
        });
        mf.setSize(800, 800);
        mf.setContentPane(new JScrollPane(jep));
        mf.show();
    }

    static void open(HyperlinkEvent e) {
        System.err.println("open " + e.getDescription());
        String code = e.getDescription();
        meminfo opi = null;
        for (meminfo i : allinfo.values()) {
            if (!code.equals(i.code())) continue;
            opi = i;
            break;
        }
        if (opi == null) {
            System.err.println("Can't find object");
            return;
        }
        try {
            opi.open = !opi.open;
            String s = opi.report();
            if (opi.open && opi.sub != null) {
                for (meminfo i : opi.sub) {
                    if (i.size + i.sizesub <= 0) continue;
                    s = s + i.report() + " </div>";
                }
            }
            s = s + " </div>";
            report.setOuterHTML(report.getElement(code), s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        allinfo = new LinkedHashMap<Object, meminfo>();
        checkqueue = new LinkedList<meminfo>();
    }
}

