/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.tls;

import java.awt.Component;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jcm.core.infob;
import jcm.core.tls.memoryChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class meminfo
implements Comparable<meminfo> {
    boolean inc = false;
    boolean open = false;
    int size = 0;
    int sizesub = 0;
    int sublev = 0;
    String name;
    long created = System.currentTimeMillis();
    Object ob;
    meminfo parent = null;
    List<meminfo> sub = null;

    @Override
    public int compareTo(meminfo i) {
        int z = i.size + i.sizesub - (this.size + this.sizesub);
        if (z == 0) {
            z = 1;
        }
        return z;
    }

    meminfo(String na, Object o, int lev) {
        this.name = na;
        this.ob = o;
        this.sublev = lev;
        memoryChecker.allinfo.put(this.ob, this);
        memoryChecker.checkqueue.add(this);
    }

    static meminfo get(Class c) {
        return meminfo.get("", c, 0);
    }

    static meminfo get(String n, Object o, int lev) {
        if (o == null) {
            return null;
        }
        meminfo i = memoryChecker.allinfo.get(o);
        if (i != null) {
            return i;
        }
        if (o instanceof Class) {
            n = "CLASS:_";
        }
        if (!(o instanceof Class)) {
            meminfo.get(o.getClass());
        }
        return new meminfo(n, o, lev);
    }

    void addob(String n, Object o2) {
        if (o2 == null || o2 == this.ob) {
            return;
        }
        meminfo i = meminfo.get(n, o2, this.sublev + 1);
        if (this.maydescend(i)) {
            if (i.parent != null && i.parent.sub != null) {
                i.parent.sub.remove(i);
            }
            if (this.sub == null) {
                this.sub = new ArrayList<meminfo>(4);
            }
            i.parent = this;
            i.sublev = this.sublev + 1;
            this.sub.add(i);
        }
    }

    int calcsizesub() {
        this.inc = true;
        if (this.sub != null) {
            for (meminfo i : this.sub) {
                if (i.inc || i.parent != this) continue;
                this.sizesub += i.size + i.calcsizesub();
            }
        }
        return this.sizesub;
    }

    boolean maydescend(meminfo i) {
        if (i == null) {
            return false;
        }
        if (i.ob instanceof Class) {
            return false;
        }
        return i.parent == null || i.sublev > this.sublev + 1;
    }

    void check() {
        if (this.ob instanceof Class) {
            this.check((Class)this.ob);
        } else {
            this.check(this.ob.getClass());
        }
    }

    void check(Class c) {
        if (c.isArray()) {
            if (this.ob instanceof Class) {
                return;
            }
            int al = Array.getLength(this.ob);
            Class<?> ac = c.getComponentType();
            if (ac.isPrimitive()) {
                this.size += al * this.primsize(ac);
            } else {
                this.size += al;
                for (int j = 0; j < al; ++j) {
                    Object ao = Array.get(this.ob, j);
                    if (ao == null) continue;
                    this.addob("[" + j + "]", ao);
                }
            }
            return;
        }
        try {
            if (this.ob instanceof Collection) {
                Collection co = (Collection)this.ob;
                int al = co.size();
                this.size += 10 + al * 2;
                int j = 0;
                for (Object coo : co) {
                    if (coo != null) {
                        this.addob("{" + j + "}", coo);
                    }
                    ++j;
                }
                return;
            }
            if (this.ob instanceof Map) {
                Map m = (Map)this.ob;
                int al = m.size();
                this.size += 20 + al * 4;
                int j = 0;
                for (Object mo : m.keySet()) {
                    this.addob("{key" + j + "}", mo);
                    if (m.get(mo) != null) {
                        this.addob("{val" + j + "}", m.get(mo));
                    }
                    ++j;
                }
                return;
            }
        }
        catch (Exception e) {
            System.err.println(e + " in " + this.name);
            return;
        }
        AccessibleObject[] ff = c.getDeclaredFields();
        Field.setAccessible(ff, true);
        for (AccessibleObject f : ff) {
            if (this.ob instanceof Class != Modifier.isStatic(((Field)f).getModifiers())) continue;
            Class<?> fc = ((Field)f).getType();
            if (fc.isPrimitive()) {
                this.size += this.primsize(fc);
                continue;
            }
            try {
                Object fo = ((Field)f).get(this.ob instanceof Class ? null : this.ob);
                ++this.size;
                if (fo == null) continue;
                this.addob(((Field)f).getName() != null ? ((Field)f).getName() : "(anon)", fo);
            }
            catch (Exception e) {
                System.err.println(e + " in " + this.name + " field: " + ((Field)f).getName() + "{" + fc.getName() + "} object:" + this.ob);
            }
        }
        if (c != Object.class) {
            if (this.ob instanceof Class) {
                meminfo.get(c.getSuperclass());
            } else {
                this.check(c.getSuperclass());
            }
        }
    }

    int primsize(Class c) {
        if (c == Boolean.TYPE || c == Byte.TYPE) {
            return 1;
        }
        if (c == Character.TYPE || c == Short.TYPE) {
            return 2;
        }
        if (c == Integer.TYPE || c == Float.TYPE) {
            return 4;
        }
        if (c == Long.TYPE || c == Double.TYPE) {
            return 8;
        }
        return 0;
    }

    String code() {
        if (this.ob instanceof Class) {
            return "#" + ((Class)this.ob).getName();
        }
        return "#" + (this.parent != null ? this.parent.name : "") + "_" + this.name + "_" + this.created;
    }

    String report() {
        String code = this.code();
        Class<?> c = this.ob instanceof Class ? (Class<?>)this.ob : this.ob.getClass();
        String s = " <div id=" + code + "><nobr> ";
        if (this.size + this.sizesub > 1000) {
            s = s + "<b>";
        }
        for (int j = 0; j < this.sublev; ++j) {
            s = s + "--";
        }
        if (this.sub != null && this.sub.size() > 0) {
            s = s + " <a href=" + code + ">[" + (this.open ? "X" : "open") + "]</a> ";
        }
        s = s + " " + this.size + " (" + this.sizesub + ") " + this.name;
        if (this.ob instanceof String) {
            s = s + "\"" + this.ob.toString() + "\"";
        } else {
            s = c.getPackage() != null && c.getPackage().getName().startsWith("jcm") ? s + " {<font color=red>" + c.getName() + "</font>} " : s + " {" + c.getName() + "} ";
            if (this.ob instanceof infob) {
                s = s + "<i>" + ((infob)this.ob).name + "</i>";
            } else if (this.ob instanceof Component) {
                s = s + "<i>" + ((Component)this.ob).getName() + "</i>";
            }
        }
        if (this.size + this.sizesub > 1000) {
            s = s + "</b>";
        }
        return s + " </nobr> ";
    }
}

