/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jcm.core.complexity;
import jcm.core.infob;
import jcm.core.interacob;
import jcm.core.itf.hasSetupInfo;
import jcm.core.jcmAction;
import jcm.core.loop;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.core.register;
import jcm.core.root;
import jcm.core.tls.fileio;
import jcm.core.world;
import jcm.gui.gen.splash;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.showpan;

public class setup {
    public static String savedir = "setup";
    public static String current = "current.txt";
    public static boolean loadcurrent = true;

    public static void fillMenu(jcmMenu setupm) {
        setupm.add(new jcmAction("Reset All Parameters", complexity.simplest){

            public void act() {
                register.resetall();
                loop.gonow();
            }
        });
        setupm.add(new jcmAction("Reset SciMod Parameters"){

            public void act() {
                register.resetallmod();
                loop.gonow();
            }
        });
        jcmMenu stan = new jcmMenu(new Object[]{"Standard Setups"});
        for (infob o : root.rootob.find("defsetup").getObs()) {
            final String s = ((Object)o).toString().substring(9);
            stan.add(new jcmAction(s, complexity.simplest){

                public void act() {
                    setup.loadsetup(fileio.loadtab("defsetup/" + s, "\t"));
                }
            });
        }
        setupm.add(stan);
        setupm.add(new jcmAction("Load Setup"){

            public void act() {
                setup.loadsetupdialog();
            }
        });
        setupm.add(new jcmAction("Save Setup"){

            public void act() {
                setup.savesetupdialog();
            }
        });
    }

    public static boolean loadcurrentsetup() {
        if (loadcurrent && setup.loadsetup(new File(savedir + File.separator + current))) {
            return true;
        }
        return setup.loadsetup(fileio.loadtab("defsetup/default.txt", "\t"));
    }

    static boolean loadsetupdialog() {
        return setup.loadsetup(fileio.getFileFromDialog(showpan.mf, savedir, current, "Load Setup", "load"));
    }

    static boolean loadsetup(File file) {
        try {
            setup.loadsetup(fileio.loadtab(file, "\t"));
        }
        catch (Exception e) {
            System.err.println("cannot find file " + file);
            return false;
        }
        return true;
    }

    static boolean loadsetup(final String[][] list) {
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(){

                public void run() {
                    setup.loadsetup2(list);
                }
            }.start();
            return true;
        }
        return setup.loadsetup2(list);
    }

    static boolean loadsetup2(String[][] list) {
        if (list.length == 0) {
            return false;
        }
        System.err.println("setup start");
        try {
            for (WeakReference<JComponent> wrc : register.winmap.keySet()) {
                if (wrc.get() == null) continue;
                showpan.dispose((JComponent)wrc.get());
            }
        }
        catch (Exception ex) {
            System.err.println("setup dispose error " + ex);
        }
        try {
            while (world.worlds.size() > 0) {
                world.worlds.get(0).disposeWorld(false);
            }
        }
        catch (Exception ex) {
            System.err.println("setup remove old worlds error " + ex);
        }
        jcmTree.restruclink.changed = true;
        complexity.defaultcomplexity.changed = true;
        register.resetall();
        loop.gonow();
        for (final String[] s : list) {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    setup.setup(s);
                    continue;
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        setup.setup(s);
                    }
                });
            }
            catch (Exception ex) {
                String a = "";
                for (String ss : s) {
                    a = a + " _ " + ss;
                }
                System.err.println("setup error " + a + " " + ex);
            }
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                loop.gonow();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        loop.gonow();
                    }
                });
            }
        }
        catch (Exception ex) {
            System.err.println("setup loop go error " + ex);
        }
        System.err.println("setup finished");
        return true;
    }

    static void setup(String[] s) {
        if (s.length == 0) {
            return;
        }
        String all = "setup: ";
        for (String ss : s) {
            all = all + " \t " + ss;
        }
        System.err.println(all);
        splash.report(all);
        try {
            interacob i;
            if (s[0].equals("worlds")) {
                for (int j = 1; j < s.length; ++j) {
                    boolean newworld = true;
                    for (world w : world.worlds) {
                        if (!s[j].equals(w.getName())) continue;
                        newworld = false;
                    }
                    if (!newworld) continue;
                    new world(s[j]);
                }
            }
            if (s[0].equals("param") && (i = register.findiobfullname(s[1])) != null) {
                ((param)i).load(s[2]);
                System.err.println(s[1] + " set to " + s[2]);
                if (showpan.mf != null) {
                    showpan.mf.validate();
                }
            }
            if (s[0].equals("qtset") && (i = register.findiobfullname(s[1])) != null) {
                qtset base = (qtset)register.findiobfullname(s[1]);
                qtset other = s.length > 3 ? (qtset)register.findiobfullname(s[3]) : null;
                qt.Type dty = null;
                for (qt.Type ty : qt.Type.values()) {
                    if (!ty.toString().equals(s[2])) continue;
                    dty = ty;
                }
                if (dty == null) {
                    System.err.println("can't match type " + s[2]);
                } else {
                    base.addnewderiv(dty, other);
                }
            }
            if (s[0].equals("split")) {
                if (showpan.mf == null) {
                    showpan.mainframe();
                }
                setup.applySplit(s, 1, (JSplitPane)showpan.mf.getContentPane());
            }
            if (s[0].equals("window")) {
                Point loc = new Point(Integer.parseInt(s[4]), Integer.parseInt(s[5]));
                Dimension siz = new Dimension(Integer.parseInt(s[2]), Integer.parseInt(s[3]));
                if (s[1].equals("Main")) {
                    if (showpan.mf == null) {
                        showpan.mainframe(siz, loc);
                    } else {
                        setup.setsizeloc(showpan.mf, siz, loc);
                    }
                } else {
                    try {
                        Object[] args;
                        int nargs;
                        if (showpan.mf == null) {
                            showpan.mainframe();
                        }
                        if ((nargs = s.length - 6) > 1) {
                            Object[] args2 = new Object[nargs];
                            for (int a = 0; a < nargs; ++a) {
                                args2[a] = setup.findob(s[6 + a]);
                            }
                            args = args2;
                        } else {
                            args = setup.findob(s[6]);
                        }
                        loc = new Point(loc.x - showpan.mf.getX(), loc.y - showpan.mf.getY());
                        JComponent co = showpan.findContainer(loc);
                        JComponent c = showpan.makepan(Class.forName(s[1]), args, co);
                        c.setPreferredSize(siz);
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("setup window error" + e);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("setup error " + e);
        }
    }

    static Object findob(String s) {
        interacob o = register.findiobfullname(s);
        return o != null ? o : (s.equals("null") ? null : s);
    }

    public static void savesetupdialog() {
        setup.savesetup(fileio.getFileFromDialog(showpan.mf, savedir, current, "Save Setup", "save"));
    }

    public static void savesetupdefault() {
        if (!new File(savedir).isDirectory()) {
            new File(savedir).mkdir();
        }
        setup.savesetup(new File(savedir + File.separator + current));
    }

    public static void savesetup(File file) {
        String list = "";
        list = list + "worlds";
        for (world world2 : world.worlds) {
            list = list + "\t" + world2.getName();
        }
        list = list + "\n";
        for (interacob interacob2 : register.alliobs) {
            if (interacob2 instanceof param && !((param)interacob2).isdefault()) {
                list = list + "param\t" + ((param)interacob2).save();
            }
            if (!(interacob2 instanceof qtset)) continue;
            qtset qq = (qtset)interacob2;
            if (!qq.temporary) continue;
            list = list + "qtset\t" + qq.owner.getFullName() + "\t" + (Object)((Object)qq.type) + (qq.qqb != null ? "\t" + qq.qqb.getFullName() : "") + "\n";
        }
        list = list + "window\tMain" + setup.sizeloc(showpan.mf) + "\n";
        list = list + setup.recordSplit((JSplitPane)showpan.mf.getContentPane()) + "\n";
        for (WeakReference weakReference : register.winmap.keySet()) {
            if (weakReference.get() == null || ((JComponent)weakReference.get()).getParent() == null) continue;
            JComponent c = (JComponent)weakReference.get();
            if (c instanceof hasSetupInfo) {
                ((hasSetupInfo)((Object)c)).savesetup();
            }
            list = list + "window\t" + c.getClass().getName();
            list = list + setup.sizeloc(c);
            for (Object o : register.winmap.get(weakReference)) {
                if (o instanceof WeakReference) {
                    o = ((WeakReference)o).get();
                }
                if (o instanceof Object[]) {
                    for (Object oo : (Object[])o) {
                        list = list + "\t" + setup.getname(oo);
                    }
                    continue;
                }
                list = list + "\t" + setup.getname(o);
            }
            list = list + "\n";
        }
        fileio.savetextfile(file, list);
    }

    static String getname(Object o) {
        return o == null ? "null" : (o instanceof infob ? ((infob)o).getFullName() : o.toString());
    }

    static String sizeloc(Component c) {
        try {
            Point p;
            Dimension d = c.getSize();
            Point point = c.isShowing() ? c.getLocationOnScreen() : (p = c.getParent() == null ? new Point(0, 0) : new Point(c.getLocation().x + c.getParent().getLocationOnScreen().x, c.getLocation().y + c.getParent().getLocationOnScreen().y));
            if (p.x < 0) {
                p.x = 0;
            }
            if (p.y < 0) {
                p.y = 0;
            }
            return "\t" + d.width + "\t" + d.height + "\t" + p.x + "\t" + p.y;
        }
        catch (Exception e) {
            System.err.println(e + " for sizeloc of " + c);
            return "";
        }
    }

    public static void setsizeloc(JComponent c, Dimension d, Point p) {
        jcmTabbedPane jtp = showpan.findTabbedPane(c);
        if (jtp != null) {
            c.setPreferredSize(d);
            jtp.getParent().validate();
        } else {
            setup.setsizeloc(c.getRootPane().getParent(), d, p);
        }
    }

    public static void setsizeloc(Container c, Dimension d, Point p) {
        c.setLocation(p);
        c.setSize(d);
        showpan.mf.validate();
        Thread.currentThread();
        Thread.yield();
    }

    static String recordSplit(JSplitPane jsp) {
        String s = "split\t" + jsp.getOrientation() + "\t" + jsp.getDividerLocation();
        Component c = jsp.getTopComponent();
        s = s + "\t" + (c instanceof JSplitPane ? setup.recordSplit((JSplitPane)c) : (c instanceof JTabbedPane ? "tab" : "dtp"));
        c = jsp.getBottomComponent();
        s = s + "\t" + (c instanceof JSplitPane ? setup.recordSplit((JSplitPane)c) : (c instanceof JTabbedPane ? "tab" : "dtp"));
        return s;
    }

    static int applySplit(String[] s, int i, JSplitPane jsp) {
        JSplitPane jsp2;
        jsp.setOrientation(Integer.parseInt(s[i]));
        jsp.setDividerLocation(Integer.parseInt(s[i + 1]));
        if (s[i += 2].equals("split")) {
            jsp2 = new JSplitPane();
            jsp2.setResizeWeight(0.5);
            jsp.setTopComponent(jsp2);
            i = setup.applySplit(s, i + 1, jsp2);
        } else {
            jsp.setTopComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp());
            ++i;
        }
        if (s[i].equals("split")) {
            jsp2 = new JSplitPane();
            jsp2.setResizeWeight(0.5);
            jsp.setBottomComponent(jsp2);
            i = setup.applySplit(s, i + 1, jsp2);
        } else {
            jsp.setBottomComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp());
            ++i;
        }
        return i;
    }
}

