/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.reg;

import java.awt.Color;
import jcm.core.complexity;
import jcm.core.filter;
import jcm.core.param;
import jcm.core.reg.region;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import jcm.gui.gen.colfont;
import jcm.gui.nav.showpan;
import jcm.gui.plot.mapplot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class regman {
    public static region allreg = new region("ALL");
    public static region world = new region("world");
    public static region nations;
    static String[] expert;
    static String[] experimental;

    public static param<region> makeregionparam(String name) {
        return regman.makeregionparam(name, "JCM12");
    }

    public static param<region> makeregionparam(String name, String init) {
        region mainlist = allreg.find("MAINLIST");
        region[] rr = mainlist.reg.toArray(new region[0]);
        param<region> p = new param<region>(name, rr, allreg.find(init));
        p.addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, p));
        for (String s : expert) {
            p.setcomplexity(mainlist.find(s), complexity.expert);
        }
        for (String s : experimental) {
            p.setcomplexity(mainlist.find(s), complexity.experimental);
        }
        return p;
    }

    public static void loaddata() {
        region r;
        String[][] tab;
        for (String[] row : tab = fileio.loadtab("data/countrynames.csv", "\t")) {
            if (row.length <= 1) continue;
            r = allreg.find(row[1]);
            for (String s : row) {
                if (s.equals(row[1]) || s.trim().length() <= 0) continue;
                if (s.startsWith("#")) {
                    r.color = new Color(Integer.decode(s));
                    continue;
                }
                r.altnames.add(s);
                r.simpaltnames.add(region.simplify(s));
            }
        }
        String poly = fileio.loadstring("data/regions.txt").trim();
        String[] line = txt.split(poly, "\n", true);
        for (int i = 0; i < line.length - 1; ++i) {
            String[] item = txt.split(line[i], " ", true);
            try {
                if (region.nsew(item[0]) != 0) continue;
                r = allreg.find(item[0]);
                if (item[1].equals("+")) {
                    r.addsub(item);
                    continue;
                }
                if (item[1].equals("-")) {
                    r.subtract(item);
                    continue;
                }
                if (item[1].equals("&")) {
                    r.addset(item);
                    continue;
                }
                if (item[1].equals("L")) {
                    r.defbox(item);
                    r.sea = false;
                    continue;
                }
                if (item[1].equals("O")) {
                    r.defbox(item);
                    r.sea = true;
                    continue;
                }
                r.addedge(item);
                continue;
            }
            catch (Exception e) {
                System.out.println(line[i] + " regload " + e);
                e.printStackTrace();
            }
        }
        region oceans = allreg.find("OCEANS");
        for (region r2 : regman.allreg.reg) {
            if (!oceans.contains(r2)) continue;
            r2.sea = true;
        }
    }

    static {
        regman.loaddata();
        System.out.println("loaded region data ok");
        nations = allreg.find("NATIONS");
        regman.world.color = colfont.black;
        System.out.println("made main reg list ok");
        expert = new String[]{"JCM50", "IMAGE", "EDGAR", "JCM12IMAGE", "KYOTO", "RICE", "CWS15", "GEME18", "HOUGHTON", "NICSLR"};
        experimental = new String[]{"TGCIA", "GRID", "GRIDLO"};
    }
}

