/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.reg;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jcm.core.infob;
import jcm.core.qtset;
import jcm.core.reg.edge;
import jcm.core.reg.regman;
import jcm.core.reg.regpoly;
import jcm.gui.doc.autodoc;
import jcm.mod.reg.mapdata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class region
extends infob {
    public boolean dud = false;
    public boolean wrapping = false;
    public boolean included = false;
    public boolean fixedpoly = false;
    public boolean sea = false;
    public region superset = regman.allreg;
    public ArrayList<String> altnames = new ArrayList(0);
    public ArrayList<String> simpaltnames = new ArrayList(0);
    public List<region> reg = new ArrayList<region>();
    public Vector<regpoly> polyset = new Vector();
    List<edge> edges = new LinkedList<edge>();
    edge startedge;
    float coast = 0.0f;
    float area = 0.0f;
    static String[] ignore = new String[]{",", " &", " and", "the", " of", " is.", " isl.", " isls", " islands", " island", " rep.", " republic", "fr. ", "french ", "saint ", "st. ", "."};
    static String[] spacer = new String[]{"-", "/", "  "};
    static String edgelist;
    static Set<edge> includededge;
    static int xs;
    static int ys;

    public region(String s) {
        this.name = s;
    }

    public region(String s, Color c) {
        this.name = s;
        this.color = c;
    }

    public region() {
        this.name = "unnamed region";
    }

    public void setcols(Color[] cols) {
        for (int i = 0; i < this.reg.size(); ++i) {
            this.reg.get((int)i).color = cols[i];
        }
    }

    public Color[] getcols() {
        Color[] cols = new Color[this.reg.size() + 1];
        for (int i = 0; i < this.reg.size(); ++i) {
            cols[i] = this.reg.get(i).getColor();
        }
        cols[this.reg.size()] = Color.black;
        return cols;
    }

    @Override
    public String getName() {
        return this.altnames.size() > 0 ? this.altnames.get(0) : this.name;
    }

    public String[] getnames() {
        String[] names = new String[this.reg.size() + 1];
        for (int i = 0; i < this.reg.size(); ++i) {
            names[i] = this.reg.get((int)i).name;
        }
        names[this.reg.size()] = "world";
        return names;
    }

    @Override
    public String getExtraDoc() {
        return this.docSubReg() + "\u00a3\u00a3aboutregions" + "<hr>";
    }

    public String docSubReg() {
        String s = "";
        String s2 = "";
        if (this.reg.size() > 1) {
            for (region r : this.reg) {
                s = s + "<li>" + r.hashcolor() + autodoc.link(r.name, r.getName()) + "</font>";
            }
            s = "==\u00a3`subreg== <ul>" + s + "</ul>";
        }
        HashSet<region> supr = new HashSet<region>();
        for (region r : regman.allreg.reg) {
            if (!r.reg.contains(this)) continue;
            supr.add(r);
        }
        if (supr.size() > 1) {
            for (region r : supr) {
                s2 = s2 + "<li>" + r.hashcolor() + autodoc.link(r.name, r.getName()) + "</font>";
            }
            s2 = "==\u00a3`supreg== <ul>" + s2 + "</ul>";
        }
        return s + s2;
    }

    public boolean isset() {
        return this.reg.size() > 0;
    }

    public boolean checkfind(String s) {
        return this.findo(s) != null;
    }

    @Override
    public region find(String s) {
        region r = this.findo(s);
        if (r == null) {
            r = new region(s);
            this.reg.add(r);
        }
        return r;
    }

    static String simplify(String s) {
        String s2 = s.toLowerCase();
        for (String i : ignore) {
            s2 = s2.replace(i, "");
        }
        for (String i : spacer) {
            s2 = s2.replace(i, " ");
        }
        s2 = s2.trim();
        return s2;
    }

    public region findo(String s) {
        for (region r : this.reg) {
            if (!r.name.equals(s)) continue;
            return r;
        }
        for (region r : this.reg) {
            for (String an : r.altnames) {
                if (!an.equals(s)) continue;
                return r;
            }
        }
        String s2 = region.simplify(s);
        for (region r : this.reg) {
            for (String an : r.simpaltnames) {
                if (!an.equals(s2)) continue;
                return r;
            }
        }
        return null;
    }

    public boolean contains(region cr) {
        if (cr == this) {
            return true;
        }
        if (this.isset()) {
            for (region r : this.reg) {
                if (!r.contains(cr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Point p) {
        for (regpoly poly : this.polyset) {
            if (!poly.contains(p.x, p.y)) continue;
            return true;
        }
        return false;
    }

    boolean lt(region r) {
        return this.name.compareTo(r.name) < 0;
    }

    boolean gt(region r) {
        return this.name.compareTo(r.name) > 0;
    }

    public Set<region> subreg(region r) {
        return this.subreg(new HashSet<Object>(r.reg));
    }

    public Set<region> subreg(qtset qq) {
        return this.subreg(qq.map.keySet());
    }

    public Set<region> subreg(Set<Object> destset) {
        HashSet<region> set = new HashSet<region>();
        for (region sr : this.reg) {
            sr.addsubreg(set, destset);
        }
        if (set.size() == 0) {
            this.addsubreg(set, destset);
        }
        if (destset.contains(this) && !set.contains(this)) {
            set.add(this);
        }
        return set;
    }

    void addsubreg(Set<region> set, Set<Object> destset) {
        if (destset.contains(this)) {
            set.add(this);
        } else {
            for (region sr : this.reg) {
                sr.addsubreg(set, destset);
            }
        }
    }

    public void makepolys() {
        if (!this.fixedpoly) {
            this.polyset.clear();
            edgelist = " \n " + this.getName() + " edges from ";
            this.coast = 0.0f;
            includededge.clear();
            this.addpoly(this);
        }
    }

    public void addpoly(region ir) {
        String debug = " region " + ir.name;
        try {
            if (ir.isset()) {
                for (region r : ir.reg) {
                    if (r == ir) continue;
                    r.included = false;
                }
                for (region r : ir.reg) {
                    debug = debug + " " + r.name;
                    if (!r.included) {
                        this.addpoly(r);
                        debug = debug + ":start ";
                        continue;
                    }
                    debug = debug + ":inc ";
                }
            } else {
                if (ir.fixedpoly) {
                    this.polyset.add(ir.polyset.firstElement());
                    ir.included = true;
                }
                if (ir.startedge != null && !includededge.contains(ir.startedge)) {
                    edge e;
                    edge eo = e = ir.startedge;
                    regpoly p = null;
                    do {
                        region el;
                        region er;
                        region et;
                        debug = debug + " \tEdge " + (e != null ? e.info() : " null");
                        if (!this.contains(e.left) || !this.contains(e.right)) {
                            if (p == null) {
                                eo = e;
                                p = new regpoly();
                                this.polyset.add(p);
                                p.wrapping = false;
                            }
                            p.addedge(e, e.left == ir);
                            includededge.add(e);
                            if (e.left == ir && e.right.sea || e.right == ir && e.left.sea) {
                                float len = e.length() * 60.0f * 1.852f;
                                this.coast += len;
                                edgelist = edgelist + "   " + ir + "-" + (e.left == ir ? e.right : e.left) + " " + len;
                            }
                        }
                        if (e.left == ir) {
                            et = e.to;
                            er = e.right;
                            el = e.left;
                        } else {
                            et = e.from;
                            er = e.left;
                            el = e.right;
                        }
                        if (this.contains(et)) {
                            ir = et;
                            ir.included = true;
                            e = ir.lt(er) ? ir.fef(er, el) : er.fet(ir, el);
                            continue;
                        }
                        edge edge2 = e = ir.lt(et) ? ir.fef(et, er) : et.fet(ir, er);
                    } while (e != eo && (p == null || !p.wrapping) && !includededge.contains(e));
                }
            }
        }
        catch (RuntimeException ex) {
            System.out.println(ex + debug);
        }
    }

    float calcarea() {
        float sum = 0.0f;
        for (regpoly p : this.polyset) {
            sum += this.calcarea(p);
        }
        return sum;
    }

    float calcarea(Polygon p) {
        float sum = 0.0f;
        for (int i = 0; i < p.npoints; ++i) {
            int j = (i + 1) % p.npoints;
            sum = (float)((double)sum + ((double)p.xpoints[i] * Math.cos(Math.PI * (double)p.ypoints[i] / 180.0) * (double)p.ypoints[j] - (double)p.xpoints[j] * Math.cos(Math.PI * (double)p.ypoints[j] / 180.0) * (double)p.ypoints[i]));
        }
        return Math.abs(sum / 2.0f) * 60.0f * 60.0f * 1.852f * 1.852f;
    }

    public float avg(mapdata griddata2) {
        this.dud = this.name.startsWith("PAC_") && this.name.length() == 6;
        if (this.dud || this.wrapping) {
            return -999.0f;
        }
        double area = 0.0;
        double sum = 0.0;
        double sumarea = 0.0;
        double dudarea = 0.0;
        for (regpoly p : this.polyset) {
            Rectangle box = p.getBoundingBox();
            int step = 5;
            for (int xo = box.x; xo < box.x + box.width; xo += step) {
                int xd = Math.min(box.x + box.width - xo, step);
                for (int yo = box.y; yo < box.y + box.height; yo += step) {
                    int yd = Math.min(box.y + box.height - yo, step);
                    if (!p.intersects(xo, yo, xd, yd)) continue;
                    boolean inbox = p.contains(xo, yo, xd, yd);
                    for (int yi = yo; yi < yo + yd; ++yi) {
                        area = Math.cos(Math.PI * (double)yi / 180.0);
                        for (int xi = xo; xi < xo + xd; ++xi) {
                            if (!inbox && !p.contains(xi, yi)) continue;
                            int cell2 = this.findcell(xi, yi, griddata2);
                            try {
                                if (griddata2.r[cell2] != -999.0f) {
                                    sum += (double)griddata2.r[cell2] * area;
                                    sumarea += area;
                                    continue;
                                }
                                dudarea += area;
                                continue;
                            }
                            catch (NullPointerException e) {
                                dudarea += area;
                            }
                        }
                    }
                }
            }
        }
        if (sumarea > dudarea) {
            this.dud = false;
            return (float)(sum / sumarea);
        }
        this.dud = true;
        return -999.0f;
    }

    int findcell(int x, int y, mapdata d) {
        int xx = (int)(0.5 + (double)(d.nlon * ((x + 360) % 360)) / 360.0);
        int yy = (int)(0.5 + (double)(d.nlat * (90 - y)) / 180.0);
        return yy * d.nlon + xx;
    }

    edge fef(region r, region f) {
        for (edge e : this.edges) {
            if (r != e.right || f != e.from) continue;
            return e;
        }
        return null;
    }

    edge fet(region r, region t) {
        for (edge e : this.edges) {
            if (r != e.right || t != e.to) continue;
            return e;
        }
        return null;
    }

    edge addedge(String r, String f, String t) {
        this.startedge = new edge(this, this.superset.find(r), this.superset.find(f), this.superset.find(t));
        this.edges.add(this.startedge);
        this.superset.find((String)r).startedge = this.startedge;
        return this.startedge;
    }

    public void addedge(String[] item) {
        edge e = this.addedge(item[1], item[2], item[3]);
        e.p = new Point[item.length - 4];
        for (int j = 4; j < item.length; ++j) {
            e.p[j - 4] = region.parsepoint(item[j]);
        }
    }

    public void defbox(String[] s) {
        regpoly p = new regpoly();
        p.addPoint(region.pi(s[5]), region.pi(s[2]));
        p.addPoint(region.pi(s[5]), region.pi(s[3]));
        p.addPoint(region.pi(s[4]), region.pi(s[3]));
        p.addPoint(region.pi(s[4]), region.pi(s[2]));
        this.polyset.addElement(p);
        this.fixedpoly = true;
        this.superset.find((String)"TGCIA").reg.add(this);
    }

    public void addsub(String[] item) {
        for (int j = 2; j < item.length; ++j) {
            this.reg.add(this.superset.find(item[j]));
        }
    }

    public void subtract(String[] item) {
        for (int j = 2; j < item.length; ++j) {
            this.reg.remove(this.superset.find(item[j]));
        }
    }

    public void addset(String[] item) {
        for (int j = 2; j < item.length; ++j) {
            region rr = this.superset.find(item[j]);
            for (region r : rr.reg) {
                this.reg.add(r);
            }
        }
    }

    public static int pi(String s) {
        return Integer.parseInt(s.substring(0, s.length() - 2));
    }

    public static Point parsepoint(String item) {
        int k = region.nsew(item.substring(0, 1));
        return new Point(xs * Integer.parseInt(item.substring(k + 2, item.length())), ys * Integer.parseInt(item.substring(k, k + 2)));
    }

    public static int nsew(String c) {
        int k = 1;
        if (c.equals("N")) {
            ys = 1;
        } else if (c.equals("S")) {
            ys = -1;
        } else if (c.equals("E")) {
            xs = 1;
        } else if (c.equals("W")) {
            xs = -1;
        } else if (!c.equals("!")) {
            k = 0;
        }
        return k;
    }

    static {
        includededge = new HashSet<edge>();
        xs = 1;
        ys = 1;
    }
}

