/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import jcm.core.complexity;
import jcm.core.filter;
import jcm.core.infob;
import jcm.core.interacob;
import jcm.core.itf.plotlink;
import jcm.core.jcmAction;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.register;
import jcm.core.world;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.menuFiller;
import jcm.gui.nav.showpan;
import jcm.gui.plot.XYplot;
import jcm.gui.plot.datable;
import jcm.gui.plot.histoplot;
import jcm.gui.plot.lineplot;
import jcm.gui.plot.mapplot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class qtset
extends interacob
implements plotlink,
menuFiller {
    public Map<Object, qt> map = new LinkedHashMap<Object, qt>();
    public Set<param> assocparams;
    public qt total = null;
    public qt current = null;
    public int sy = module.gsy;
    public int ey = module.gey;
    public int xstep = 1;
    public String units = "";
    boolean setcolor = false;
    boolean gotmap = false;
    public boolean justadded = false;
    public qt.Type type = qt.Type.normal;
    public qtset qqa;
    public qtset qqb;
    public List<qtset> extraqq;
    public Map<module, List<qtset>> potdivby;
    Action refresh = new jcmAction("Refresh Options"){

        public void act() {
            qtset.this.forcecalc();
            qtset.this.findpotdivby();
        }
    };

    public qtset(Object ... args) {
        int sc = 0;
        int ic = 0;
        this.color = null;
        for (Object o : args) {
            if (o instanceof qtset) {
                if (this.qqa == null) {
                    this.qqa = (qtset)o;
                    this.color = this.qqa.color;
                    this.name = this.qqa.name;
                    this.units = this.qqa.units;
                    this.sy = this.qqa.sy;
                    this.ey = this.qqa.ey;
                    this.xstep = this.qqa.xstep;
                } else {
                    this.qqb = (qtset)o;
                }
                this.setaffectedby((qtset)o);
            }
            if (o instanceof Color) {
                this.color = (Color)o;
            }
            if (o instanceof interacob) {
                this.owner = (interacob)o;
                this.setaffectedby((interacob)o);
                this.name = this.owner.name;
            }
            if (o instanceof complexity) {
                this.mycomplexity = (complexity)((Object)o);
            }
            if (o instanceof qt.Type) {
                this.type = (qt.Type)((Object)o);
            }
            if (o instanceof qt[]) {
                for (qt q : (qt[])o) {
                    this.add(q);
                }
            }
            if (o instanceof qt) {
                this.add((qt)o);
            }
            if (o instanceof String) {
                switch (sc) {
                    case 0: {
                        this.name = (String)o;
                        break;
                    }
                    case 1: {
                        this.units = (String)o;
                    }
                }
                ++sc;
            }
            if (!(o instanceof Number)) continue;
            int i = ((Number)o).intValue();
            switch (ic) {
                case 0: {
                    this.sy = i;
                    break;
                }
                case 1: {
                    this.ey = i;
                    break;
                }
                case 2: {
                    this.xstep = i;
                }
            }
            ++ic;
        }
        if (this.mycomplexity == null) {
            if (this.map.size() > 0) {
                this.mincomplexity(this.map.values());
            } else {
                this.mycomplexity = complexity.normal;
            }
        }
        if (this.color == null) {
            this.color = qtset.rcol(this.owner.color);
        }
        this.addAction(filter.filtertype.Curves, showpan.pan("Plot", lineplot.class, this));
        if (this.type == qt.Type.ratio) {
            this.addAction(filter.filtertype.Curves, showpan.pan("Histogram", histoplot.class, this));
            this.addAction(filter.filtertype.Curves, showpan.pan("Scatter/XYplot", XYplot.class, this));
        }
        if (this.gotmap) {
            this.addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, this));
        }
        this.addAction(filter.filtertype.Curves, showpan.pan("Table", datable.class, this));
        this.addAction(filter.filtertype.Doc);
    }

    public void associate(param ... pp) {
        if (this.assocparams == null) {
            this.assocparams = new HashSet<param>(3);
        }
        for (param p : pp) {
            this.assocparams.add(p);
        }
    }

    @Override
    public void changeendyear(int oldey, int newey) {
        if (this.ey == oldey) {
            this.ey = newey;
            for (qt q : this.map.values()) {
                q.changeendyear(oldey, newey);
            }
            this.changed = true;
        }
    }

    public void add(Object o, qt q) {
        this.map.put(o, q);
        if (o == regman.world && q.type == qt.Type.normal) {
            q.type = qt.Type.total;
        }
        if (this.total == null && q.type == qt.Type.total) {
            this.total = q;
        }
        if (this.mycomplexity == null) {
            this.mincomplexity(this.map.values());
        }
        if (q.owner == q) {
            q.owner = this;
        }
    }

    public void add(qt ... qq) {
        for (qt q : qq) {
            this.add(q.name, q);
        }
    }

    public qt reg(Object r) {
        if (this.map.containsKey(r)) {
            return this.map.get(r);
        }
        if (r instanceof region && !this.gotmap) {
            this.gotmap = true;
            this.addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, this));
        }
        qt q = null;
        switch (this.type) {
            case difference: 
            case sum: 
            case ratio: {
                q = new qt(new Object[]{this.qqa.map.get(r), this.qqb.map.get(r), this.type, this.owner});
                break;
            }
            case frac: 
            case rate: 
            case integral: {
                q = new qt(new Object[]{this.qqa.map.get(r), this.type, this.owner});
                break;
            }
            default: {
                if (r instanceof infob) {
                    infob ri = (infob)r;
                    q = new qt(ri.getName(), ri.getColor(), this.sy, this.ey, this.xstep, this);
                    break;
                }
                q = new qt(r.toString(), Color.black, this.sy, this.ey, this.xstep, this);
            }
        }
        if (this.mycomplexity != null && r instanceof region) {
            q.mycomplexity = this.mycomplexity;
        }
        this.add(r, q);
        return q;
    }

    @Override
    public infob find(String name) {
        infob o = super.find(name);
        if (o != null) {
            return o;
        }
        for (Object oo : this.map.keySet()) {
            if (!oo.toString().equals(name)) continue;
            return this.map.get(oo);
        }
        return null;
    }

    public float get(Object r, int year) {
        return this.reg(r).get(year);
    }

    public float get(Object r) {
        return this.reg(r).get();
    }

    public float get(int year) {
        return this.current.get(year);
    }

    public float get() {
        return this.current.get();
    }

    public void set(Object r, int year, float f) {
        this.reg(r).set(year, f);
    }

    public void set(int year, float f) {
        this.current.set(year, f);
    }

    public void set(Object r, float f) {
        this.reg(r).set(f);
    }

    public void set(float f) {
        this.current.set(f);
    }

    public void setreg(Object r) {
        this.current = this.reg(r);
    }

    public String getunits() {
        return this.units;
    }

    public param getxscale() {
        return new param(new Object[]{param.Type.Xscale, "Xscale", "year", 0, Math.max(this.sy, 1800), Math.min(this.ey, 2200), 50});
    }

    public param getyscale() {
        return new param(new Object[]{param.Type.Yscale, "Yscale", this.units, 0, Float.valueOf(this.getmin()), Float.valueOf(this.getmax()), 1});
    }

    public float getmax() {
        float max = Float.MIN_VALUE;
        for (qt q : this.map.values()) {
            if (!q.checkcomplexity()) continue;
            max = Math.max(max, q.getmax());
        }
        return max;
    }

    public float getmin() {
        float min = Float.MAX_VALUE;
        for (qt q : this.map.values()) {
            if (!q.checkcomplexity()) continue;
            min = Math.min(min, q.getmin());
        }
        return min;
    }

    public float getmax(boolean stacked) {
        if (!stacked) {
            return this.getmax();
        }
        float max = Float.MIN_VALUE;
        for (int year = this.sy; year < this.ey; year += this.xstep) {
            float tot = 0.0f;
            for (qt q : this.mapwithouttotal().values()) {
                tot += q.get(year);
            }
            if (!(tot > max)) continue;
            max = tot;
        }
        return max;
    }

    public float calctot() {
        return this.calctot(module.year);
    }

    public float calctot(int year) {
        if (this.total == null) {
            this.total = this.reg(regman.world);
        }
        this.total.set(year, 0.0f);
        for (qt q : this.mapwithouttotal().values()) {
            float f = q.get(year);
            if (f == qt.dud) continue;
            this.total.set(year, this.total.get(year) + f);
        }
        return this.total.get(year);
    }

    public void topdownscale(float global) {
        this.topdownscale(global, false);
    }

    public void topdownscale(float global, boolean excludebunker) {
        float regtot = this.calctot();
        if (excludebunker) {
            regtot -= this.get("bunker");
            global -= this.get("bunker");
        }
        if (regtot > 0.0f) {
            for (qt q : this.map.values()) {
                float f;
                if (excludebunker && q.name.equals("bunker") || (f = q.get()) == qt.dud) continue;
                q.set(f * global / regtot);
            }
        }
    }

    public Map<Object, qt> mapwithouttotal() {
        LinkedHashMap<Object, qt> m = new LinkedHashMap<Object, qt>();
        for (Map.Entry<Object, qt> me : this.map.entrySet()) {
            if (me.getValue().type == qt.Type.total) continue;
            m.put(me.getKey(), me.getValue());
        }
        return m;
    }

    public void postcalc() {
        if (this.type == qt.Type.integral) {
            for (qt q : this.map.values()) {
                q.calcintegral();
            }
        }
    }

    @Override
    public void fillMenu(jcmMenu pop) {
        this.fillMenu(pop, filter.all());
    }

    @Override
    public void fillMenu(jcmMenu pop, Set<filter.filtertype> fs) {
        super.fillMenu(pop, fs);
        pop.addSeparator();
        if (fs.contains((Object)filter.filtertype.Curves)) {
            jcmMenu submenu = new jcmMenu(new Object[]{"CreateVariant"});
            submenu.add(new jcmAction("percent&change&per&yr"){

                public void act() {
                    qtset.this.addnewderiv(qt.Type.rate);
                }
            });
            submenu.add(new jcmAction("percent&of&total"){

                public void act() {
                    qtset.this.addnewderiv(qt.Type.frac);
                }
            });
            submenu.add(new jcmAction("integral"){

                public void act() {
                    qtset.this.addnewderiv(qt.Type.integral);
                }
            });
            submenu.add(this.makederivmenu(qt.Type.ratio));
            submenu.add(this.makederivmenu(qt.Type.difference));
            submenu.addSeparator();
            if (world.worlds.size() > 1) {
                submenu.add(this.compareworldmenu());
            }
            submenu.addSeparator();
            submenu.add(this.refresh);
            pop.add(submenu);
            pop.addSeparator();
            if (this.temporary) {
                pop.add(new jcmAction("Remove"){

                    public void act() {
                        qtset.this.removederiv();
                    }
                });
            }
        }
    }

    public void addnewderiv(qt.Type dty) {
        this.addderiv(this.makederiv(dty));
    }

    public void addnewderiv(qt.Type dty, qtset other) {
        this.addderiv(this.makederiv(dty, other));
    }

    public qtset makederiv(qt.Type dty) {
        return this.makederiv(dty, null);
    }

    public qtset makederiv(qt.Type dty, qtset other) {
        String string;
        block5: {
            block4: {
                if (other != null) break block4;
                string = this.name + "&" + (Object)((Object)dty);
                break block5;
            }
            string = this.name + "&" + (dty == qt.Type.ratio ? "per" : (dty == qt.Type.sum ? "plus" : (dty == qt.Type.difference ? "minus" : ""))) + "&" + other.name;
        }
        String dname = string;
        String dunits = dty == qt.Type.rate ? this.units + "&percent&per&year" : (dty == qt.Type.integral ? this.units + "&integral" : (dty == qt.Type.frac ? "percent" : (dty == qt.Type.ratio ? this.units + "&per&" + other.units : this.units)));
        qtset qd = new qtset(new Object[]{this, other, dty, dname, dunits, this.sy, this.ey, this.xstep});
        if (other == null) {
            for (Object k : dty == qt.Type.frac ? this.mapwithouttotal().keySet() : this.map.keySet()) {
                qd.add(k, new qt(new Object[]{this.map.get(k), dty, this}));
            }
        } else {
            for (Object k : this.map.keySet()) {
                if (!other.map.containsKey(k)) continue;
                qd.add(k, new qt(new Object[]{this.map.get(k), other.map.get(k), dty, this}));
            }
            qd.setaffectedby(other);
        }
        qd.type = dty;
        qd.setaffectedby(this);
        qd.register();
        return qd;
    }

    public qtset compareworld(qt q) {
        System.err.println(q.name);
        qtset cwq = new qtset(q.name, this.units, this.sy, this.ey, this.xstep);
        cwq.register();
        for (world w : world.worlds) {
            for (module m : w.mods) {
                for (qtset mqq : m.qtsets) {
                    if (!mqq.name.equals(this.name)) continue;
                    for (Object key : this.map.keySet()) {
                        if (this.map.get(key) != q) continue;
                        try {
                            cwq.add(w.name, new qt(mqq.map.get(key).geta(), w.name, w.color, this.sy, this.ey, this.xstep));
                        }
                        catch (NullPointerException e) {
                            System.err.println("cannot find curve " + key + " for " + w.name);
                        }
                    }
                    cwq.setaffectedby(m);
                }
            }
        }
        return cwq;
    }

    public void addderiv(qtset qd) {
        this.addOb(qd);
        qd.temporary = true;
        qd.justadded = true;
        jcmTree.restruclink.changed = true;
        qd.owner = this;
        qd.gotmap = this.gotmap;
        loop.golater();
    }

    public void removederiv() {
        this.owner.removeOb(this);
        this.dispose();
    }

    public void refreshregs() {
        if (this.type != qt.Type.normal) {
            this.map.clear();
            for (Object o : this.type == qt.Type.frac ? this.qqa.mapwithouttotal().keySet() : this.qqa.map.keySet()) {
                this.reg(o);
            }
        }
    }

    public void forcecalc() {
        if (this.changed) {
            register.addlink(this, this);
            loop.gonow();
            register.removelink(this, this);
        }
    }

    @Override
    public boolean isShowing() {
        return true;
    }

    @Override
    public void doplot() {
    }

    public void findpotdivby() {
        this.potdivby.clear();
        for (world w : world.worlds) {
            for (module m : w.mods) {
                LinkedList<qtset> fit = new LinkedList<qtset>();
                block2: for (qtset qqd : m.qtsets) {
                    if (qqd.equals(this)) continue;
                    if (qqd.name.equals(this.name)) {
                        fit.add(qqd);
                        continue;
                    }
                    for (Object o : qqd.map.keySet()) {
                        if (!this.map.containsKey(o)) continue;
                        fit.add(qqd);
                        continue block2;
                    }
                }
                if (fit.size() <= 0) continue;
                this.potdivby.put(m, fit);
            }
        }
    }

    public jcmMenu makederivmenu(qt.Type aty) {
        if (this.potdivby == null) {
            this.potdivby = new HashMap<module, List<qtset>>();
            this.findpotdivby();
        }
        if (this.potdivby.size() > 0) {
            jcmMenu dm = new jcmMenu(new Object[]{(Object)((Object)aty) + ":"});
            for (List<qtset> qqs : this.potdivby.values()) {
                for (qtset qqd : qqs) {
                    if (!qqd.name.equals(this.name) || !this.checkunitsmatch(qqd, aty)) continue;
                    dm.add(this.dbaction(qqd.getworld().name, qqd, aty));
                }
            }
            dm.addSeparator();
            if (this.potdivby.get(this.getmodule()) != null) {
                for (qtset qqd : this.potdivby.get(this.getmodule())) {
                    if (!qqd.checkcomplexity() || !this.checkunitsmatch(qqd, aty)) continue;
                    dm.add(this.dbaction(qqd.getTitle(), qqd, aty));
                }
            }
            dm.addSeparator();
            for (module m : this.potdivby.keySet()) {
                if (m == this.getmodule()) continue;
                jcmMenu submenu = new jcmMenu(new Object[]{labman.getTitle(m.getFullName())});
                for (qtset qqd : this.potdivby.get(m)) {
                    if (!qqd.checkcomplexity() || !this.checkunitsmatch(qqd, aty)) continue;
                    submenu.add(this.dbaction(qqd.getTitle(), qqd, aty));
                }
                if (submenu.list.size() > 1) {
                    dm.add(submenu);
                }
                if (submenu.list.size() != 1) continue;
                dm.add(submenu.list.get(0));
            }
            return dm;
        }
        return null;
    }

    boolean checkunitsmatch(qtset qqd, qt.Type aty) {
        if (aty == qt.Type.ratio) {
            return true;
        }
        qtset qqc = aty == qt.Type.extra ? this.qqa : this;
        return qqc.units.substring(this.units.indexOf("&") + 1).equals(qqd.units.substring(qqd.units.indexOf("&") + 1));
    }

    Action dbaction(String name, final qtset qqd, final qt.Type aty) {
        return new jcmAction(name){

            public void act() {
                if (aty == qt.Type.ratio) {
                    qtset.this.addnewderiv(qt.Type.ratio, qqd);
                }
                if (aty == qt.Type.difference) {
                    qtset.this.addnewderiv(qt.Type.difference, qqd);
                }
                if (aty == qt.Type.extra) {
                    qtset.this.addExtra(qqd);
                }
            }
        };
    }

    public jcmMenu compareworldmenu() {
        jcmMenu cwm = new jcmMenu(new Object[]{" Compare Worlds... "});
        for (final qt q : this.map.values()) {
            cwm.add(new jcmAction(q.name){

                public void act() {
                    qtset.this.addderiv(qtset.this.compareworld(q));
                }
            });
        }
        return cwm;
    }

    void addExtra(qtset qe) {
        if (this.extraqq == null) {
            this.extraqq = new ArrayList<qtset>(3);
            if (this.qqa != null) {
                this.extraqq.add(this.qqa);
            }
        }
        this.extraqq.add(qe);
        this.setaffectedby(qe);
        this.changed = true;
        loop.golater();
    }

    public List<qtset> qqalist() {
        return this.extraqq != null ? this.extraqq : Collections.singletonList(this.qqa);
    }

    @Override
    public String getExtraDoc() {
        return this.docUnits() + this.docCurves() + "----" + this.docInteracs() + autodoc.javacode(this);
    }

    public String docUnits() {
        String s = "==Units==";
        s = s + "units: " + labman.getTitle(this.units) + "<br>";
        s = s + "timescale (years) " + this.sy + "-" + this.ey + " (step " + this.xstep + ")<br>";
        return s;
    }

    /*
     * Unable to fully structure code
     */
    public String docCurves() {
        s = "==Curves==";
        if (this.type == qt.Type.normal) ** GOTO lbl-1000
        if (this.type != qt.Type.total) {
            s = s + labman.getTitle((Object)this.type + "&of&") + this.qqa.docSummary() + "<br>";
        } else if (this.map.size() == 0) {
            s = s + "\u00a3\u00a7nocurvesyet";
        }
        s = s + "<ul>";
        for (qt q : this.map.values()) {
            if (!q.checkcomplexity()) continue;
            s = s + "<li>" + q.docSummary();
        }
        s = s + "</ul>";
        return s;
    }
}

