/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.menu;

import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.jvnet.substance.utils.SubstanceTrait;

public class TraitMenuHandler {
    protected ButtonGroup traitGroup = new ButtonGroup();
    protected Map<String, AbstractButton> traitButtons = new HashMap<String, AbstractButton>();
    protected AbstractButton traitDummyButton = new JToggleButton();

    public TraitMenuHandler() {
        this.traitGroup.add(this.traitDummyButton);
    }

    public void addTraitButton(SubstanceTrait trait, AbstractButton traitButton) {
        this.traitGroup.add(traitButton);
        this.traitButtons.put(trait.getDisplayName(), traitButton);
    }

    public void addTraitButton(String traitDisplayName, AbstractButton traitButton) {
        this.traitGroup.add(traitButton);
        this.traitButtons.put(traitDisplayName, traitButton);
    }

    public void selectTraitButton(String traitDisplayName) {
        final AbstractButton toSelect = this.traitButtons.containsKey(traitDisplayName) ? this.traitButtons.get(traitDisplayName) : this.traitDummyButton;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                toSelect.setSelected(true);
            }
        });
    }

    public void selectTraitButton(SubstanceTrait trait) {
        this.selectTraitButton(trait.getDisplayName());
    }
}

