/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;

public class SubstanceComplexTheme
extends SubstanceTheme {
    protected SubstanceTheme activeTheme;
    protected SubstanceTheme defaultTheme;
    protected SubstanceTheme disabledTheme;
    protected SubstanceTheme activeTitlePaneTheme;
    protected SubstanceTheme watermarkTheme;
    protected SubstanceTheme cellRendererBackgroundTheme;
    protected SubstanceGradientPainter nonActivePainter;
    protected double selectedTabFadeStart;
    protected double selectedTabFadeEnd;

    public SubstanceComplexTheme(String displayName, SubstanceTheme.ThemeKind themeKind, SubstanceTheme activeTheme, SubstanceTheme defaultTheme, SubstanceTheme disabledTheme, SubstanceTheme activeTitlePaneTheme) {
        this(displayName, themeKind, activeTheme, defaultTheme, disabledTheme, activeTitlePaneTheme, defaultTheme);
    }

    public SubstanceComplexTheme(String displayName, SubstanceTheme.ThemeKind themeKind, SubstanceTheme activeTheme, SubstanceTheme defaultTheme, SubstanceTheme disabledTheme, SubstanceTheme activeTitlePaneTheme, SubstanceTheme watermarkTheme) {
        super(defaultTheme.getColorScheme(), displayName, themeKind);
        this.activeTheme = activeTheme;
        this.defaultTheme = defaultTheme;
        this.disabledTheme = disabledTheme;
        this.activeTitlePaneTheme = activeTitlePaneTheme;
        this.watermarkTheme = watermarkTheme;
        this.cellRendererBackgroundTheme = activeTheme;
        this.selectedTabFadeStart = 1.0;
        this.selectedTabFadeEnd = 1.0;
    }

    public SubstanceTheme getActiveTheme() {
        return this.activeTheme;
    }

    public SubstanceTheme getDefaultTheme() {
        return this.defaultTheme;
    }

    public SubstanceTheme getDisabledTheme() {
        return this.disabledTheme;
    }

    public SubstanceTheme getActiveTitlePaneTheme() {
        return this.activeTitlePaneTheme;
    }

    public SubstanceTheme getFirstTheme() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("First " + this.getDisplayName(), this.getKind(), this.getActiveTheme().getFirstTheme(), this.getDefaultTheme().getFirstTheme(), this.getDisabledTheme().getFirstTheme(), this.getActiveTitlePaneTheme().getFirstTheme());
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().getFirstTheme());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme getSecondTheme() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Second " + this.getDisplayName(), this.getKind(), this.getActiveTheme().getSecondTheme(), this.getDefaultTheme().getSecondTheme(), this.getDisabledTheme().getSecondTheme(), this.getActiveTitlePaneTheme().getSecondTheme());
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().getSecondTheme());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme saturate(double saturateFactor, boolean toSaturateEverything) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Saturated [" + toSaturateEverything + "] " + this.getDisplayName() + " " + (int)(100.0 * saturateFactor) + "%", this.getKind(), this.getActiveTheme().saturate(saturateFactor, toSaturateEverything), toSaturateEverything ? this.getDefaultTheme().saturate(saturateFactor, true) : this.getDefaultTheme(), toSaturateEverything ? this.getDisabledTheme().saturate(saturateFactor, true) : this.getDisabledTheme(), toSaturateEverything ? this.getActiveTitlePaneTheme().saturate(saturateFactor, true) : this.getActiveTitlePaneTheme(), toSaturateEverything ? this.getWatermarkTheme().saturate(saturateFactor, true) : this.getWatermarkTheme());
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().saturate(saturateFactor, true));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme shade(double shadeFactor) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Shade " + this.getDisplayName() + " " + (int)(100.0 * shadeFactor) + "%", this.getKind(), this.getActiveTheme().shade(shadeFactor), this.getDefaultTheme().shade(shadeFactor), this.getDisabledTheme().shade(shadeFactor), this.getActiveTitlePaneTheme().shade(shadeFactor), this.getWatermarkTheme().shade(shadeFactor));
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().shade(shadeFactor));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme tint(double tintFactor) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Tint " + this.getDisplayName() + " " + (int)(100.0 * tintFactor) + "%", this.getKind(), this.getActiveTheme().tint(tintFactor), this.getDefaultTheme().tint(tintFactor), this.getDisabledTheme().tint(tintFactor), this.getActiveTitlePaneTheme().tint(tintFactor), this.getWatermarkTheme().tint(tintFactor));
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().tint(tintFactor));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme tone(double toneFactor) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Tone " + this.getDisplayName() + " " + (int)(100.0 * toneFactor) + "%", this.getKind(), this.getActiveTheme().tone(toneFactor), this.getDefaultTheme().tone(toneFactor), this.getDisabledTheme().tone(toneFactor), this.getActiveTitlePaneTheme().tone(toneFactor), this.getWatermarkTheme().tone(toneFactor));
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().tone(toneFactor));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme invert() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Inverted " + this.getDisplayName(), this.getKind(), this.getActiveTheme().invert(), this.getDefaultTheme().invert(), this.getDisabledTheme().invert(), this.getActiveTitlePaneTheme().invert(), this.getWatermarkTheme().invert());
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().invert());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme negate() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Negated " + this.getDisplayName(), this.getKind(), this.getActiveTheme().negate(), this.getDefaultTheme().negate(), this.getDisabledTheme().negate(), this.getActiveTitlePaneTheme().negate(), this.getWatermarkTheme().negate());
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().negate());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme hueShift(double hueShiftFactor) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Hue-shift " + this.getDisplayName() + " " + (int)(100.0 * hueShiftFactor) + "%", this.getKind(), this.getActiveTheme().hueShift(hueShiftFactor), this.getDefaultTheme().hueShift(hueShiftFactor), this.getDisabledTheme().hueShift(hueShiftFactor), this.getActiveTitlePaneTheme().hueShift(hueShiftFactor), this.getWatermarkTheme().hueShift(hueShiftFactor));
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().hueShift(hueShiftFactor));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme protanopia() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Protanopia " + this.getDisplayName(), this.getKind(), this.getActiveTheme().protanopia(), this.getDefaultTheme().protanopia(), this.getDisabledTheme().protanopia(), this.getActiveTitlePaneTheme().protanopia(), this.getWatermarkTheme().protanopia());
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().protanopia());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme tritanopia() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Tritanopia " + this.getDisplayName(), this.getKind(), this.getActiveTheme().tritanopia(), this.getDefaultTheme().tritanopia(), this.getDisabledTheme().tritanopia(), this.getActiveTitlePaneTheme().tritanopia(), this.getWatermarkTheme().tritanopia());
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().tritanopia());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme deuteranopia() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Deuteranopia " + this.getDisplayName(), this.getKind(), this.getActiveTheme().deuteranopia(), this.getDefaultTheme().deuteranopia(), this.getDisabledTheme().deuteranopia(), this.getActiveTitlePaneTheme().deuteranopia(), this.getWatermarkTheme().deuteranopia());
        result.setCellRendererBackgroundTheme(this.getCellRendererBackgroundTheme().deuteranopia());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme getWatermarkTheme() {
        return this.watermarkTheme;
    }

    public SubstanceTheme getCellRendererBackgroundTheme() {
        return this.cellRendererBackgroundTheme;
    }

    public void setCellRendererBackgroundTheme(SubstanceTheme cellRendererBackgroundTheme) {
        this.cellRendererBackgroundTheme = cellRendererBackgroundTheme;
    }

    public SubstanceGradientPainter getNonActivePainter() {
        if (this.nonActivePainter != null) {
            return this.nonActivePainter;
        }
        return super.getNonActivePainter();
    }

    public void setNonActivePainter(SubstanceGradientPainter nonActivePainter) {
        this.nonActivePainter = nonActivePainter;
    }

    public double getSelectedTabFadeStart() {
        return this.selectedTabFadeStart;
    }

    public double getSelectedTabFadeEnd() {
        return this.selectedTabFadeEnd;
    }

    public void setSelectedTabFadeEnd(double selectedTabFadeEnd) {
        this.selectedTabFadeEnd = selectedTabFadeEnd;
    }

    public void setSelectedTabFadeStart(double selectedTabFadeStart) {
        this.selectedTabFadeStart = selectedTabFadeStart;
    }

    protected void copyTo(SubstanceComplexTheme dst) {
        dst.setNonActivePainter(this.nonActivePainter);
        dst.setSelectedTabFadeStart(this.selectedTabFadeStart);
        dst.setSelectedTabFadeEnd(this.selectedTabFadeEnd);
    }
}

