/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.Resettable;
import org.jvnet.lafwidget.tabbed.TabPagerManager;

public class TabPagerWidget
extends LafWidgetAdapter
implements Resettable {
    protected JTabbedPane jtp;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.jtp = (JTabbedPane)jcomp;
    }

    public void installUI() {
        super.installUI();
        InputMap currMap = SwingUtilities.getUIInputMap(this.jtp, 1);
        InputMap newMap = new InputMap();
        if (currMap != null) {
            KeyStroke[] kss = currMap.allKeys();
            for (int i = 0; i < kss.length; ++i) {
                KeyStroke stroke = kss[i];
                Object val = currMap.get(stroke);
                newMap.put(stroke, val);
            }
        }
        newMap.put(KeyStroke.getKeyStroke(39, 2), "tabSwitcherForward");
        newMap.put(KeyStroke.getKeyStroke(37, 2), "tabSwitcherBackward");
        newMap.put(KeyStroke.getKeyStroke(17, 0, true), "tabSwitcherClose");
        this.jtp.getActionMap().put("tabSwitcherForward", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TabPagerManager te = TabPagerManager.getPager();
                te.page(TabPagerWidget.this.jtp, true);
            }
        });
        this.jtp.getActionMap().put("tabSwitcherBackward", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TabPagerManager te = TabPagerManager.getPager();
                te.page(TabPagerWidget.this.jtp, false);
            }
        });
        this.jtp.getActionMap().put("tabSwitcherClose", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TabPagerManager te = TabPagerManager.getPager();
                        int index = te.hide();
                        if (index >= 0) {
                            TabPagerWidget.this.jtp.setSelectedIndex(index);
                        }
                    }
                });
            }
        });
        SwingUtilities.replaceUIInputMap(this.jtp, 1, newMap);
    }

    public void uninstallUI() {
        super.uninstallUI();
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public void reset() {
        TabPagerManager.reset();
    }
}

