/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.layout.TransitionLayoutManager;
import org.jvnet.lafwidget.tabbed.TabPreviewControl;
import org.jvnet.lafwidget.tabbed.TabPreviewPainter;
import org.jvnet.lafwidget.tabbed.TabPreviewThread;
import org.jvnet.lafwidget.utils.LafConstants;

public class TabOverviewDialog
extends JDialog {
    protected JTabbedPane tabPane;
    protected JPanel overviewPanel;
    protected TabPreviewThread.TabPreviewCallback previewCallback;

    private TabOverviewDialog(JTabbedPane tabPane, Frame owner, boolean modal, int dialogWidth, int dialogHeight) throws HeadlessException {
        super(owner, modal);
        this.tabPane = tabPane;
        this.setLayout(new BorderLayout());
        this.overviewPanel = new TabOverviewPanel(dialogWidth, dialogHeight);
        this.add((Component)this.overviewPanel, "Center");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                this.cancelRequests();
            }

            public void windowClosed(WindowEvent e) {
                this.cancelRequests();
            }

            private void cancelRequests() {
                TabPreviewThread.getInstance().cancelTabPreviewRequests(TabOverviewDialog.this);
            }
        });
    }

    public static TabOverviewDialog getOverviewDialog(JTabbedPane tabPane) {
        TabPreviewPainter previewPainter = LafWidgetUtilities.getTabPreviewPainter(tabPane);
        String title = previewPainter.toUpdatePeriodically(tabPane) ? MessageFormat.format(LafWidgetRepository.getLabelBundle().getString("TabbedPane.overviewDialogTitleRefresh"), new Integer(previewPainter.getUpdateCycle(tabPane) / 1000)) : LafWidgetRepository.getLabelBundle().getString("TabbedPane.overviewDialogTitle");
        JFrame frameForModality = previewPainter.getModalOwner(tabPane);
        boolean isModal = frameForModality != null;
        Rectangle dialogScreenBounds = previewPainter.getPreviewDialogScreenBounds(tabPane);
        TabOverviewDialog overviewDialog = new TabOverviewDialog(tabPane, frameForModality, isModal, dialogScreenBounds.width, dialogScreenBounds.height);
        overviewDialog.setTitle(title);
        overviewDialog.setLocation(dialogScreenBounds.x, dialogScreenBounds.y);
        overviewDialog.setSize(dialogScreenBounds.width, dialogScreenBounds.height);
        return overviewDialog;
    }

    protected class TabOverviewPanel
    extends JPanel {
        protected TabPreviewControl[] previewControls;
        protected int pWidth;
        protected int pHeight;
        protected int colCount;

        public TabOverviewPanel(final int dialogWidth, final int dialogHeight) {
            TabPreviewThread.TabPreviewCallback previewCallback = new TabPreviewThread.TabPreviewCallback(){

                public void start(JTabbedPane tabPane, int tabCount, TabPreviewThread.TabPreviewInfo tabPreviewInfo) {
                    int i;
                    boolean isSame;
                    boolean bl = isSame = TabOverviewPanel.this.previewControls != null && TabOverviewPanel.this.previewControls.length == tabCount;
                    if (isSame) {
                        return;
                    }
                    if (TabOverviewPanel.this.previewControls != null) {
                        for (i = 0; i < TabOverviewPanel.this.previewControls.length; ++i) {
                            TabOverviewPanel.this.remove(TabOverviewPanel.this.previewControls[i]);
                        }
                    }
                    TabOverviewPanel.this.colCount = (int)Math.sqrt(tabCount);
                    if (TabOverviewPanel.this.colCount * TabOverviewPanel.this.colCount < tabCount) {
                        ++TabOverviewPanel.this.colCount;
                    }
                    TabOverviewPanel.this.pWidth = (dialogWidth - 8) / TabOverviewPanel.this.colCount;
                    TabOverviewPanel.this.pHeight = (dialogHeight - 32) / TabOverviewPanel.this.colCount;
                    tabPreviewInfo.previewWidth = TabOverviewPanel.this.pWidth - 4;
                    tabPreviewInfo.previewHeight = TabOverviewPanel.this.pHeight - 20;
                    TabOverviewPanel.this.previewControls = new TabPreviewControl[tabCount];
                    for (i = 0; i < tabCount; ++i) {
                        TabPreviewControl previewControl = new TabPreviewControl(TabOverviewDialog.this.tabPane, i);
                        previewControl.addMouseListener(new TabPreviewMouseHandler(i, previewControl));
                        previewControl.setToolTipText(LafWidgetRepository.getLabelBundle().getString("TabbedPane.overviewWidgetTooltip"));
                        TabOverviewPanel.this.previewControls[i] = previewControl;
                        TabOverviewPanel.this.add(previewControl);
                    }
                    TabOverviewPanel.this.doLayout();
                    for (i = 0; i < tabCount; ++i) {
                        TabOverviewPanel.this.previewControls[i].revalidate();
                    }
                    TabOverviewPanel.this.repaint();
                }

                public void offer(JTabbedPane tabPane, int tabIndex, BufferedImage componentSnap) {
                    TabOverviewPanel.this.previewControls[tabIndex].setPreviewImage(componentSnap);
                }
            };
            this.setLayout(new TabOverviewPanelLayout());
            this.putClientProperty("lafwidgets.animationKind", LafConstants.AnimationKind.SLOW);
            TransitionLayoutManager.getInstance().track(this, true);
            TabPreviewThread.TabPreviewInfo previewInfo = new TabPreviewThread.TabPreviewInfo();
            previewInfo.tabPane = TabOverviewDialog.this.tabPane;
            previewInfo.previewCallback = previewCallback;
            previewInfo.toPreviewAllTabs = true;
            previewInfo.initiator = TabOverviewDialog.this;
            TabPreviewThread.getInstance().queueTabPreviewRequest(previewInfo);
        }

        private class TabOverviewPanelLayout
        implements LayoutManager {
            private TabOverviewPanelLayout() {
            }

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public void layoutContainer(Container parent) {
                if (TabOverviewPanel.this.previewControls == null) {
                    return;
                }
                for (int i = 0; i < TabOverviewPanel.this.previewControls.length; ++i) {
                    TabPreviewControl previewControl = TabOverviewPanel.this.previewControls[i];
                    if (previewControl == null) continue;
                    int rowIndex = i / TabOverviewPanel.this.colCount;
                    int colIndex = i % TabOverviewPanel.this.colCount;
                    previewControl.setBounds(colIndex * TabOverviewPanel.this.pWidth, rowIndex * TabOverviewPanel.this.pHeight, TabOverviewPanel.this.pWidth, TabOverviewPanel.this.pHeight);
                }
            }

            public Dimension minimumLayoutSize(Container parent) {
                return parent.getSize();
            }

            public Dimension preferredLayoutSize(Container parent) {
                return this.minimumLayoutSize(parent);
            }
        }
    }

    protected class TabPreviewMouseHandler
    extends MouseAdapter {
        private int index;
        private TabPreviewControl previewControl;

        public TabPreviewMouseHandler(int index, TabPreviewControl previewControl) {
            this.index = index;
            this.previewControl = previewControl;
        }

        public void mouseClicked(MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TabOverviewDialog.this.dispose();
                    TabOverviewDialog.this.tabPane.setSelectedIndex(TabPreviewMouseHandler.this.index);
                }
            });
        }

        public void mouseEntered(MouseEvent e) {
            boolean isSelected;
            boolean bl = isSelected = TabOverviewDialog.this.tabPane.getSelectedIndex() == this.index;
            if (isSelected) {
                this.previewControl.setBorder(new LineBorder(Color.blue, 2));
            } else {
                this.previewControl.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.black, 1)));
            }
        }

        public void mouseExited(MouseEvent e) {
            boolean isSelected;
            boolean bl = isSelected = TabOverviewDialog.this.tabPane.getSelectedIndex() == this.index;
            if (isSelected) {
                this.previewControl.setBorder(new LineBorder(Color.black, 2));
            } else {
                this.previewControl.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.black, 1)));
            }
        }
    }
}

