package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jcm.core.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.*;
import jcm.mod.reg.*;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.soc.responsibility;
import jcm.mod.soc.socreg;
import static jcm.core.report.*;

public class contribtemp_1 extends calcscript {
    
    berncarbon bc=get(berncarbon.class);
    carboncycle cc=get(carboncycle.class);
    CalcLucEmit cl=get(CalcLucEmit.class);
    responsibility rs = get(responsibility.class);
    
    qt tot = new qt("surftemp", "degcbase");
    
    //String[] regionsChosen = new String[]{"Brazil.", "USA", "India"};
    //static String[] regionsChosen = new String[]{"United States", "Canada", "Japan","Russia","Turkey","China","Indonesia","India","Brazil.","Costa Rica","Venezuela","Bolivia","Ecuador","Peru","Colombia","Argentina","Chile","Paraguay","Uruguay","Belgium","Luxembourg","Netherlands","Germany","Austria","United Kingdom","Ireland","Denmark","Sweden","Finland","Spain","Portugal","Italy","Greece","Norway","Switzerland","Iceland","Czech Republic","Slovakia","Slovenia","Hungary","Poland","Croatia","Bulgaria","Romania","Bosnia and Herzegovina","Albania","Ukraine","Azerbaijan","Turkmenistan","Uzbekistan","Kazakhstan","Kyrgyzstan","Tajikistan","Saudi Arabia","Syria","Lebanon","Iraq","Pakistan","Afghanistan","Morocco","Egypt","Congo, DR","Congo, PR","Angola","Mongolia","North Korea","Sri Lanka","Bangladesh","Thailand","Vietnam","Cambodia","Australia","New Zealand","Mexico","France","South Africa","South Korea","Malaysia"};
    
    static String[] regionsChosen = new String[]{"United States", "Japan", "China", "India", "Canada", "Oceania", "North Europe", "South EU +France", "East Europe +Ukraine", "Russia", "Central Asia Stans", "Turkey", "Arabia", "Iran Pakn Afgn", "Other East Asia", "South East Asia", "Indonesia", "Central America", "Bolivia to Guiana", "Argta Chile Pgy Ugy", "Brazil.", "North Africa", "Sahel (Africa)", "Central Africa", "Southern Africa"};
    Map<String, qtset> regionCurves  = new HashMap();
    Map<String, qt> regionContributions = new HashMap();
    
    String p="";
    
    region regset;
    boolean disableloop = true; //if (!disableloop)
    
    void setupregions() {
	regionContributions.clear();
	regionCurves.clear();
	for (String s : regionsChosen){ //creating the qt and qtset maps
	    regionCurves.put(s, new qtset(s, 1850, 2005, 5));
	    regionContributions.put(s, new qt());
	}
	
	get(socreg.class).regions.choose(regman.allreg.find("JCM 25 Region Set")); //JCM25 NATIONS
	regset = (region)(get(socreg.class).regions.chosen);
    }
    
    public void run() {
	//regset = (region)socreg.regions.chosen;
	
	setupregions();
	
	link(rs.surftemp); //alternatively: plot(cc.sosi);
	
	for (Object lu : cl.lucsources){ cl.lucsource.set(lu);
	if (cl.lucsource.chosen.equals("Houghton"))
	    for (double cor=784; cor<=2700; cor+=229) { //2700
	    cl.landuseemit1990.set(cor);
	    log("Houghton emission in 2000 "+cor); calc();
	    } else if (cl.lucsource.chosen.equals("IVIGmodel")) {
	    for (LUCdata.biomeclassification bc : LUCdata.biomeclassification.values()) { cl.biomeclass.set(bc); log("-sIVIGmodel land use "+bc);
	    if (cl.biomeclass.chosen==LUCdata.biomeclassification.A) ivigmodeloop();
	    else {
		ivigmodeloop();
		cl.isam.set(true);
		ivigmodeloop();
		cl.isam.set(false);
	    }
	    ;
	    } // for biome A and B
	    } // if IVIGmodel
	} // for lucsources
	
	//for (String s : regionsChosen)  plot(regionCurves.get(s));
	lineplot.thin = 1000;
	
	for (String s : regionsChosen){
	    datable.savetable(new File("results"+fs+s+".tab"), regionCurves.get(s), "tab") ;
	}
	log("All tables saved");
	
	end();
	log("End of script contribtemp");
	cl.lucsource.choose("IVIGmodel");
    }
    
    public void ivigmodeloop(){
	for (double vc=0.8; vc<=1.2; vc+=0.2) { cl.vegcerror.set(vc); log("- veg carbon error "+vc); //0.2
	for (double sa=0.1; sa<=0.3; sa+=0.1) { cl.soillossagric.set(sa); log("- agric soil loss "+sa); //0.1
	for (double sp=0.05; sp<=0.1; sp+=0.025) { cl.soillosspast.set(sp); log("- past soil loss "+sp); //.025
	//units.round(cc.error, (double)1, 1);
	
	p = units.round(vc,(double)1, 1) +" "+units.round(sa,(double)1, 1)+" "+units.round(sp,(double)1, 2)+"_";
	calc();
	} // for soillosspqst
	} // for soillossqgric
	} // for vegetqtion carbon
    }
    
    public void calc(){
	
	for (double beta=0.56; beta>=0; beta-=0.28) { bc.beta.set(beta);//beta-=0.28
	for (double respq10=0.6; respq10<=1.6; respq10+=0.3 ) { bc.respq10.set(respq10);//respq10+=0.3 ??min 0.6?
	for (double diffu=1.75; diffu>=0.5; diffu-=0.5) { bc.diffufac.set(diffu);//diffu-=0.5
	
	checkbut(); // andsleep(500);
	loop.gonow(false);
	
	String err = units.round(cc.error, (double)1, 0);
	String c = " " ; c = cl.lucsource.chosen.equals("IVIGmodel") ? (cl.biomeclass.chosen==LUCdata.biomeclassification.A ? "-A_"
		: !cl.isam.istrue() ? "-B_" : "-B/ISAM_")+p : "_"+cl.landuseemit1990.getval()+"_" ;
	String name = cl.lucsource.chosen+c+beta+" "+respq10+" "+diffu+"_"+err;
	//report(cl.lucsource.chosen+c, err, beta, respq10, diffu);
	
	if (cc.error<=2700){ //700
	    report(name);
	    for (int y = 1850; y<=2005; y++) tot.set(y, 0);
	    for (region r : regset.reg) for (int y = 1850; y<=2005; y++)
		tot.set(y, (tot.get(y) + rs.surftemp.get(r, y)));
	    
	    for (int y = 1850; y<=2005; y++)
		for (String s : regionsChosen)
		    regionContributions.get(s).set(y, (rs.surftemp.get(regset.find(s), y) * 100 /  tot.get(y)));
		
		Color col=Color.black;
		
		try {  col=new Color(
			//(int)((cc.error-450)/1.5),(int)(3000/(cc.error-450)), 100 //RGB
			(int)(255 * (cl.lucsource.chosen.equals("IVIGmodel") ? 0 : 1)),
			(int)(255 * (cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (cl.biomeclass.chosen==LUCdata.biomeclassification.A  ? 1 : 0)),
			(int)(255 * (cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (cl.biomeclass.chosen==LUCdata.biomeclassification.A  ? 0 : 1))
			, (int)(3000 / (cc.error-450))
			); } catch (Exception e) {};
			
			for (String s : regionsChosen)
			    regionCurves.get(s).add(regionContributions.get(s).cloneIndependent(1850, 2005, 5, name, col));
			
			//curves1.add(rs.surftemp.reg(regset.find("Brazil.")).clone(1850, 2005, 5, name, col)); //absolute
			//curves2.add(tot.clone(1850, 2005, 5, name, col));
			
	} // if error <
	else log(name+" Bypassed, error > 700!");
	
	} //for diffu
	} //for respa
	} //for beta
    } // calc
}
