/*
  Created by Chris on 13 janvier 2006, 16:55
 */

package jcm.script;

import java.awt.Color;
import jcm.core.loop;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.units;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carboncycle;
import jcm.mod.reg.*;
import jcm.mod.soc.responsibility;
import jcm.mod.soc.socreg;
import static jcm.core.report.*;

public class contribtemp extends calcscript {
    
    berncarbon bc=get(berncarbon.class);
    carboncycle cc=get(carboncycle.class);
    CalcLucEmit cl=get(CalcLucEmit.class);
    responsibility rs = get(responsibility.class);
    
    qtset curves1=new qtset("Brazil. relative", 1850, 2005, 5);
    qtset curves2=new qtset("USA relative", 1850, 2005, 5);
    qtset curves3=new qtset("India relative", 1850, 2005, 5);
    qt tot = new qt("surftemp", "degcbase");
    qt r1 = new qt();
    qt r2 = new qt();
    qt r3 = new qt();
    
    String p="";
    
    region regset;
    
    /** Creates a new instance of contribtemp */
    public void run() {
	//regset = (region)socreg.regions.chosen;
	
	link(rs.surftemp); //alternatively: plot(cc.sosi);
	get(socreg.class).regions.choose(regman.allreg.find("JCM25"));
	regset = (region)(get(socreg.class).regions.chosen);
	
	for (Object lu : cl.lucsources){ cl.lucsource.set(lu);
	if (cl.lucsource.chosen.equals("Houghton"))
	    for (double cor=1700; cor<=2500; cor+=458) {
	    cl.landuseemit1990.set(cor);
	    log("Houghton emission in 2000 "+cor); calc();
	    } else if (cl.lucsource.chosen.equals("IVIGmodel")) {
	    for (LUCdata.biomeclassification bc : LUCdata.biomeclassification.values()) { cl.biomeclass.set(bc); log("IVIGmodel land use "+bc);
	    for (double vc=0.8; vc<=1.2; vc+=0.2) { cl.vegcerror.set(vc); log("-veg carbon error "+vc);
	    for (double sa=0.1; sa<=0.3; sa+=0.1) { cl.soillossagric.set(sa); log("-agric soil loss "+sa);
	    for (double sp=0.05; sp<=0.1; sp+=0.025) { cl.soillosspast.set(sp); log(" past soil loss "+sp);
	    //units.round(cc.error, (double)1, 1);
	    p = units.round(vc,(double)1, 1) +" "+units.round(sa,(double)1, 1)+" "+units.round(sp,(double)1, 2)+"_";
	    calc();
	    } // for soillosspqst
	    } // for soillossqgric
	    } // for vegetqtion carbon
	    } // for biome A and B
	    } // if IVIGmodel
	} // for lucsources
	
	//Component c1 = plot(curves1);
	//imagesaver.saveimage(c1, "png", new File("C:\\Dados_PiresdeCampos\\"+curves1.name+".png"));
	//plot(curves1);
	plot(curves2);
	plot(curves3);
	
	end();
	log("End of script contribtemp");
	cl.lucsource.choose("IVIGmodel");
    }
    
    public void calc(){
	
	for (double beta=0.56; beta>=0; beta-=0.28) { bc.beta.set(beta);//beta-=0.14
	for (double respq10=1.0; respq10<=1.6; respq10+=0.3 ) { bc.respq10.set(respq10);//respq10+=0.2
	for (double diffu=1.75; diffu>=0.5; diffu-=0.5) { bc.diffufac.set(diffu);//diffu-=0.25
	
	checkbut(); // andsleep(500);
	loop.gonow(false);
	
	String err = units.round(cc.error, (double)1, 0);
	String c = " " ; c = cl.lucsource.chosen.equals("IVIGmodel") ? "-"+cl.biomeclass.chosen.name()+"_"+p : "_"+cl.landuseemit1990.getval()+"_" ;
	String name = cl.lucsource.chosen+c+err+"_"+beta+" "+respq10+" "+diffu;
	//report(cl.lucsource.chosen+c, err, beta, respq10, diffu);
	
	if (cc.error<=700){
	    report(name);
	    for (int y = 1850; y<=2005; y++) tot.set(y, 0);
	    for (region r : regset.reg) for (int y = 1850; y<=2005; y++)
		tot.set(y, (tot.get(y) + rs.surftemp.get(r, y)));
	    
	    for (int y = 1850; y<=2005; y++){
		r1.set(y, (rs.surftemp.get(regset.find("Brazil."), y) * 100 /  tot.get(y)));
		r2.set(y, (rs.surftemp.get(regset.find("United States"), y) * 100 /  tot.get(y)));
		r3.set(y, (rs.surftemp.get(regset.find("India"), y) * 100 /  tot.get(y)));
	    }
	    Color col=Color.black;
	    
	    try {  col=new Color(
		    //(int)((cc.error-450)/1.5),(int)(3000/(cc.error-450)), 100 //RGB
		    (int)(255 * (cl.lucsource.chosen.equals("IVIGmodel") ? 0 : 1)),
		    (int)(255 * (cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (cl.biomeclass.chosen==LUCdata.biomeclassification.A ? 1 : 0)),
		    (int)(255 * (cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (cl.biomeclass.chosen==LUCdata.biomeclassification.A  ? 0 : 1))
		    , (int)(5000 / (cc.error-450))
		    ); } catch (Exception e) {};
		    
		    curves1.add(r1.cloneIndependent(1850, 2005, 5, name, col));
		    curves2.add(r2.cloneIndependent(1850, 2005, 5, name, col));
		    curves3.add(r3.cloneIndependent(1850, 2005, 5, name, col));
		    
		    //curves1.add(rs.surftemp.reg(regset.find("Brazil.")).clone(1850, 2005, 5, name, col)); //absolute
		    //curves2.add(tot.clone(1850, 2005, 5, name, col));
		    
	} // if error <
	else log(name+" Bypassed, error > 700!");
	
	} //for diffu
	} //for respa
	} //for beta
    } // calc
    
}
