//P2 make a checklist on how to send and run scripts in ASTR system (ozone)


package jcm.script;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.*;
import java.io.File;
import javax.swing.*;
import jcm.core.*;
import jcm.core.itf.plotlink;
import jcm.gui.gen.processdialog;
import jcm.gui.nav.showpan;
import jcm.gui.plot.lineplot;
import static jcm.core.report.*;

public class calcscript extends Thread implements ActionListener, plotlink {
    
        
      final String fs=File.separator;
    
    //*********************************************
    /*Some Useful Methods
     * setup.loadsetup(File file);
     * new world(name);
     * world.get(name);
     * loop.go();
     * param.scriptmode.set("delay"); //changes are not put into effect until next loop.go()
     * param.scriptmode.choose("direct"); //must put it back at the end or you disable changes from the GUI
     * param.reportchange=false; //less output in serr/sout
     * paramP.set(double or boolean) // for values or true/false
     * paramP.choose(String or Object) // for menus
     * register.addlink(this, qtsetQ); //forces interactions to calculate as necessary, note can no longer set output=true (it won't persist)
     * showpan.makepan(lineplot.class, qtsetQ, point P)); //or datable, histoplot, mapplot, etc., note this returns the Component
     * note qtsetQ could be an array of several qtsets in some cases
     * 	try { sleep(milliseconds); } catch ( InterruptedException e) {};
     * imagesaver.saveimage(Component, filename, type)
     * datable.savetable(...)
     * fileio methods e.g. savetextfile, loadtab
     *
     * //to avoid problems with user-interaction with the gui, anything that changes graphics could use:
     * //maybe these could be an option inside loop?
     * SwingUtilities.invokeLater(new Runnable() { public void run() { DO SOMETHING HERE }}); //or use invokeAndWait, to force user to wait
     *
     */
    
    //***********************************************
    //overwrite this to do something useful
    public void run() {
	log("Running "+getClass().getSimpleName());
	end();
    }
    
    //***********************************************
    // worlds, modules
    public world currentworld=world.worlds.get(0);
    public <T extends module> T    get(Class<T> c) { return currentworld.get(c); }
    
    //****************************************
    //scriptmode, //note instanceof won't work if run() called from another Thread as in processdialog
    public static param scriptmode=new param("scriptmode", (new String[] {	"demo", "direct", "delay"}), "delay");
    public static boolean delayloop(){ 	return (currentThread() instanceof calcscript) && scriptmode.chosen.equals("delay");     }
    
    //***********************************************
    //plotlink for interactions
    public void link(interacob qq) { register.addlink(this, qq); }
    public JComponent plot(qtset qq) { return showpan.makepan(lineplot.class, qq); }
    public boolean isShowing() { return isAlive(); }
    public void doplot() { }  //info.setText("doplot called on script"); } //use this to check interactions are OK
    public void resize(JComponent c, int x, int y,int w, int h){        
    		    setup.setsizeloc(c, new Point(x,y), new Dimension(w, h)); //chenged ben 14feb06 + 7jan07
    }
    
    //***************************
    public void report(Object ... o) {
	String r=join("\t", o);
	info.setText(r);
	log(r);
    }
    public String join(String sep, Object ... o) { String r=""; for (Object oo : o) r+=sep+oo.toString(); return r;    }
    
    //************************
    //this section provides a process dialogue with Pause and Stop/Restart buttons
    //call checkbut from inner loops to allow the buttons to stop the thread,
    //note, the processdialog could use it's own Thread to call this Runnable, only a bit less convenient for sleep etc.
    //note when move to Java1.6 maybe easier to use SwingWorker
    //or the buttons might be done more elegantly using synchronized /wait / notifyAll
    
    processdialog pd;
    JLabel info=new JLabel(" info about the script "+getClass().getSimpleName()); //can change this during the process to show what's going on
    JToggleButton pab=new JToggleButton("Pause"), gob=new JToggleButton("Stop");
    //JButton gob=new BasicArrowButton(SwingConstants.RIGHT);
  
    public void start() {
	//param.scriptmode.choose("delay");
	gob.addActionListener(this);
	setPriority(Thread.MIN_PRIORITY);
	setName("JCMScript"+getClass().getSimpleName()+System.currentTimeMillis());
	pd=new processdialog(this, getClass().getSimpleName(), info, pab, gob); //this will call run, and the pd will disappear when done
	super.start();
    }
    
    public void end() { //note this is not called automatically - needs to be at end of run!
	showpan.dispose(pd.b);
    }
    
    public void checkbut() throws RuntimeException {
	if (gob.isSelected() ) {
	    if (gob.getText().equals("Stop")) { gob.setText("Restart");  throw new RuntimeException("Script Interrupted");   }
	    gob.setSelected(false);
	}
	Thread.yield();
	try { while (pab.isSelected()) {
	    Thread.currentThread().sleep(100);
	} } catch (Exception ex) { deb(ex); }
    }
    
    public void checkbutandsleep(int n) {
	checkbut();   try { sleep(n); } catch (Exception ex) { deb(ex); }
    }
    
    public void actionPerformed(ActionEvent e) {
	if (gob.getText().equals("Restart")) {
	    try {getClass().newInstance().start(); } catch (Exception ex) {deb(ex);}
	    showpan.dispose(pd.b);
	}
    }
    
    
    
//**********************************************
//old methods were used by JCM4 scripts -not recommended for future
    public interacob f(String a) {return register.findiob(a); }
    public String v(String a) {	return ((param)f(a)).getstringval(); }
    public void s(String a, String b) {	((param)f(a)).set(b); }
    public void d(String a) { log(a); }
    public void d(Object a) { log(a.toString()); }
    
    /*
    boolean loading=false;
    public String task="";
    public String out="", allout="";
     */
    
    
    
}
  /* using action listener doesn't help because it's called from swing thread not calcscript thread,
     and the exception would pass to swing
     (interupted exception won't compile, runtime doesn't stop this thread, unless you call sleep, may as well call checkcb instead)
   
     gob.addActionListener(this);
   
    public void actionPerformed(ActionEvent e) {
	System.err.println("hello AP " +e);
	throw new RuntimeException();
//interrupt();
//	try {
//	    checkcb();
//	} catch (InterruptedException ex) {ex.printStackTrace(); }
    }
   */