//**************** SRES EXTENSON ****************
/*SRES extension beyond 2100 for pop, gdp, en ,fossil
 
P3 currently, the totals change slightly with the region set -i.e. there is an effect of resolution
this is logical (due to nonlinear factors) but not desirable (both for simplicity and efficiency),
 maybe could calc global separately, then apply a topdownscale?
 */

package jcm.mod.soc;

import java.util.HashMap;
import java.util.Map;
import jcm.core.*;
import jcm.mod.obj.*;
import jcm.core.reg.region;
import static jcm.core.complexity.*;
import jcm.mod.obj.globco2emit;

public class sresext extends module {
    
    public param extend=new param("extend", new String[] {	"fixed", "linear", "exp-const", "exp-reg"}, "exp-reg", experimental);
    
    //references
    qtset pop, gdp, energy, emitfosbase;
    region regset;
    int sc;
    //factors for trends
    Map<region, Float> popfac=new HashMap(), gpcfac=new HashMap(), epgfac=new HashMap();
    
    
    public void initsetup() {
	follows(futbasescen.class);
	setaffectedby(AviaShipEmit.class); //due to subtraction of bunker from SRES, affects starting point
	//note also affected by scaling in globco2emit - but that shouldn't change unless futbasescen or aviaship does - and doesn't apply in same year so no order problem
	socio socio=get(socio.class); 	pop=socio.pop; gdp=socio.gdp; energy=socio.energy;
	emitfosbase=get(socreg.class).emitfosbase;
    }
    
    public void precalc() {
	sc=get(futbasescen.class).scenario.getchosenindex();
	regset=(region) get(socreg.class).regions.chosen;
    }
    
    
    public void calcstep() {
	
	if (year>2100) {
	    for (region r : regset.reg)  {
		pop.setreg(r); gdp.setreg(r); energy.setreg(r); emitfosbase.setreg(r);
		
		//calculate rates of change at end of SRES
		if (year==2101) {
		    if (extend.chosen.equals("linear")) {
			popfac.put(r, (pop.get(2100) - pop.get(2090))/10f);
			gpcfac.put(r, ((gdp.get(2100)/pop.get(2100)) - (gdp.get(2090)/pop.get(2090)) )/10f);
			epgfac.put(r, ((emitfosbase.get(2100)/gdp.get(2100)) - (emitfosbase.get(2090)/gdp.get(2090)) )/10f);
		    }
		    if (extend.chosen.equals("exp-const") || extend.chosen.equals("exp-reg")  ){
			popfac.put(r, pop.get(2100) / pop.get(2099));
			gpcfac.put(r, (gdp.get(2100)/pop.get(2100)) / (gdp.get(2099)/pop.get(2099)));
			epgfac.put(r, (emitfosbase.get(2100)/gdp.get(2100)) / (emitfosbase.get(2099)/gdp.get(2099)));
		    }
		}
		
		if (extend.chosen.equals("fixed")) {	//could replace this with linear and facs set to zero
		    pop.set(pop.get(year-1));
		    gdp.set(gdp.get(year-1));
		    energy.set(energy.get(year-1));
		    emitfosbase.set(emitfosbase.get(year-1));
		    
		}
		if (extend.chosen.equals("linear")) {
		    pop.set(pop.get(year-1)+popfac.get(r));
		    gdp.set(pop.get()*(gdp.get(year-1)/pop.get(year-1)+gpcfac.get(r)));
		    emitfosbase.set(gdp.get()*(emitfosbase.get(year-1)/gdp.get(year-1)+epgfac.get(r)));
		}
		if (extend.chosen.equals("exp-const") || extend.chosen.equals("exp-reg")  ){
		    pop.set(pop.get(year-1)*popfac.get(r));
		    gdp.set(pop.get()*(gdp.get(year-1)/pop.get(year-1))* gpcfac.get(r));
		    emitfosbase.set(gdp.get()*(emitfosbase.get(year-1)/gdp.get(year-1))*epgfac.get(r));
		}
		
		if (extend.chosen.equals("exp-reg") ){
		    float gpc=gdp.get()/pop.get();
		    popfac.put(r, (1f-sfpop)*popfac.get(r)+ sfpop*(popreg1-popreg2*(float)Math.log(gpc)));
		    gpcfac.put(r,  (1f-sfgpc)*gpcfac.get(r)+ sfgpc*(1f+gpcgrow0[sc]*(float)Math.exp(-gpc*gpcgrowk[sc])));
		    epgfac.put(r, (1f-sfepg)*epgfac.get(r)+ sfepg*(1f+epggrow0[sc]*(float)Math.exp(-gpc*epggrowk[sc])));
		}
	    } //reg
	    
	    pop.calctot(); energy.calctot(); gdp.calctot();
	    get(globco2emit.class).fossilbase.set(emitfosbase.calctot());
	} //>2100
	
	
    } //sresext calcstep
    
    //***************************************************
// regressions based on 2045-2095 (all 12 JCM regions together), for six scenarios A1B, T, F, A2, B1, B2
    static final float[] gpcgrow0={	0.075f, 0.075f, 0.075f, 0.030f, 0.064f, 0.030f }; //growth in gdp/cap (frac) if gdp/cap=0
    static final float[] gpcgrowk={	0.0143f, 0.0143f, 0.0143f, 0.0179f, 0.0255f, 0.0179f }; //exp decay rate of growth as function of 0.001*gdp/cap
    static final float[] epggrow0={	-0.033f, -0.037f, -0.025f, -0.018f, -0.042f, -0.018f }; //decline in emit/gdp (frac) if gdp/cap=0
    static final float[] epggrowk={	0.00606f, 0.00114f, 0.00916f, 0.0128f, 0.0110f, 0.00944f }; //exp decay rate of decline as function of 0.001*gdp/cap
    
    static final float popreg1=1.013f , popreg2=0.004f; //as gpcreg but for popn growth, based on B2 scenario only
//note: for other scenarios there is no clear correlation
//eventually should replace these with UN2300 scenarios
    
    static final float sfgpc=0.05f, sfepg=0.05f, sfpop=0.02f; // amount by which growth rates tend towards regression function each year
    
    
}
